/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;

public class NoToStringOnStringType
extends Recipe {
    private static final MethodMatcher TO_STRING = new MethodMatcher("java.lang.String toString()");

    public String getDisplayName() {
        return "Unnecessary String#toString()";
    }

    public String getDescription() {
        return "Remove unnecessary `String#toString()` invocations on objects which are already a string.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod<ExecutionContext>(TO_STRING);
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1858");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){
            private final JavaTemplate t = JavaTemplate.builder(() -> (this).getCursor(), "#{any(java.lang.String)}").build();

            @Override
            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, ctx);
                if (TO_STRING.matches(mi)) {
                    return mi.withTemplate(this.t, mi.getCoordinates().replace(), mi.getSelect());
                }
                return mi;
            }
        };
    }
}

