/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.cleanup.LambdaBlockToExpression;
import org.openrewrite.java.cleanup.UnnecessaryParenthesesVisitor;
import org.openrewrite.java.style.Checkstyle;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;

public class UseLambdaForFunctionalInterface
extends Recipe {
    public String getDisplayName() {
        return "Use lambdas where possible";
    }

    public String getDescription() {
        return "Instead of anonymous class declarations, use a lambda where possible.";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-1604");
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){

            @Override
            public J visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
                JavaType.Class type;
                J.NewClass n = (J.NewClass)super.visitNewClass(newClass, ctx);
                if (n.getBody() != null && n.getBody().getStatements().size() == 1 && n.getBody().getStatements().get(0) instanceof J.MethodDeclaration && n.getClazz() != null && (type = TypeUtils.asClass(n.getClazz().getType())) != null && type.getKind().equals((Object)JavaType.FullyQualified.Kind.Interface)) {
                    JavaType.Method sam = null;
                    for (JavaType.Method method : type.getMethods()) {
                        if (method.hasFlags(Flag.Default) || method.hasFlags(Flag.Static)) continue;
                        if (sam != null) {
                            return n;
                        }
                        sam = method;
                    }
                    if (sam == null) {
                        return n;
                    }
                    StringBuilder templateBuilder = new StringBuilder();
                    J.MethodDeclaration methodDeclaration = (J.MethodDeclaration)n.getBody().getStatements().get(0);
                    if (methodDeclaration.getParameters().get(0) instanceof J.Empty) {
                        templateBuilder.append("() -> {");
                    } else {
                        templateBuilder.append(methodDeclaration.getParameters().stream().map(param -> ((J.VariableDeclarations)param).getVariables().get(0).getSimpleName()).collect(Collectors.joining(",", "(", ") -> {")));
                    }
                    JavaType returnType = sam.getReturnType();
                    if (!JavaType.Primitive.Void.equals(returnType)) {
                        templateBuilder.append("return ").append(this.valueOfType(returnType)).append(';');
                    }
                    templateBuilder.append('}');
                    J.Lambda lambda = (J.Lambda)n.withTemplate(JavaTemplate.builder(() -> (this).getCursor(), templateBuilder.toString()).build(), n.getCoordinates().replace(), new Object[0]);
                    lambda = (J.Lambda)new UnnecessaryParenthesesVisitor(Checkstyle.unnecessaryParentheses()).visitNonNull(lambda, ctx);
                    J.Block lambdaBody = methodDeclaration.getBody();
                    assert (lambdaBody != null);
                    lambda = lambda.withBody(lambdaBody.withPrefix(Space.format(" ")));
                    lambda = (J.Lambda)new LambdaBlockToExpression().getVisitor().visitNonNull((Tree)lambda, (Object)ctx);
                    return this.autoFormat(lambda, ctx, this.getCursor().getParentOrThrow());
                }
                return n;
            }

            private String valueOfType(@Nullable JavaType type) {
                JavaType.Primitive primitive = TypeUtils.asPrimitive(type);
                if (primitive != null) {
                    switch (primitive) {
                        case Boolean: {
                            return "true";
                        }
                        case Byte: 
                        case Char: 
                        case Int: 
                        case Double: 
                        case Float: 
                        case Long: 
                        case Short: {
                            return "0";
                        }
                        case String: 
                        case Null: {
                            return "null";
                        }
                    }
                    return "";
                }
                return "null";
            }
        };
    }
}

