/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TextComment;

public class SingleLineComments
extends Recipe {
    public String getDisplayName() {
        return "Single line comments begin with a whitespace";
    }

    public String getDescription() {
        return "Write `// hi` instead of `//hi`.";
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public Space visitSpace(Space space, Space.Location loc, ExecutionContext ctx) {
                return space.withComments(ListUtils.map(space.getComments(), c -> {
                    TextComment tc;
                    if (!c.isMultiline() && !(tc = (TextComment)c).getText().startsWith(" ")) {
                        return tc.withText(" " + tc.getText());
                    }
                    return c;
                }));
            }
        };
    }
}

