/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal.template;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.java.tree.TypeUtils;

public class BlockStatementTemplateGenerator {
    private static final String TEMPLATE_COMMENT = "__TEMPLATE__";
    private static final String EXPR_STATEMENT_PARAM = "class __P__ {  static native <T> T p();  static native <T> T[] arrp();  static native boolean booleanp();  static native byte bytep();  static native char charp();  static native double doublep();  static native int intp();  static native long longp();  static native short shortp();  static native float floatp();}";
    private static final String METHOD_INVOCATION_STUBS = "class __M__ {  static native Object any(Object o);  static native <T> Object anyT();}";
    private final Set<String> imports;

    public String template(Cursor cursor, String template, Space.Location location) {
        return (String)Timer.builder((String)"rewrite.template.generate.statement").register((MeterRegistry)Metrics.globalRegistry).record(() -> {
            StringBuilder before = new StringBuilder();
            StringBuilder after = new StringBuilder();
            if (cursor.getValue() instanceof J.MethodDeclaration && location.equals((Object)Space.Location.BLOCK_PREFIX)) {
                J.MethodDeclaration method = (J.MethodDeclaration)cursor.getValue();
                J.MethodDeclaration m = method.withBody(null).withLeadingAnnotations(Collections.emptyList()).withPrefix(Space.EMPTY);
                before.insert(0, m.printTrimmed(cursor).trim() + '{');
                after.append('}');
            }
            this.template(this.next(cursor), (J)cursor.getValue(), before, after, Collections.newSetFromMap(new IdentityHashMap()));
            return before.toString().trim() + "\n/*" + TEMPLATE_COMMENT + "*/" + template + "\n" + after;
        });
    }

    public <J2 extends J> List<J2> listTemplatedTrees(JavaSourceFile cu, final Class<J2> expected) {
        final ArrayList js = new ArrayList();
        new JavaIsoVisitor<Integer>(){
            boolean done = false;
            @Nullable
            J.Block blockEnclosingTemplateComment;

            @Override
            public J.Block visitBlock(J.Block block, Integer p) {
                J b = super.visitBlock(block, p);
                if (b == this.blockEnclosingTemplateComment) {
                    this.done = true;
                }
                return b;
            }

            @Nullable
            public J visit(@Nullable Tree tree, Integer p) {
                if (this.done) {
                    return (J)tree;
                }
                if (expected.isInstance(tree)) {
                    J t = (J)tree;
                    if (this.blockEnclosingTemplateComment != null) {
                        js.add(t);
                        return t;
                    }
                    List<Comment> comments = t.getPrefix().getComments();
                    for (int i = 0; i < comments.size(); ++i) {
                        Comment comment = comments.get(i);
                        if (!(comment instanceof TextComment) || !((TextComment)comment).getText().equals(BlockStatementTemplateGenerator.TEMPLATE_COMMENT)) continue;
                        this.blockEnclosingTemplateComment = (J.Block)this.getCursor().firstEnclosing(J.Block.class);
                        js.add(t.withPrefix(t.getPrefix().withComments(comments.subList(i + 1, comments.size()))));
                        return t;
                    }
                }
                return (J)super.visit(tree, (Object)p);
            }
        }.visit(cu, 0);
        return js;
    }

    private void template(Cursor cursor, J prior, StringBuilder before, StringBuilder after, Set<J> templated) {
        J.If iff;
        templated.add((J)cursor.getValue());
        J j = (J)cursor.getValue();
        if (j instanceof JavaSourceFile) {
            before.insert(0, "class __P__ {  static native <T> T p();  static native <T> T[] arrp();  static native boolean booleanp();  static native byte bytep();  static native char charp();  static native double doublep();  static native int intp();  static native long longp();  static native short shortp();  static native float floatp();}class __M__ {  static native Object any(Object o);  static native <T> Object anyT();}");
            JavaSourceFile cu = (JavaSourceFile)j;
            for (J.Import import_ : cu.getImports()) {
                before.insert(0, import_.withPrefix(Space.EMPTY).printTrimmed(cursor) + ";\n");
            }
            for (String string : this.imports) {
                before.insert(0, string);
            }
            if (cu.getPackageDeclaration() != null) {
                before.insert(0, cu.getPackageDeclaration().withPrefix(Space.EMPTY).printTrimmed(cursor) + ";\n");
            }
            return;
        }
        if (j instanceof J.Block) {
            J parent = (J)this.next(cursor).getValue();
            if (parent instanceof J.ClassDeclaration) {
                this.classDeclaration(prior, before, (J.ClassDeclaration)parent, templated, cursor);
            } else if (parent instanceof J.MethodDeclaration) {
                J.MethodDeclaration m = (J.MethodDeclaration)parent;
                assert (m.getBody() != null);
                for (Statement statement : m.getBody().getStatements()) {
                    if (statement == prior) break;
                    if (!(statement instanceof J.VariableDeclarations)) continue;
                    before.insert(0, "\n" + this.variable((J.VariableDeclarations)statement, true, cursor) + ";\n");
                }
                if (m.getReturnTypeExpression() != null && !JavaType.Primitive.Void.equals(m.getReturnTypeExpression().getType())) {
                    before.insert(0, "if(true) {");
                    after.append("}\nreturn ").append(this.valueOfType(m.getReturnTypeExpression().getType())).append(";\n");
                }
                before.insert(0, m.withBody(null).withLeadingAnnotations(Collections.emptyList()).withPrefix(Space.EMPTY).printTrimmed(cursor).trim() + '{');
            } else if (parent instanceof J.Block || parent instanceof J.Lambda) {
                J.Block b = (J.Block)j;
                for (Statement statement : b.getStatements()) {
                    if (statement == prior) break;
                    if (!(statement instanceof J.VariableDeclarations)) continue;
                    before.insert(0, "\n" + this.variable((J.VariableDeclarations)statement, true, cursor) + ";\n");
                }
                before.insert(0, "{\n");
                if (b.isStatic()) {
                    before.insert(0, "static");
                }
            } else {
                before.insert(0, "{\n");
            }
            after.append('}');
            if (parent instanceof J.Lambda) {
                after.append(';');
            }
        } else if (j instanceof J.NewClass) {
            J.NewClass n = (J.NewClass)j;
            if (n.getArguments() != null && n.getArguments().stream().noneMatch(arg -> arg == prior)) {
                n = n.withBody(null).withPrefix(Space.EMPTY);
                before.insert(0, n.printTrimmed(cursor).trim());
                after.append(';');
            }
        } else if (j instanceof J.ForLoop) {
            J.ForLoop f = (J.ForLoop)j;
            f = f.withBody(null).withPrefix(Space.EMPTY).withControl(f.getControl().withCondition(null).withUpdate(Collections.emptyList()));
            before.insert(0, f.printTrimmed(cursor).trim());
        } else if (j instanceof J.ForEachLoop) {
            J.ForEachLoop f = (J.ForEachLoop)j;
            f = f.withBody(null).withPrefix(Space.EMPTY);
            before.insert(0, f.printTrimmed(cursor).trim());
        } else if (j instanceof J.Try) {
            J.Try t = (J.Try)j;
            if (t.getResources() != null) {
                before.insert(0, ")");
                for (J.Try.Resource resource : t.getResources()) {
                    before.insert(0, resource.withPrefix(Space.EMPTY).printTrimmed(cursor).trim() + ';');
                }
                before.insert(0, "try(");
            }
        } else if (j instanceof J.Lambda) {
            J.Lambda l = (J.Lambda)j;
            before.insert(0, "{ if(true) {");
            after.append("}\nreturn ").append(this.valueOfType(l.getType())).append(";\n};\n");
            before.insert(0, l.withBody(null).withPrefix(Space.EMPTY).printTrimmed(cursor).trim());
        } else if (j instanceof J.VariableDeclarations) {
            before.insert(0, this.variable((J.VariableDeclarations)j, false, cursor) + '=');
        } else if (j instanceof J.MethodInvocation) {
            J.MethodInvocation m = (J.MethodInvocation)j;
            if (m.getArguments().stream().anyMatch(arg -> arg == prior)) {
                before.insert(0, "__M__.any(");
                if (cursor.getParentOrThrow().firstEnclosing(J.class) instanceof J.Block) {
                    after.append(");");
                } else {
                    after.append(")");
                }
            } else if (m.getTypeParameters() != null && m.getTypeParameters().stream().anyMatch(tp -> tp == prior)) {
                before.insert(0, "__M__.anyT<");
                if (cursor.getParentOrThrow().firstEnclosing(J.class) instanceof J.Block) {
                    after.append(">();");
                } else {
                    after.append(">()");
                }
            }
        } else if (j instanceof J.Return) {
            before.insert(0, "return ");
            after.append(";");
        } else if (j instanceof J.If && prior == (iff = (J.If)j).getIfCondition()) {
            before.insert(0, "boolean __b" + cursor.getPathAsStream().count() + "__ =");
            after.append(";");
        }
        this.template(this.next(cursor), j, before, after, templated);
    }

    private void classDeclaration(@Nullable J prior, StringBuilder before, J.ClassDeclaration parent, Set<J> templated, Cursor cursor) {
        J.ClassDeclaration c = parent;
        List<Statement> statements = c.getBody().getStatements();
        for (int i = statements.size() - 1; i >= 0; --i) {
            Statement statement = statements.get(i);
            if (templated.contains(statement)) continue;
            if (statement instanceof J.VariableDeclarations) {
                before.insert(0, this.variable((J.VariableDeclarations)statement, false, cursor) + ";\n");
                continue;
            }
            if (statement instanceof J.MethodDeclaration) {
                if (statement == prior) continue;
                before.insert(0, this.method((J.MethodDeclaration)statement, cursor));
                continue;
            }
            if (statement instanceof J.ClassDeclaration) {
                before.insert(0, '}');
                this.classDeclaration(null, before, (J.ClassDeclaration)statement, templated, cursor);
                continue;
            }
            if (!(statement instanceof J.EnumValueSet)) continue;
            J.EnumValueSet enumValues = (J.EnumValueSet)statement;
            before.insert(0, ";");
            StringJoiner enumStr = new StringJoiner(",");
            for (J.EnumValue anEnum : enumValues.getEnums()) {
                enumStr.add(anEnum.getName().getSimpleName());
            }
            before.insert(0, enumStr);
        }
        c = c.withBody(null).withLeadingAnnotations(null).withPrefix(Space.EMPTY);
        before.insert(0, c.printTrimmed(cursor).trim() + '{');
    }

    private String method(J.MethodDeclaration method, Cursor cursor) {
        if (method.isAbstract()) {
            return "\n" + method.withPrefix(Space.EMPTY).printTrimmed(cursor).trim() + ";\n";
        }
        StringBuilder methodBuilder = new StringBuilder("\n");
        J.MethodDeclaration m = method.withBody(null).withLeadingAnnotations(Collections.emptyList()).withPrefix(Space.EMPTY);
        methodBuilder.append(m.printTrimmed(cursor).trim()).append('{');
        if (method.getReturnTypeExpression() != null && !JavaType.Primitive.Void.equals(method.getReturnTypeExpression().getType())) {
            methodBuilder.append("\nreturn ").append(this.valueOfType(method.getReturnTypeExpression().getType())).append(";\n");
        }
        methodBuilder.append("}\n");
        return methodBuilder.toString();
    }

    private String variable(J.VariableDeclarations variable, boolean initializer, Cursor cursor) {
        StringBuilder varBuilder = new StringBuilder();
        for (J.Modifier modifier : variable.getModifiers()) {
            varBuilder.append(modifier.getType().toString().toLowerCase()).append(' ');
        }
        List<J.VariableDeclarations.NamedVariable> variables = variable.getVariables();
        int variablesSize = variables.size();
        for (int i = 0; i < variablesSize; ++i) {
            J.VariableDeclarations.NamedVariable nv = variables.get(i);
            if (i == 0) {
                if (variable.getTypeExpression() != null) {
                    varBuilder.append(variable.getTypeExpression().withPrefix(Space.EMPTY).printTrimmed(cursor));
                }
                if (nv.getType() instanceof JavaType.Array) {
                    varBuilder.append("[]");
                }
                varBuilder.append(" ");
            }
            varBuilder.append(nv.getSimpleName());
            JavaType type = nv.getType();
            if (initializer && type != null) {
                varBuilder.append('=').append(this.valueOfType(type));
            }
            if (i >= variables.size() - 1) continue;
            varBuilder.append(',');
        }
        return varBuilder.toString();
    }

    private String valueOfType(@Nullable JavaType type) {
        JavaType.Primitive primitive = TypeUtils.asPrimitive(type);
        if (primitive != null) {
            switch (primitive) {
                case Boolean: {
                    return "true";
                }
                case Byte: 
                case Char: 
                case Int: 
                case Double: 
                case Float: 
                case Long: 
                case Short: {
                    return "0";
                }
                case String: 
                case Null: {
                    return "null";
                }
            }
            return "";
        }
        return "null";
    }

    private Cursor next(Cursor c) {
        return c.dropParentUntil(J.class::isInstance);
    }

    public BlockStatementTemplateGenerator(Set<String> imports) {
        this.imports = imports;
    }
}

