/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.List;
import java.util.Objects;
import org.openrewrite.Incubating;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;

@Incubating(since="6.0.0")
public class SemanticallyEqual {
    private SemanticallyEqual() {
    }

    public static boolean areEqual(J firstElem, J secondElem) {
        SemanticallyEqualVisitor sep = new SemanticallyEqualVisitor();
        sep.visit(firstElem, secondElem);
        return sep.isEqual;
    }

    private static class SemanticallyEqualVisitor
    extends JavaVisitor<J> {
        boolean isEqual = true;

        private SemanticallyEqualVisitor() {
        }

        @Override
        public J visitAnnotation(J.Annotation firstAnnotation, J second) {
            if (!(second instanceof J.Annotation)) {
                this.isEqual = false;
                return null;
            }
            J.Annotation secondAnnotation = (J.Annotation)second;
            if (firstAnnotation.getArguments() != null && secondAnnotation.getArguments() != null) {
                if (firstAnnotation.getArguments().size() == secondAnnotation.getArguments().size()) {
                    List<Expression> firstArgs = firstAnnotation.getArguments();
                    List<Expression> secondArgs = secondAnnotation.getArguments();
                    for (int i = 0; i < firstArgs.size(); ++i) {
                        this.visit(firstArgs.get(i), secondArgs.get(i));
                    }
                } else {
                    this.isEqual = false;
                    return null;
                }
            }
            this.visitTypeName((N)firstAnnotation.getAnnotationType(), secondAnnotation.getAnnotationType());
            return null;
        }

        @Override
        public J visitIdentifier(J.Identifier firstIdent, J second) {
            if (!(second instanceof J.Identifier)) {
                this.isEqual = false;
                return null;
            }
            J.Identifier secondIdent = (J.Identifier)second;
            this.isEqual = this.isEqual && SemanticallyEqualVisitor.typeEquals(firstIdent.getType(), secondIdent.getType()) && firstIdent.getSimpleName().equals(secondIdent.getSimpleName());
            return null;
        }

        @Override
        public J visitFieldAccess(J.FieldAccess firstFieldAccess, J second) {
            if (!(second instanceof J.FieldAccess)) {
                this.isEqual = false;
                return null;
            }
            J.FieldAccess secondFieldAccess = (J.FieldAccess)second;
            if ("class".equals(firstFieldAccess.getSimpleName())) {
                if (!"class".equals(secondFieldAccess.getSimpleName())) {
                    this.isEqual = false;
                    return null;
                }
                this.isEqual = this.isEqual && SemanticallyEqualVisitor.typeEquals(firstFieldAccess.getType(), secondFieldAccess.getType()) && SemanticallyEqualVisitor.typeEquals(firstFieldAccess.getTarget().getType(), secondFieldAccess.getTarget().getType());
            }
            return null;
        }

        @Override
        public J visitAssignment(J.Assignment firstAssignment, J second) {
            if (!(second instanceof J.Assignment)) {
                this.isEqual = false;
                return null;
            }
            J.Assignment secondAssignment = (J.Assignment)second;
            this.isEqual = this.isEqual && SemanticallyEqualVisitor.typeEquals(firstAssignment.getType(), secondAssignment.getType()) && SemanticallyEqual.areEqual(firstAssignment.getVariable(), secondAssignment.getVariable()) && SemanticallyEqual.areEqual(firstAssignment.getAssignment(), secondAssignment.getAssignment());
            return null;
        }

        @Override
        public J visitLiteral(J.Literal firstLiteral, J second) {
            if (!(second instanceof J.Literal)) {
                this.isEqual = false;
                return null;
            }
            J.Literal secondLiteral = (J.Literal)second;
            this.isEqual = this.isEqual && Objects.equals(firstLiteral.getValue(), secondLiteral.getValue());
            return null;
        }

        @Override
        public <N extends NameTree> N visitTypeName(N firstTypeName, J second) {
            if (!(second instanceof NameTree)) {
                this.isEqual = false;
                return null;
            }
            this.isEqual = this.isEqual && SemanticallyEqualVisitor.typeEquals(firstTypeName.getType(), ((NameTree)second).getType());
            return null;
        }

        private static boolean typeEquals(JavaType thisType, JavaType otherType) {
            if (thisType == null) {
                return otherType == null;
            }
            if (thisType instanceof JavaType.FullyQualified) {
                if (!(otherType instanceof JavaType.FullyQualified)) {
                    return false;
                }
                return ((JavaType.FullyQualified)thisType).getFullyQualifiedName().equals(((JavaType.FullyQualified)otherType).getFullyQualifiedName());
            }
            return thisType.equals(otherType);
        }
    }
}

