/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.trait.Reference;
import org.openrewrite.xml.tree.Xml;

public class PackageMatcher
implements Reference.Renamer,
Reference.Matcher {
    private final @Nullable String targetPackage;
    private final Boolean recursive;

    public PackageMatcher(@Nullable String targetPackage) {
        this(targetPackage, false);
    }

    public PackageMatcher(@Nullable String targetPackage, boolean recursive) {
        this.targetPackage = targetPackage;
        this.recursive = recursive;
    }

    public boolean matchesReference(Reference reference) {
        if (reference.getKind().equals((Object)Reference.Kind.TYPE) || reference.getKind().equals((Object)Reference.Kind.PACKAGE)) {
            String recursivePackageNamePrefix = this.targetPackage + ".";
            if (reference.getValue().equals(this.targetPackage) || this.recursive.booleanValue() && reference.getValue().startsWith(recursivePackageNamePrefix)) {
                return true;
            }
        }
        return false;
    }

    public TreeVisitor<Tree, ExecutionContext> rename(final String newValue) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (StringUtils.isNotEmpty((String)newValue)) {
                    if (tree instanceof Xml.Attribute) {
                        return ((Xml.Attribute)tree).withValue(((Xml.Attribute)tree).getValue().withValue(PackageMatcher.this.getReplacement(((Xml.Attribute)tree).getValueAsString(), PackageMatcher.this.targetPackage, newValue)));
                    }
                    if (tree instanceof Xml.Tag && ((Xml.Tag)tree).getValue().isPresent()) {
                        return ((Xml.Tag)tree).withValue(PackageMatcher.this.getReplacement((String)((Xml.Tag)tree).getValue().get(), PackageMatcher.this.targetPackage, newValue));
                    }
                }
                return super.visit(tree, (Object)ctx);
            }
        };
    }

    String getReplacement(String value, @Nullable String oldValue, String newValue) {
        if (oldValue != null) {
            if (this.recursive.booleanValue()) {
                return value.replace(oldValue, newValue);
            }
            if (value.startsWith(oldValue) && Character.isUpperCase(value.charAt(oldValue.length() + 1))) {
                return value.replace(oldValue, newValue);
            }
        }
        return value;
    }

    @Generated
    public @Nullable String getTargetPackage() {
        return this.targetPackage;
    }

    @Generated
    public Boolean getRecursive() {
        return this.recursive;
    }
}

