/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.JavadocVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.DeclaresMethod;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Javadoc;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.marker.SearchResult;

public class UseStaticImport
extends Recipe {
    @Option(displayName="Method pattern", description="A method pattern that is used to find matching method invocations.", example="java.util.Collections emptyList()")
    private final String methodPattern;

    public String getDisplayName() {
        return "Use static import";
    }

    public String getDescription() {
        return "Removes unnecessary receiver types from static method invocations. For example, `Collections.emptyList()` becomes `emptyList()`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor preconditions = new UsesMethod(this.methodPattern);
        if (!this.methodPattern.contains(" *(")) {
            int indexSpace = this.methodPattern.indexOf(32);
            int indexBrace = this.methodPattern.indexOf(40, indexSpace);
            final String methodNameMatcher = this.methodPattern.substring(indexSpace, indexBrace);
            preconditions = Preconditions.and((TreeVisitor[])new TreeVisitor[]{preconditions, Preconditions.not(new DeclaresMethod("*..* " + methodNameMatcher + "(..)")), Preconditions.not((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

                @Override
                public J.Import visitImport(J.Import _import, ExecutionContext ctx) {
                    if (_import.isStatic() && _import.getQualid().getSimpleName().equals(methodNameMatcher.substring(1))) {
                        return (J.Import)SearchResult.found((Tree)_import);
                    }
                    return _import;
                }
            })});
        }
        return Preconditions.check(preconditions, (TreeVisitor)new UseStaticImportVisitor());
    }

    private static boolean methodNameConflicts(String methodName, Cursor cursor) {
        Cursor cdCursor = cursor.dropParentUntil(it -> it instanceof J.ClassDeclaration || it == "root");
        Object maybeCd = cdCursor.getValue();
        if (!(maybeCd instanceof J.ClassDeclaration)) {
            return false;
        }
        J.ClassDeclaration cd = (J.ClassDeclaration)maybeCd;
        JavaType.FullyQualified ct = cd.getType();
        if (ct == null) {
            return false;
        }
        if (UseStaticImport.methodNameConflicts(methodName, ct)) {
            return true;
        }
        return UseStaticImport.methodNameConflicts(methodName, cdCursor);
    }

    private static boolean methodNameConflicts(String methodName, @Nullable JavaType.FullyQualified ct) {
        if (ct == null) {
            return false;
        }
        for (JavaType.Method method : ct.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return true;
        }
        if (UseStaticImport.methodNameConflicts(methodName, ct.getSupertype())) {
            return true;
        }
        for (JavaType.FullyQualified intf : ct.getInterfaces()) {
            if (!UseStaticImport.methodNameConflicts(methodName, intf)) continue;
            return true;
        }
        return false;
    }

    @NonNull
    @Generated
    public String toString() {
        return "UseStaticImport(methodPattern=" + this.getMethodPattern() + ")";
    }

    @Generated
    public String getMethodPattern() {
        return this.methodPattern;
    }

    @Generated
    public UseStaticImport(String methodPattern) {
        this.methodPattern = methodPattern;
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UseStaticImport)) {
            return false;
        }
        UseStaticImport other = (UseStaticImport)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        return !(this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof UseStaticImport;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        return result;
    }

    private class UseStaticImportVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        final MethodMatcher methodMatcher;

        private UseStaticImportVisitor() {
            this.methodMatcher = new MethodMatcher(UseStaticImport.this.methodPattern);
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J m = super.visitMethodInvocation(method, ctx);
            if (this.methodMatcher.matches((MethodCall)m)) {
                if (((J.MethodInvocation)m).getTypeParameters() != null && !((J.MethodInvocation)m).getTypeParameters().isEmpty()) {
                    return m;
                }
                if (UseStaticImport.methodNameConflicts(((J.MethodInvocation)m).getSimpleName(), this.getCursor())) {
                    return m;
                }
                if (((J.MethodInvocation)m).getMethodType() != null) {
                    if (!((J.MethodInvocation)m).getMethodType().hasFlags(Flag.Static)) {
                        return m;
                    }
                    JavaType.FullyQualified receiverType = ((J.MethodInvocation)m).getMethodType().getDeclaringType();
                    this.maybeRemoveImport(receiverType);
                    this.maybeAddImport(receiverType.getFullyQualifiedName(), ((J.MethodInvocation)m).getSimpleName(), false);
                }
                if (((J.MethodInvocation)m).getSelect() != null) {
                    m = ((J.MethodInvocation)m).withSelect(null).withName(((J.MethodInvocation)m).getName().withPrefix(((J.MethodInvocation)m).getSelect().getPrefix()));
                }
            }
            return m;
        }

        @Override
        protected JavadocVisitor<ExecutionContext> getJavadocVisitor() {
            return new JavadocVisitor<ExecutionContext>((JavaVisitor)this){

                @Override
                public Javadoc visitReference(Javadoc.Reference reference, ExecutionContext ctx) {
                    return reference;
                }
            };
        }
    }
}

