/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.format.AutodetectGeneralFormatStyle;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.search.FindMethods;
import org.openrewrite.java.search.FindTypes;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Javadoc;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.kotlin.KotlinIsoVisitor;
import org.openrewrite.kotlin.style.ImportLayoutStyle;
import org.openrewrite.kotlin.style.IntelliJ;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.marker.Markers;
import org.openrewrite.style.GeneralFormatStyle;

public class AddImport<P>
extends KotlinIsoVisitor<P> {
    private static final Set<String> IMPLICITLY_IMPORTED_PACKAGES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("kotlin", "kotlin.annotation", "kotlin.collections", "kotlin.comparisons", "kotlin.io", "kotlin.ranges", "kotlin.sequences", "kotlin.text", "kotlin.math", "java.lang")));
    @Nullable
    private final String packageName;
    private final String typeName;
    private final String fullyQualifiedName;
    @Nullable
    private final String member;
    @Nullable
    private final String alias;
    private final boolean onlyIfReferenced;

    public AddImport(@Nullable String packageName, String typeName, @Nullable String member, @Nullable String alias, boolean onlyIfReferenced) {
        this.packageName = packageName == null || packageName.isEmpty() ? null : packageName;
        this.typeName = typeName.replace('.', '$');
        this.fullyQualifiedName = packageName == null ? typeName : packageName + "." + typeName;
        this.member = member;
        this.alias = alias;
        this.onlyIfReferenced = onlyIfReferenced;
    }

    @Nullable
    public J preVisit(J tree, P p) {
        this.stopAfterPreVisit();
        J j = tree;
        if (this.packageName != null && tree instanceof K.CompilationUnit) {
            K.CompilationUnit cu = (K.CompilationUnit)tree;
            if (JavaType.Primitive.fromKeyword((String)this.fullyQualifiedName) != null) {
                return cu;
            }
            if (this.alias == null && (IMPLICITLY_IMPORTED_PACKAGES.contains(this.packageName) && StringUtils.isBlank((String)this.member) || cu.getPackageDeclaration() != null && this.packageName.equals(cu.getPackageDeclaration().getExpression().printTrimmed(this.getCursor())))) {
                return cu;
            }
            if (this.onlyIfReferenced && !this.hasReference(cu)) {
                return cu;
            }
            if (cu.getImports().stream().anyMatch(i -> {
                String alias2;
                String ending = i.getQualid().getSimpleName();
                String alias1 = Optional.ofNullable(i.getAlias()).map(J.Identifier::getSimpleName).orElse("");
                String string = alias2 = this.alias != null ? this.alias : "";
                if (!alias1.equals(alias2)) {
                    return false;
                }
                if (this.member == null) {
                    return i.getPackageName().equals(this.packageName) && (ending.equals(this.typeName) || "*".equals(ending));
                }
                return i.getPackageName().equals(this.fullyQualifiedName) && (ending.equals(this.member) || "*".equals(ending));
            })) {
                return cu;
            }
            J.Import importToAdd = new J.Import(Tree.randomId(), Space.EMPTY, Markers.EMPTY, new JLeftPadded(Space.EMPTY, (Object)(this.member != null ? 1 : 0), Markers.EMPTY), (J.FieldAccess)TypeTree.build((String)(this.fullyQualifiedName + (this.member == null ? "" : "." + this.member)), (Character)Character.valueOf('`')).withPrefix(Space.SINGLE_SPACE), this.alias != null ? new JLeftPadded(Space.SINGLE_SPACE, (Object)new J.Identifier(Tree.randomId(), Space.SINGLE_SPACE, Markers.EMPTY, Collections.emptyList(), this.alias, null, null), Markers.EMPTY) : null);
            ArrayList<JRightPadded<J.Import>> imports = new ArrayList<JRightPadded<J.Import>>(cu.getPadding().getImports());
            if (imports.isEmpty() && !cu.getClasses().isEmpty() && cu.getPackageDeclaration() == null) {
                String whitespace = "";
                if (!cu.getAnnotations().isEmpty()) {
                    whitespace = "\n\n";
                }
                Space firstStatementPrefix = cu.getStatements().get(0).getPrefix();
                importToAdd = importToAdd.withPrefix(firstStatementPrefix.withComments(ListUtils.map((List)firstStatementPrefix.getComments(), comment -> comment instanceof Javadoc ? null : comment)).withWhitespace(whitespace));
                cu = cu.withStatements(ListUtils.mapFirst(cu.getStatements(), stmt -> (Statement)stmt.withComments(ListUtils.map((List)stmt.getComments(), comment -> comment instanceof Javadoc ? comment : null))));
            }
            ImportLayoutStyle layoutStyle = Optional.ofNullable((ImportLayoutStyle)cu.getStyle(ImportLayoutStyle.class)).orElse(IntelliJ.importLayout());
            List<JavaType.FullyQualified> classpath = cu.getMarkers().findFirst(JavaSourceSet.class).map(JavaSourceSet::getClasspath).orElse(Collections.emptyList());
            List<JRightPadded<J.Import>> newImports = layoutStyle.addImport(cu.getPadding().getImports(), importToAdd, cu.getPackageDeclaration(), classpath);
            GeneralFormatStyle generalFormatStyle = Optional.ofNullable((GeneralFormatStyle)cu.getStyle(GeneralFormatStyle.class)).orElse(AutodetectGeneralFormatStyle.autodetectGeneralFormatStyle((JavaSourceFile)cu));
            newImports = this.checkCRLF(newImports, generalFormatStyle);
            cu = cu.getPadding().withImports((List)newImports);
            if (((K.CompilationUnit)tree).getImports().isEmpty() || ((K.CompilationUnit)tree).getPackageDeclaration() == null) {
                cu = cu.withStatements(ListUtils.mapFirst(cu.getStatements(), stmt -> stmt.getPrefix().isEmpty() ? (Statement)stmt.withPrefix(stmt.getPrefix().withWhitespace(generalFormatStyle.isUseCRLFNewLines() ? "\r\n\r\n" : "\n\n")) : stmt));
            }
            j = cu;
        }
        return j;
    }

    private List<JRightPadded<J.Import>> checkCRLF(List<JRightPadded<J.Import>> newImports, GeneralFormatStyle generalFormatStyle) {
        if (generalFormatStyle.isUseCRLFNewLines()) {
            return ListUtils.map(newImports, rp -> rp.map(i -> i.withPrefix(i.getPrefix().withWhitespace(i.getPrefix().getWhitespace().replaceAll("(?<!\r)\n", "\r\n")))));
        }
        return newImports;
    }

    private boolean isTypeReference(NameTree t) {
        boolean isTypRef = true;
        if (t instanceof J.FieldAccess) {
            isTypRef = TypeUtils.isOfClassType((JavaType)((J.FieldAccess)t).getTarget().getType(), (String)this.fullyQualifiedName);
        }
        return isTypRef;
    }

    private boolean hasReference(JavaSourceFile compilationUnit) {
        if (this.member == null) {
            for (NameTree t : FindTypes.find((J)compilationUnit, (String)this.fullyQualifiedName)) {
                JavaType.ShallowClass classType = JavaType.ShallowClass.build((String)this.fullyQualifiedName);
                boolean foundReference = false;
                boolean usingAlias = false;
                if (t instanceof J.ParameterizedType) {
                    J.ParameterizedType pt = (J.ParameterizedType)t;
                    if (pt.getClazz() instanceof J.Identifier) {
                        String nameInSource = ((J.Identifier)pt.getClazz()).getSimpleName();
                        if (this.alias != null) {
                            if (nameInSource.equals(this.alias)) {
                                usingAlias = true;
                            }
                        } else if (nameInSource.equals(classType.getClassName())) {
                            foundReference = true;
                        }
                    }
                } else if (t instanceof J.Identifier) {
                    String nameInSource = ((J.Identifier)t).getSimpleName();
                    if (this.alias != null) {
                        if (nameInSource.equals(this.alias)) {
                            usingAlias = true;
                        }
                    } else if (nameInSource.equals(classType.getClassName())) {
                        foundReference = true;
                    }
                } else {
                    foundReference = true;
                }
                if (usingAlias) {
                    return true;
                }
                if (!foundReference || t instanceof J.FieldAccess && ((J.FieldAccess)t).isFullyQualifiedClassReference(this.fullyQualifiedName) || !this.isTypeReference(t)) continue;
                return true;
            }
            return false;
        }
        for (J invocation : FindMethods.find((J)compilationUnit, (String)(this.fullyQualifiedName + " *(..)"))) {
            J.MethodInvocation mi;
            if (!(invocation instanceof J.MethodInvocation) || (mi = (J.MethodInvocation)invocation).getSelect() != null || !"*".equals(this.member) && !mi.getName().getSimpleName().equals(this.member)) continue;
            return true;
        }
        AtomicReference<Boolean> hasStaticFieldAccess = new AtomicReference<Boolean>(false);
        new FindStaticFieldAccess().visit((Tree)compilationUnit, hasStaticFieldAccess);
        return hasStaticFieldAccess.get();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddImport)) {
            return false;
        }
        AddImport other = (AddImport)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.onlyIfReferenced != other.onlyIfReferenced) {
            return false;
        }
        String this$fullyQualifiedName = this.fullyQualifiedName;
        String other$fullyQualifiedName = other.fullyQualifiedName;
        if (this$fullyQualifiedName == null ? other$fullyQualifiedName != null : !this$fullyQualifiedName.equals(other$fullyQualifiedName)) {
            return false;
        }
        String this$member = this.member;
        String other$member = other.member;
        if (this$member == null ? other$member != null : !this$member.equals(other$member)) {
            return false;
        }
        String this$alias = this.alias;
        String other$alias = other.alias;
        return !(this$alias == null ? other$alias != null : !this$alias.equals(other$alias));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AddImport;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.onlyIfReferenced ? 79 : 97);
        String $fullyQualifiedName = this.fullyQualifiedName;
        result = result * 59 + ($fullyQualifiedName == null ? 43 : $fullyQualifiedName.hashCode());
        String $member = this.member;
        result = result * 59 + ($member == null ? 43 : $member.hashCode());
        String $alias = this.alias;
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        return result;
    }

    private class FindStaticFieldAccess
    extends JavaIsoVisitor<AtomicReference<Boolean>> {
        private FindStaticFieldAccess() {
        }

        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, AtomicReference<Boolean> found) {
            for (JavaType.Variable varType : cu.getTypesInUse().getVariables()) {
                if (!varType.getName().equals(AddImport.this.member) || !TypeUtils.isOfClassType((JavaType)varType.getType(), (String)AddImport.this.fullyQualifiedName)) continue;
                return super.visitCompilationUnit(cu, found);
            }
            return cu;
        }

        public J.Identifier visitIdentifier(J.Identifier identifier, AtomicReference<Boolean> found) {
            assert (this.getCursor().getParent() != null);
            if (identifier.getSimpleName().equals(AddImport.this.member) && TypeUtils.isOfClassType((JavaType)identifier.getType(), (String)AddImport.this.fullyQualifiedName) && !(this.getCursor().getParent().firstEnclosingOrThrow(J.class) instanceof J.FieldAccess)) {
                found.set(true);
            }
            return identifier;
        }
    }
}

