/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.kotlin.table.KotlinSourceFile;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.quark.Quark;
import org.openrewrite.text.PlainText;

public final class FindKotlinSources
extends Recipe {
    private final transient KotlinSourceFile kotlinSourceFile = new KotlinSourceFile(this);
    @Option(displayName="Find Kotlin compilation units", description="Limit the search results to Kotlin CompilationUnits.", required=false)
    @Nullable
    private final Boolean markCompilationUnits;

    public String getDisplayName() {
        return "Find Kotlin sources and collect data metrics";
    }

    public String getDescription() {
        return "Use data table to collect source files types and counts of files with extensions `.kt`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof SourceFile) {
                    if (Boolean.TRUE.equals(FindKotlinSources.this.markCompilationUnits) && !(tree instanceof K.CompilationUnit)) {
                        return tree;
                    }
                    SourceFile sourceFile = (SourceFile)tree;
                    if (sourceFile.getSourcePath().toString().endsWith(".kt")) {
                        KotlinSourceFile.SourceFileType sourceFileType = this.getSourceFileType(sourceFile);
                        FindKotlinSources.this.kotlinSourceFile.insertRow(ctx, new KotlinSourceFile.Row(sourceFile.getSourcePath().toString(), sourceFileType));
                        return SearchResult.found((Tree)sourceFile);
                    }
                }
                return tree;
            }

            @Nullable
            private KotlinSourceFile.SourceFileType getSourceFileType(SourceFile sourceFile) {
                KotlinSourceFile.SourceFileType sourceFileType = null;
                if (sourceFile instanceof K.CompilationUnit) {
                    sourceFileType = KotlinSourceFile.SourceFileType.Kotlin;
                } else if (sourceFile instanceof Quark) {
                    sourceFileType = KotlinSourceFile.SourceFileType.Quark;
                } else if (sourceFile instanceof PlainText) {
                    sourceFileType = KotlinSourceFile.SourceFileType.PlainText;
                }
                return sourceFileType;
            }
        };
    }

    @Generated
    public FindKotlinSources(Boolean markCompilationUnits) {
        this.markCompilationUnits = markCompilationUnits;
    }

    @Generated
    public KotlinSourceFile getKotlinSourceFile() {
        return this.kotlinSourceFile;
    }

    @Generated
    public Boolean getMarkCompilationUnits() {
        return this.markCompilationUnits;
    }

    @Generated
    public String toString() {
        return "FindKotlinSources(kotlinSourceFile=" + (Object)((Object)this.getKotlinSourceFile()) + ", markCompilationUnits=" + this.getMarkCompilationUnits() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindKotlinSources)) {
            return false;
        }
        FindKotlinSources other = (FindKotlinSources)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$markCompilationUnits = this.getMarkCompilationUnits();
        Boolean other$markCompilationUnits = other.getMarkCompilationUnits();
        return !(this$markCompilationUnits == null ? other$markCompilationUnits != null : !((Object)this$markCompilationUnits).equals(other$markCompilationUnits));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FindKotlinSources;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $markCompilationUnits = this.getMarkCompilationUnits();
        result = result * 59 + ($markCompilationUnits == null ? 43 : ((Object)$markCompilationUnits).hashCode());
        return result;
    }
}

