/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.format;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Javadoc;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.kotlin.KotlinIsoVisitor;
import org.openrewrite.kotlin.marker.OmitBraces;
import org.openrewrite.kotlin.marker.PrimaryConstructor;
import org.openrewrite.kotlin.marker.SingleExpressionBlock;
import org.openrewrite.kotlin.style.BlankLinesStyle;
import org.openrewrite.kotlin.tree.K;

public class BlankLinesVisitor<P>
extends KotlinIsoVisitor<P> {
    @Nullable
    private final Tree stopAfter;
    private final BlankLinesStyle style;
    private static final int keepMaximumBlankLines_BetweenHeaderAndPackage = 2;
    private static final int minimumBlankLines_BeforePackageStatement = 0;
    private static final int minimumBlankLines_AfterPackageStatement = 1;
    private static final int minimumBlankLines_BeforeImports = 1;
    private static final int minimumBlankLines_AfterImports = 1;
    private static final int minimumBlankLines_AroundClass = 1;
    private static final int minimumBlankLines_BeforeClassEnd = 0;
    private static final int minimumBlankLines_AfterAnonymousClassHeader = 0;
    private static final int minimumBlankLines_AroundFieldInInterface = 0;
    private static final int minimumBlankLines_AroundField = 0;
    private static final int minimumBlankLines_AroundMethodInInterface = 1;
    private static final int minimumBlankLines_AfterDeclarationWithBody = 1;
    private static final int minimumBlankLines_BeforeMethodBody = 0;
    private static final int minimumBlankLines_AroundInitializer = 1;

    public BlankLinesVisitor(BlankLinesStyle style) {
        this(style, null);
    }

    public BlankLinesVisitor(BlankLinesStyle style, @Nullable Tree stopAfter) {
        this.style = style;
        this.stopAfter = stopAfter;
    }

    public J visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (J)tree;
        }
        if (tree instanceof K.CompilationUnit) {
            K.CompilationUnit cu = (K.CompilationUnit)Objects.requireNonNull(tree);
            if (cu.getPackageDeclaration() != null) {
                J.Package pa = cu.getPackageDeclaration();
                if (!pa.getPrefix().getComments().isEmpty() || !cu.getAnnotations().isEmpty()) {
                    List updatedComments = ListUtils.mapLast((List)pa.getPrefix().getComments(), c -> {
                        String suffix = this.keepMaximumLines(c.getSuffix(), 2);
                        suffix = this.minimumLines(suffix, 0);
                        return c.withSuffix(suffix);
                    });
                    cu = cu.withPackageDeclaration(pa.withPrefix(pa.getPrefix().withComments(updatedComments)));
                } else {
                    cu = cu.withPackageDeclaration(pa.withPrefix(Space.EMPTY));
                }
            }
            cu = cu.getPackageDeclaration() == null ? (cu.getComments().isEmpty() ? cu.withPrefix(Space.EMPTY) : (K.CompilationUnit)cu.withComments(ListUtils.mapLast(cu.getComments(), c -> c.withSuffix(this.minimumLines(c.getSuffix(), 1))))) : cu.getPadding().withImports(ListUtils.mapFirst(cu.getPadding().getImports(), i -> this.minimumLines((J)i, 1)));
            return (J)super.visit((Tree)cu, p);
        }
        return (J)super.visit(tree, p);
    }

    @Override
    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, P p) {
        J.ClassDeclaration j = super.visitClassDeclaration(classDecl, p);
        List statements = j.getBody().getPadding().getStatements();
        J.ClassDeclaration.Kind.Type classKind = j.getKind();
        j = j.withBody(j.getBody().getPadding().withStatements(ListUtils.map((List)statements, (i, s) -> {
            if (i == 0) {
                if (classKind != J.ClassDeclaration.Kind.Type.Enum) {
                    s = this.minimumLines((J)s, (int)this.style.getMinimum().getAfterClassHeader());
                }
            } else if (((JRightPadded)statements.get(i - 1)).getElement() instanceof J.Block) {
                s = this.minimumLines((J)s, 1);
            } else if (s.getElement() instanceof J.ClassDeclaration || s.getElement() instanceof K.ClassDeclaration) {
                s = this.minimumLines((J)s, 1);
            }
            return s;
        })));
        j = j.withBody(j.getBody().withEnd(this.minimumLines(j.getBody().getEnd(), 0)));
        K.CompilationUnit cu = (K.CompilationUnit)this.getCursor().firstEnclosingOrThrow(K.CompilationUnit.class);
        boolean hasImports = !cu.getImports().isEmpty();
        boolean firstStatement = j.equals((Object)cu.getStatements().get(0));
        HashSet<Statement> topLevelStatements = new HashSet<Statement>(cu.getStatements());
        J.ClassDeclaration classDeclaration = firstStatement ? (hasImports ? this.minimumLines(j, 1) : j) : (j = topLevelStatements.contains(j) ? this.minimumLines(j, 1) : j);
        J.ClassDeclaration classDeclaration2 = firstStatement ? (hasImports ? this.keepMaximumLines(j, Math.max(this.style.getKeepMaximum().getInDeclarations(), 1)) : j) : (j = topLevelStatements.contains(j) ? this.keepMaximumLines(j, (int)this.style.getKeepMaximum().getInDeclarations()) : j);
        if (!hasImports && firstStatement) {
            if (cu.getPackageDeclaration() == null) {
                if (!j.getPrefix().getWhitespace().isEmpty()) {
                    j = j.withPrefix(j.getPrefix().withWhitespace(""));
                }
            } else {
                j = this.minimumLines(j, 1);
            }
        }
        return j;
    }

    @Override
    public J.EnumValue visitEnumValue(J.EnumValue _enum, P p) {
        J.EnumValue e = super.visitEnumValue(_enum, p);
        return this.keepMaximumLines(e, (int)this.style.getKeepMaximum().getInDeclarations());
    }

    @Override
    public J.Import visitImport(J.Import import_, P p) {
        JavaSourceFile cu;
        J.Import i = super.visitImport(import_, p);
        if (i.equals((cu = (JavaSourceFile)this.getCursor().firstEnclosingOrThrow(JavaSourceFile.class)).getImports().get(0)) && cu.getPackageDeclaration() == null && cu.getPrefix().equals((Object)Space.EMPTY)) {
            i = i.withPrefix(i.getPrefix().withWhitespace(""));
        }
        return i;
    }

    @Override
    public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, P p) {
        J.MethodDeclaration j = super.visitMethodDeclaration(method, p);
        if (j.getBody() != null) {
            if (j.getBody().getStatements().isEmpty()) {
                Space end = this.minimumLines(j.getBody().getEnd(), 0);
                if (end.getIndent().isEmpty()) {
                    // empty if block
                }
                j = j.withBody(j.getBody().withEnd(end));
            } else {
                j = j.withBody(j.getBody().withStatements(ListUtils.mapFirst((List)j.getBody().getStatements(), s -> this.minimumLines(s, 0))));
            }
        }
        return j;
    }

    @Override
    public J.NewClass visitNewClass(J.NewClass newClass, P p) {
        J.NewClass j = super.visitNewClass(newClass, p);
        if (j.getBody() != null) {
            j = j.withBody(j.getBody().withStatements(ListUtils.mapFirst((List)j.getBody().getStatements(), s -> this.minimumLines(s, 0))));
        }
        return j;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Statement visitStatement(Statement statement, P p) {
        Statement j = super.visitStatement(statement, p);
        Iterator cursorPath = this.getCursor().getParentOrThrow().getPath(J.class::isInstance);
        Object parentTree = cursorPath.next();
        if (cursorPath.hasNext()) {
            Object grandparentTree = cursorPath.next();
            if (!(grandparentTree instanceof J.ClassDeclaration)) return this.keepMaximumLines(j, (int)this.style.getKeepMaximum().getInCode());
            if (!(parentTree instanceof J.Block)) return this.keepMaximumLines(j, (int)this.style.getKeepMaximum().getInCode());
            J.Block block = (J.Block)parentTree;
            J.ClassDeclaration classDecl = (J.ClassDeclaration)grandparentTree;
            int declMax = this.style.getKeepMaximum().getInDeclarations();
            if (block.getStatements().isEmpty()) return this.keepMaximumLines(j, declMax);
            if (((Statement)block.getStatements().iterator().next()).isScope((Tree)j)) return this.keepMaximumLines(j, declMax);
            if (j instanceof J.VariableDeclarations) {
                if (classDecl.getKind() == J.ClassDeclaration.Kind.Type.Interface) {
                    declMax = Math.max(declMax, 0);
                    j = this.minimumLines(j, 0);
                    return this.keepMaximumLines(j, declMax);
                } else {
                    declMax = Math.max(declMax, 0);
                    j = this.minimumLines(j, 0);
                }
                return this.keepMaximumLines(j, declMax);
            } else if (j instanceof J.MethodDeclaration || j instanceof K.MethodDeclaration) {
                if (classDecl.getKind() != J.ClassDeclaration.Kind.Type.Interface) return this.keepMaximumLines(j, declMax);
                declMax = Math.max(declMax, 1);
                j = this.minimumLines(j, 1);
                return this.keepMaximumLines(j, declMax);
            } else if (j instanceof J.Block) {
                declMax = Math.max(declMax, 1);
                j = this.minimumLines(j, 1);
                return this.keepMaximumLines(j, declMax);
            } else {
                if (!(j instanceof J.ClassDeclaration)) {
                    if (!(j instanceof K.ClassDeclaration)) return this.keepMaximumLines(j, declMax);
                }
                declMax = Math.max(declMax, 1);
                j = this.minimumLines(j, 1);
            }
            return this.keepMaximumLines(j, declMax);
        }
        if (!(parentTree instanceof K.CompilationUnit)) return j;
        K.CompilationUnit cu = (K.CompilationUnit)parentTree;
        int declMax = this.style.getKeepMaximum().getInDeclarations();
        if (cu.getStatements().isEmpty()) return this.keepMaximumLines(j, declMax);
        if (cu.getStatements().iterator().next().isScope((Tree)j)) return this.keepMaximumLines(j, declMax);
        if (j instanceof J.VariableDeclarations) {
            declMax = Math.max(declMax, 0);
            j = this.minimumLines(j, 0);
            return this.keepMaximumLines(j, declMax);
        } else if (j instanceof J.MethodDeclaration || j instanceof K.MethodDeclaration) {
            declMax = Math.max(declMax, 1);
            j = this.minimumLines(j, 1);
            return this.keepMaximumLines(j, declMax);
        } else if (j instanceof J.Block) {
            declMax = Math.max(declMax, 1);
            j = this.minimumLines(j, 1);
            return this.keepMaximumLines(j, declMax);
        } else {
            if (!(j instanceof J.ClassDeclaration)) {
                if (!(j instanceof K.ClassDeclaration)) return this.keepMaximumLines(j, declMax);
            }
            declMax = Math.max(declMax, 1);
            j = this.minimumLines(j, 1);
        }
        return this.keepMaximumLines(j, declMax);
    }

    @Override
    public J.Block visitBlock(J.Block block, P p) {
        J.Block b = super.visitBlock(block, p);
        b = b.withEnd(this.keepMaximumLines(b.getEnd(), (int)this.style.getKeepMaximum().getBeforeEndOfBlock()));
        J parent2 = (J)this.getCursor().getParentTreeCursor().getValue();
        AtomicBoolean previousWithBody = new AtomicBoolean();
        List blockStatements = b.getPadding().getStatements();
        blockStatements = ListUtils.map((List)blockStatements, (index, padded) -> {
            J.VariableDeclarations v;
            Statement statement = (Statement)padded.getElement();
            if (statement instanceof J.MethodDeclaration || statement instanceof K.MethodDeclaration) {
                J.MethodDeclaration m;
                J.MethodDeclaration methodDeclaration = m = statement instanceof J.MethodDeclaration ? (J.MethodDeclaration)statement : ((K.MethodDeclaration)statement).getMethodDeclaration();
                if (previousWithBody.get()) {
                    m = this.minimumLines(m, 1);
                }
                if (m.getBody() != null && !m.getBody().getMarkers().findFirst(SingleExpressionBlock.class).isPresent()) {
                    previousWithBody.set(true);
                } else {
                    previousWithBody.set(false);
                }
                if (!m.getPrefix().getComments().isEmpty()) {
                    m = this.minimumLines(m, (int)this.style.getMinimum().getBeforeDeclarationWithCommentOrAnnotation());
                }
                if (!m.getLeadingAnnotations().isEmpty() && !m.getMarkers().findFirst(PrimaryConstructor.class).isPresent()) {
                    m = this.minimumLines(m, (int)this.style.getMinimum().getBeforeDeclarationWithCommentOrAnnotation());
                }
                statement = statement instanceof J.MethodDeclaration ? m : ((K.MethodDeclaration)statement).withMethodDeclaration(m);
            } else if (statement instanceof J.VariableDeclarations && !(v = (J.VariableDeclarations)statement).getLeadingAnnotations().isEmpty() && (parent2 instanceof J.ClassDeclaration || parent2 instanceof J.NewClass && index > 0)) {
                statement = (Statement)this.minimumLines(v, (int)this.style.getMinimum().getBeforeDeclarationWithCommentOrAnnotation());
            }
            return padded.withElement((Object)statement);
        });
        b = b.getPadding().withStatements(blockStatements);
        return b;
    }

    @Override
    public K.When visitWhen(K.When when, P p) {
        J kwhen = super.visitWhen(when, (Object)p);
        J.Block branches = kwhen.getBranches();
        List statements = ListUtils.map((List)branches.getStatements(), (index, s) -> {
            if (index == 0) {
                return s;
            }
            if (s instanceof K.WhenBranch && branches.getStatements().get(index - 1) instanceof K.WhenBranch) {
                boolean isPreviousWhenBranchWithBlock;
                K.WhenBranch branch = (K.WhenBranch)s;
                K.WhenBranch previousBranch = (K.WhenBranch)branches.getStatements().get(index - 1);
                boolean bl = isPreviousWhenBranchWithBlock = previousBranch.getBody() instanceof J.Block && !previousBranch.getBody().getMarkers().findFirst(OmitBraces.class).isPresent();
                if (!isPreviousWhenBranchWithBlock) {
                    return s;
                }
                return this.minimumLines(branch, (int)this.style.getMinimum().getAroundWhenBranchWithBraces());
            }
            return s;
        });
        return kwhen.withBranches(branches.withStatements(statements));
    }

    private <J2 extends J> J2 keepMaximumLines(J2 tree, int max) {
        return (J2)tree.withPrefix(this.keepMaximumLines(tree.getPrefix(), max));
    }

    private Space keepMaximumLines(Space prefix, int max) {
        return prefix.withWhitespace(this.keepMaximumLines(prefix.getWhitespace(), max));
    }

    private String keepMaximumLines(String whitespace, int max) {
        long blankLines = BlankLinesVisitor.getNewLineCount(whitespace) - 1;
        if (blankLines > (long)max) {
            int startWhitespaceAtIndex = 0;
            int i = 0;
            while ((long)i < blankLines - (long)max + 1L) {
                startWhitespaceAtIndex = whitespace.indexOf(10, startWhitespaceAtIndex);
                ++i;
                ++startWhitespaceAtIndex;
            }
            return whitespace.substring(--startWhitespaceAtIndex);
        }
        return whitespace;
    }

    private <J2 extends J> JRightPadded<J2> minimumLines(JRightPadded<J2> tree, int min) {
        return tree.withElement((Object)this.minimumLines((J)tree.getElement(), min));
    }

    private <J2 extends J> J2 minimumLines(J2 tree, int min) {
        return (J2)tree.withPrefix(this.minimumLines(tree.getPrefix(), min));
    }

    private Space minimumLines(Space prefix, int min) {
        if (min == 0) {
            return prefix;
        }
        if (prefix.getComments().isEmpty() || prefix.getWhitespace().contains("\n") || prefix.getComments().get(0) instanceof Javadoc || ((Comment)prefix.getComments().get(0)).isMultiline() && ((Comment)prefix.getComments().get(0)).printComment(this.getCursor()).contains("\n")) {
            return prefix.withWhitespace(this.minimumLines(prefix.getWhitespace(), min));
        }
        return prefix.withComments(ListUtils.map((List)prefix.getComments(), (i, c) -> i == 0 ? c.withSuffix(this.minimumLines(c.getSuffix(), min)) : c));
    }

    private String minimumLines(String whitespace, int min) {
        if (min == 0) {
            return whitespace;
        }
        String minWhitespace = whitespace;
        for (int i = 0; i < min - BlankLinesVisitor.getNewLineCount(whitespace) + 1; ++i) {
            minWhitespace = "\n" + minWhitespace;
        }
        return minWhitespace;
    }

    private static int getNewLineCount(String whitespace) {
        int newLineCount = 0;
        for (char c : whitespace.toCharArray()) {
            if (c != '\n') continue;
            ++newLineCount;
        }
        return newLineCount;
    }

    @Nullable
    public J postVisit(J tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(JavaSourceFile.class, "stop", (Object)true);
        }
        return (J)super.postVisit((Tree)tree, p);
    }
}

