/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Comparator;
import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.MavenTagInsertionComparator;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.TagNameComparator;
import org.openrewrite.xml.tree.Xml;

public final class ChangePropertyValue
extends Recipe {
    @Option(displayName="Key", description="The name of the property key whose value is to be changed.", example="junit.version")
    private final String key;
    @Option(displayName="Value", description="Value to apply to the matching property.", example="4.13")
    private final String newValue;
    @Option(displayName="Add If Missing", description="Add the property if it is missing from the pom file.", required=false, example="false")
    @Nullable
    private final Boolean addIfMissing;

    public String getDisplayName() {
        return "Change Maven project property value";
    }

    public String getDescription() {
        return "Changes the specified Maven project property value leaving the key intact.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){
            final String propertyName;
            {
                this.propertyName = ChangePropertyValue.this.key.replace("${", "").replace("}", "");
            }

            @Override
            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                Xml.Document d = super.visitDocument(document, ctx);
                if (Boolean.TRUE.equals(ChangePropertyValue.this.addIfMissing)) {
                    Xml.Tag root = d.getRoot();
                    Optional properties = root.getChild("properties");
                    if (!properties.isPresent()) {
                        Xml.Tag propertiesTag = Xml.Tag.build((String)("<properties>\n<" + this.propertyName + ">" + ChangePropertyValue.this.newValue + "</" + this.propertyName + ">\n</properties>"));
                        d = (Xml.Document)new AddToTagVisitor(root, propertiesTag, (Comparator)new MavenTagInsertionComparator(root.getChildren())).visitNonNull((Tree)d, (Object)ctx);
                    } else if (!((Xml.Tag)properties.get()).getChildValue(this.propertyName).isPresent()) {
                        Xml.Tag propertyTag = Xml.Tag.build((String)("<" + this.propertyName + ">" + ChangePropertyValue.this.newValue + "</" + this.propertyName + ">"));
                        d = (Xml.Document)new AddToTagVisitor((Xml.Tag)properties.get(), propertyTag, (Comparator)new TagNameComparator()).visitNonNull((Tree)d, (Object)ctx);
                    }
                }
                return d;
            }

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                if (this.isPropertyTag() && this.propertyName.equals(tag.getName()) && !ChangePropertyValue.this.newValue.equals(tag.getValue().orElse(null))) {
                    this.doAfterVisit((TreeVisitor)new ChangeTagValueVisitor(tag, ChangePropertyValue.this.newValue));
                }
                return super.visitTag(tag, ctx);
            }
        };
    }

    public ChangePropertyValue(String key, String newValue, @Nullable Boolean addIfMissing) {
        this.key = key;
        this.newValue = newValue;
        this.addIfMissing = addIfMissing;
    }

    public String getKey() {
        return this.key;
    }

    public String getNewValue() {
        return this.newValue;
    }

    @Nullable
    public Boolean getAddIfMissing() {
        return this.addIfMissing;
    }

    @NonNull
    public String toString() {
        return "ChangePropertyValue(key=" + this.getKey() + ", newValue=" + this.getNewValue() + ", addIfMissing=" + this.getAddIfMissing() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangePropertyValue)) {
            return false;
        }
        ChangePropertyValue other = (ChangePropertyValue)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$addIfMissing = this.getAddIfMissing();
        Boolean other$addIfMissing = other.getAddIfMissing();
        if (this$addIfMissing == null ? other$addIfMissing != null : !((Object)this$addIfMissing).equals(other$addIfMissing)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$newValue = this.getNewValue();
        String other$newValue = other.getNewValue();
        return !(this$newValue == null ? other$newValue != null : !this$newValue.equals(other$newValue));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangePropertyValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $addIfMissing = this.getAddIfMissing();
        result = result * 59 + ($addIfMissing == null ? 43 : ((Object)$addIfMissing).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $newValue = this.getNewValue();
        result = result * 59 + ($newValue == null ? 43 : $newValue.hashCode());
        return result;
    }
}

