/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.cleanup;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.xml.RemoveContentVisitor;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public class DependencyManagementDependencyRequiresVersion
extends Recipe {
    public String getDisplayName() {
        return "Dependency management dependencies should have a version";
    }

    public String getDescription() {
        return "If they don't have a version, they can't possibly affect dependency resolution anywhere, and can be safely removed.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                if (this.isManagedDependencyTag() && tag.getChildValue("version").orElse(null) == null) {
                    this.doAfterVisit((TreeVisitor)new RemoveContentVisitor((Content)tag, true));
                }
                return super.visitTag(tag, ctx);
            }
        };
    }
}

