/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.PathUtils;
import org.openrewrite.Preconditions;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.text.PlainText;
import org.openrewrite.text.PlainTextVisitor;

public final class AddRuntimeConfig
extends ScanningRecipe<Accumulator> {
    static final String POM_FILENAME = "pom.xml";
    static final String MVN_CONFIG_DIR = ".mvn";
    static final String MAVEN_CONFIG_FILENAME = "maven.config";
    static final String MAVEN_CONFIG_PATH = ".mvn/maven.config";
    static final String JVM_CONFIG_FILENAME = "jvm.config";
    static final String JVM_CONFIG_PATH = ".mvn/jvm.config";
    @Option(displayName="Config file", description="The file name for setting the runtime configuration.", valid={"maven.config", "jvm.config"}, example="maven.config")
    private final String relativeConfigFileName;
    @Option(displayName="Runtime flag", description="The runtime flag name to be set.", example="-T")
    private final String flag;
    @Option(displayName="Runtime flag argument", description="The argument to set for the runtime flag. Some flags do not need to provide a value.", required=false, example="3")
    @Nullable
    private final String argument;
    @Option(displayName="Separator between runtime flag and argument", description="The separator to use if flag and argument have been provided.", valid={"", " ", "="}, example="=")
    private final Separator separator;

    public String getDisplayName() {
        return "Add a configuration option for the Maven runtime";
    }

    public String getDescription() {
        return "Add a new configuration option for the Maven runtime if not already present.";
    }

    public Accumulator getInitialValue(ExecutionContext ctx) {
        String targetRepresentation = this.argument == null ? this.flag : this.flag + this.separator.getNotation() + this.argument;
        return new Accumulator(targetRepresentation);
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public Tree preVisit(Tree tree, ExecutionContext ctx) {
                this.stopAfterPreVisit();
                if (tree instanceof SourceFile) {
                    Path sourcePath = ((SourceFile)tree).getSourcePath();
                    switch (PathUtils.separatorsToUnix((String)sourcePath.toString())) {
                        case "pom.xml": {
                            acc.setMavenProject(true);
                            break;
                        }
                        case ".mvn/maven.config": 
                        case ".mvn/jvm.config": {
                            acc.setMatchingRuntimeConfigFile(sourcePath);
                            break;
                        }
                    }
                }
                return tree;
            }
        };
    }

    public Collection<? extends SourceFile> generate(Accumulator acc, ExecutionContext ctx) {
        if (acc.isMavenProject() && acc.getMatchingRuntimeConfigFile() == null) {
            return Collections.singletonList(PlainText.builder().text(acc.getTargetRepresentation()).sourcePath(Paths.get(MVN_CONFIG_DIR, this.relativeConfigFileName)).build());
        }
        return Collections.emptyList();
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Accumulator acc) {
        return Preconditions.check((acc.isMavenProject() && acc.getMatchingRuntimeConfigFile() != null ? 1 : 0) != 0, (TreeVisitor)new PlainTextVisitor<ExecutionContext>(){

            public PlainText visitText(PlainText plainText, ExecutionContext ctx) {
                if (plainText.getSourcePath().equals(acc.getMatchingRuntimeConfigFile())) {
                    return this.addOrReplaceConfig(plainText, acc);
                }
                return plainText;
            }

            private PlainText addOrReplaceConfig(PlainText plainText, Accumulator acc2) {
                String existingContent = plainText.getText();
                Matcher matcher = Pattern.compile(Pattern.quote(AddRuntimeConfig.this.flag) + "[=\\s]?[a-zA-Z0-9]*").matcher(existingContent);
                if (matcher.find()) {
                    return plainText.withText(matcher.replaceAll(acc2.getTargetRepresentation()));
                }
                String newText = StringUtils.isBlank((String)existingContent) ? existingContent : existingContent + this.determineConfigSeparator(plainText);
                return plainText.withText(newText + acc2.getTargetRepresentation());
            }

            private String determineConfigSeparator(PlainText plainText) {
                if (Paths.get(AddRuntimeConfig.JVM_CONFIG_PATH, new String[0]).equals(plainText.getSourcePath())) {
                    return " ";
                }
                return plainText.getText().contains("\r\n") ? "\r\n" : "\n";
            }
        });
    }

    @Generated
    public AddRuntimeConfig(String relativeConfigFileName, String flag, @Nullable String argument, Separator separator) {
        this.relativeConfigFileName = relativeConfigFileName;
        this.flag = flag;
        this.argument = argument;
        this.separator = separator;
    }

    @Generated
    public String getRelativeConfigFileName() {
        return this.relativeConfigFileName;
    }

    @Generated
    public String getFlag() {
        return this.flag;
    }

    @Nullable
    @Generated
    public String getArgument() {
        return this.argument;
    }

    @Generated
    public Separator getSeparator() {
        return this.separator;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddRuntimeConfig(relativeConfigFileName=" + this.getRelativeConfigFileName() + ", flag=" + this.getFlag() + ", argument=" + this.getArgument() + ", separator=" + (Object)((Object)this.getSeparator()) + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddRuntimeConfig)) {
            return false;
        }
        AddRuntimeConfig other = (AddRuntimeConfig)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$relativeConfigFileName = this.getRelativeConfigFileName();
        String other$relativeConfigFileName = other.getRelativeConfigFileName();
        if (this$relativeConfigFileName == null ? other$relativeConfigFileName != null : !this$relativeConfigFileName.equals(other$relativeConfigFileName)) {
            return false;
        }
        String this$flag = this.getFlag();
        String other$flag = other.getFlag();
        if (this$flag == null ? other$flag != null : !this$flag.equals(other$flag)) {
            return false;
        }
        String this$argument = this.getArgument();
        String other$argument = other.getArgument();
        if (this$argument == null ? other$argument != null : !this$argument.equals(other$argument)) {
            return false;
        }
        Separator this$separator = this.getSeparator();
        Separator other$separator = other.getSeparator();
        return !(this$separator == null ? other$separator != null : !((Object)((Object)this$separator)).equals((Object)other$separator));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddRuntimeConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $relativeConfigFileName = this.getRelativeConfigFileName();
        result = result * 59 + ($relativeConfigFileName == null ? 43 : $relativeConfigFileName.hashCode());
        String $flag = this.getFlag();
        result = result * 59 + ($flag == null ? 43 : $flag.hashCode());
        String $argument = this.getArgument();
        result = result * 59 + ($argument == null ? 43 : $argument.hashCode());
        Separator $separator = this.getSeparator();
        result = result * 59 + ($separator == null ? 43 : ((Object)((Object)$separator)).hashCode());
        return result;
    }

    public static enum Separator {
        NONE(""),
        SPACE(" "),
        EQUALS("=");

        private final String notation;

        private Separator(String notation) {
            this.notation = notation;
        }

        @Generated
        public String getNotation() {
            return this.notation;
        }
    }

    public static class Accumulator {
        final String targetRepresentation;
        boolean mavenProject;
        Path matchingRuntimeConfigFile;

        @Generated
        public String getTargetRepresentation() {
            return this.targetRepresentation;
        }

        @Generated
        public boolean isMavenProject() {
            return this.mavenProject;
        }

        @Generated
        public Path getMatchingRuntimeConfigFile() {
            return this.matchingRuntimeConfigFile;
        }

        @Generated
        public void setMavenProject(boolean mavenProject) {
            this.mavenProject = mavenProject;
        }

        @Generated
        public void setMatchingRuntimeConfigFile(Path matchingRuntimeConfigFile) {
            this.matchingRuntimeConfigFile = matchingRuntimeConfigFile;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Accumulator)) {
                return false;
            }
            Accumulator other = (Accumulator)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isMavenProject() != other.isMavenProject()) {
                return false;
            }
            String this$targetRepresentation = this.getTargetRepresentation();
            String other$targetRepresentation = other.getTargetRepresentation();
            if (this$targetRepresentation == null ? other$targetRepresentation != null : !this$targetRepresentation.equals(other$targetRepresentation)) {
                return false;
            }
            Path this$matchingRuntimeConfigFile = this.getMatchingRuntimeConfigFile();
            Path other$matchingRuntimeConfigFile = other.getMatchingRuntimeConfigFile();
            return !(this$matchingRuntimeConfigFile == null ? other$matchingRuntimeConfigFile != null : !((Object)this$matchingRuntimeConfigFile).equals(other$matchingRuntimeConfigFile));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Accumulator;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isMavenProject() ? 79 : 97);
            String $targetRepresentation = this.getTargetRepresentation();
            result = result * 59 + ($targetRepresentation == null ? 43 : $targetRepresentation.hashCode());
            Path $matchingRuntimeConfigFile = this.getMatchingRuntimeConfigFile();
            result = result * 59 + ($matchingRuntimeConfigFile == null ? 43 : ((Object)$matchingRuntimeConfigFile).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "AddRuntimeConfig.Accumulator(targetRepresentation=" + this.getTargetRepresentation() + ", mavenProject=" + this.isMavenProject() + ", matchingRuntimeConfigFile=" + this.getMatchingRuntimeConfigFile() + ")";
        }

        @Generated
        public Accumulator(String targetRepresentation) {
            this.targetRepresentation = targetRepresentation;
        }
    }
}

