/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Comparator;
import java.util.Optional;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.MavenTagInsertionComparator;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.TagNameComparator;
import org.openrewrite.xml.tree.Xml;

public final class AddPropertyVisitor
extends MavenIsoVisitor<ExecutionContext> {
    private final String key;
    private final String value;
    @Nullable
    private final Boolean preserveExistingValue;

    @Override
    public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
        Xml.Document d = super.visitDocument(document, ctx);
        Xml.Tag root = d.getRoot();
        Optional properties = root.getChild("properties");
        if (!properties.isPresent()) {
            Xml.Tag propertiesTag = Xml.Tag.build((String)("<properties>\n<" + this.key + ">" + this.value + "</" + this.key + ">\n</properties>"));
            d = (Xml.Document)new AddToTagVisitor(root, propertiesTag, (Comparator)new MavenTagInsertionComparator(root.getChildren())).visitNonNull((Tree)d, (Object)ctx);
        } else if (!((Xml.Tag)properties.get()).getChildValue(this.key).isPresent()) {
            Xml.Tag propertyTag = Xml.Tag.build((String)("<" + this.key + ">" + this.value + "</" + this.key + ">"));
            d = (Xml.Document)new AddToTagVisitor((Xml.Tag)properties.get(), propertyTag, (Comparator)new TagNameComparator()).visitNonNull((Tree)d, (Object)ctx);
        }
        if (d != document) {
            this.maybeUpdateModel();
        }
        return d;
    }

    @Override
    public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
        if (!Boolean.TRUE.equals(this.preserveExistingValue) && this.isPropertyTag() && this.key.equals(tag.getName()) && !this.value.equals(tag.getValue().orElse(null))) {
            this.doAfterVisit((TreeVisitor)new ChangeTagValueVisitor(tag, this.value));
        }
        return super.visitTag(tag, ctx);
    }

    @Generated
    public AddPropertyVisitor(String key, String value, @Nullable Boolean preserveExistingValue) {
        this.key = key;
        this.value = value;
        this.preserveExistingValue = preserveExistingValue;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Nullable
    @Generated
    public Boolean getPreserveExistingValue() {
        return this.preserveExistingValue;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddPropertyVisitor(key=" + this.getKey() + ", value=" + this.getValue() + ", preserveExistingValue=" + this.getPreserveExistingValue() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddPropertyVisitor)) {
            return false;
        }
        AddPropertyVisitor other = (AddPropertyVisitor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$preserveExistingValue = this.getPreserveExistingValue();
        Boolean other$preserveExistingValue = other.getPreserveExistingValue();
        if (this$preserveExistingValue == null ? other$preserveExistingValue != null : !((Object)this$preserveExistingValue).equals(other$preserveExistingValue)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddPropertyVisitor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $preserveExistingValue = this.getPreserveExistingValue();
        result = result * 59 + ($preserveExistingValue == null ? 43 : ((Object)$preserveExistingValue).hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

