/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.DelegatingExecutionContext;
import org.openrewrite.ExecutionContext;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenSettings;
import org.openrewrite.maven.cache.InMemoryMavenPomCache;
import org.openrewrite.maven.cache.MavenPomCache;
import org.openrewrite.maven.internal.MavenParsingException;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.MavenRepositoryCredentials;
import org.openrewrite.maven.tree.MavenRepositoryMirror;
import org.openrewrite.maven.tree.ResolutionEventListener;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;

public class MavenExecutionContextView
extends DelegatingExecutionContext {
    private static final MavenPomCache DEFAULT_POM_CACHE = new InMemoryMavenPomCache();
    private static final String MAVEN_SETTINGS = "org.openrewrite.maven.settings";
    private static final String MAVEN_ACTIVE_PROFILES = "org.openrewrite.maven.activeProfiles";
    private static final String MAVEN_MIRRORS = "org.openrewrite.maven.mirrors";
    private static final String MAVEN_CREDENTIALS = "org.openrewrite.maven.auth";
    private static final String MAVEN_LOCAL_REPOSITORY = "org.openrewrite.maven.localRepo";
    private static final String MAVEN_ADD_LOCAL_REPOSITORY = "org.openrewrite.maven.useLocalRepo";
    private static final String MAVEN_ADD_CENTRAL_REPOSITORY = "org.openrewrite.maven.useCentralRepo";
    private static final String MAVEN_REPOSITORIES = "org.openrewrite.maven.repos";
    private static final String MAVEN_PINNED_SNAPSHOT_VERSIONS = "org.openrewrite.maven.pinnedSnapshotVersions";
    private static final String MAVEN_POM_CACHE = "org.openrewrite.maven.pomCache";
    private static final String MAVEN_RESOLUTION_LISTENER = "org.openrewrite.maven.resolutionListener";
    private static final String MAVEN_RESOLUTION_TIME = "org.openrewrite.maven.resolutionTime";

    public MavenExecutionContextView(ExecutionContext delegate) {
        super(delegate);
    }

    public static MavenExecutionContextView view(ExecutionContext ctx) {
        if (ctx instanceof MavenExecutionContextView) {
            return (MavenExecutionContextView)ctx;
        }
        return new MavenExecutionContextView(ctx);
    }

    public MavenExecutionContextView recordResolutionTime(Duration time) {
        this.computeMessage(MAVEN_RESOLUTION_TIME, time.toMillis(), () -> 0L, Long::sum);
        return this;
    }

    public Duration getResolutionTime() {
        return Duration.ofMillis((Long)this.getMessage(MAVEN_RESOLUTION_TIME, 0L));
    }

    public MavenExecutionContextView setResolutionListener(ResolutionEventListener listener) {
        this.putMessage(MAVEN_RESOLUTION_LISTENER, listener);
        return this;
    }

    public ResolutionEventListener getResolutionListener() {
        return (ResolutionEventListener)this.getMessage(MAVEN_RESOLUTION_LISTENER, ResolutionEventListener.NOOP);
    }

    public MavenExecutionContextView setMirrors(@Nullable Collection<MavenRepositoryMirror> mirrors) {
        this.putMessage(MAVEN_MIRRORS, mirrors);
        return this;
    }

    public Collection<MavenRepositoryMirror> getMirrors() {
        return (Collection)this.getMessage(MAVEN_MIRRORS, Collections.emptyList());
    }

    public Collection<MavenRepositoryMirror> getMirrors(@Nullable MavenSettings mavenSettings) {
        if (mavenSettings != null && !mavenSettings.equals(this.getSettings())) {
            return MavenExecutionContextView.mapMirrors(mavenSettings);
        }
        return this.getMirrors();
    }

    public MavenExecutionContextView setCredentials(Collection<MavenRepositoryCredentials> credentials) {
        this.putMessage(MAVEN_CREDENTIALS, credentials);
        return this;
    }

    public Collection<MavenRepositoryCredentials> getCredentials() {
        return (Collection)this.getMessage(MAVEN_CREDENTIALS, Collections.emptyList());
    }

    public Collection<MavenRepositoryCredentials> getCredentials(@Nullable MavenSettings mavenSettings) {
        ArrayList<MavenRepositoryCredentials> credentials = new ArrayList<MavenRepositoryCredentials>();
        if (mavenSettings != null) {
            credentials.addAll(MavenExecutionContextView.mapCredentials(mavenSettings));
        }
        credentials.addAll((Collection)this.getMessage(MAVEN_CREDENTIALS, Collections.emptyList()));
        return credentials;
    }

    public MavenExecutionContextView setPomCache(MavenPomCache pomCache) {
        this.putMessage(MAVEN_POM_CACHE, pomCache);
        return this;
    }

    public MavenPomCache getPomCache() {
        return (MavenPomCache)this.getMessage(MAVEN_POM_CACHE, DEFAULT_POM_CACHE);
    }

    public MavenExecutionContextView setLocalRepository(MavenRepository localRepository) {
        this.putMessage(MAVEN_LOCAL_REPOSITORY, localRepository);
        return this;
    }

    public MavenRepository getLocalRepository() {
        return (MavenRepository)this.getMessage(MAVEN_LOCAL_REPOSITORY, MavenRepository.MAVEN_LOCAL_DEFAULT);
    }

    public MavenExecutionContextView setAddLocalRepository(boolean useLocalRepository) {
        this.putMessage(MAVEN_ADD_LOCAL_REPOSITORY, useLocalRepository);
        return this;
    }

    @Nullable
    public Boolean getAddLocalRepository() {
        return (Boolean)this.getMessage(MAVEN_ADD_LOCAL_REPOSITORY, null);
    }

    public MavenExecutionContextView setAddCentralRepository(boolean useCentralRepository) {
        this.putMessage(MAVEN_ADD_CENTRAL_REPOSITORY, useCentralRepository);
        return this;
    }

    @Nullable
    public Boolean getAddCentralRepository() {
        return (Boolean)this.getMessage(MAVEN_ADD_CENTRAL_REPOSITORY);
    }

    public MavenExecutionContextView setRepositories(List<MavenRepository> repositories) {
        this.putMessage(MAVEN_REPOSITORIES, repositories);
        return this;
    }

    public List<MavenRepository> getRepositories() {
        return (List)this.getMessage(MAVEN_REPOSITORIES, Collections.emptyList());
    }

    public List<MavenRepository> getRepositories(@Nullable MavenSettings mavenSettings, @Nullable List<String> activeProfiles) {
        if (mavenSettings != null) {
            return this.mapRepositories(mavenSettings, activeProfiles == null ? Collections.emptyList() : activeProfiles);
        }
        return (List)this.getMessage(MAVEN_REPOSITORIES, Collections.emptyList());
    }

    public MavenExecutionContextView setPinnedSnapshotVersions(Collection<ResolvedGroupArtifactVersion> pinnedSnapshotVersions) {
        this.putMessage(MAVEN_PINNED_SNAPSHOT_VERSIONS, pinnedSnapshotVersions);
        return this;
    }

    public Collection<ResolvedGroupArtifactVersion> getPinnedSnapshotVersions() {
        return (Collection)this.getMessage(MAVEN_PINNED_SNAPSHOT_VERSIONS, Collections.emptyList());
    }

    public MavenExecutionContextView setActiveProfiles(List<String> activeProfiles) {
        this.putMessage(MAVEN_ACTIVE_PROFILES, activeProfiles);
        return this;
    }

    public List<String> getActiveProfiles() {
        return (List)this.getMessage(MAVEN_ACTIVE_PROFILES, Collections.emptyList());
    }

    public MavenExecutionContextView setMavenSettings(@Nullable MavenSettings settings, String ... activeProfiles) {
        if (settings == null) {
            return this;
        }
        this.putMessage(MAVEN_SETTINGS, settings);
        List<String> effectiveActiveProfiles = MavenExecutionContextView.mapActiveProfiles(settings, activeProfiles);
        this.setActiveProfiles(effectiveActiveProfiles);
        this.setCredentials(MavenExecutionContextView.mapCredentials(settings));
        this.setMirrors(MavenExecutionContextView.mapMirrors(settings));
        this.setLocalRepository(settings.getMavenLocal());
        this.setRepositories(this.mapRepositories(settings, effectiveActiveProfiles));
        return this;
    }

    @Nullable
    public MavenSettings getSettings() {
        return (MavenSettings)this.getMessage(MAVEN_SETTINGS, null);
    }

    private static List<String> mapActiveProfiles(MavenSettings settings, String ... activeProfiles) {
        if (settings.getActiveProfiles() == null) {
            return Arrays.asList(activeProfiles);
        }
        return Stream.concat(settings.getActiveProfiles().getActiveProfiles().stream(), Arrays.stream(activeProfiles)).distinct().collect(Collectors.toList());
    }

    private static List<MavenRepositoryCredentials> mapCredentials(MavenSettings settings) {
        if (settings.getServers() != null) {
            return settings.getServers().getServers().stream().map(server -> new MavenRepositoryCredentials(server.getId(), server.getUsername(), server.getPassword())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private static List<MavenRepositoryMirror> mapMirrors(MavenSettings settings) {
        if (settings.getMirrors() != null) {
            return settings.getMirrors().getMirrors().stream().map(mirror -> new MavenRepositoryMirror(mirror.getId(), mirror.getUrl(), mirror.getMirrorOf(), mirror.getReleases(), mirror.getSnapshots(), settings.getServers())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private List<MavenRepository> mapRepositories(MavenSettings settings, List<String> activeProfiles) {
        Map<String, MavenRepository> repositories = this.getRepositories().stream().collect(Collectors.toMap(MavenRepository::getId, r -> r, (a, b) -> a));
        return settings.getActiveRepositories(activeProfiles).stream().map(repo -> {
            try {
                MavenRepository knownRepo = (MavenRepository)repositories.get(repo.getId());
                if (knownRepo != null) {
                    return new MavenRepository(repo.getId(), repo.getUrl(), repo.getReleases() != null ? repo.getReleases().getEnabled() : knownRepo.getReleases(), repo.getSnapshots() != null ? repo.getSnapshots().getEnabled() : knownRepo.getSnapshots(), knownRepo.isKnownToExist() && knownRepo.getUri().equals(repo.getUrl()), knownRepo.getUsername(), knownRepo.getPassword(), knownRepo.getTimeout(), knownRepo.getDeriveMetadataIfMissing());
                }
                return new MavenRepository(repo.getId(), repo.getUrl(), repo.getReleases() == null ? null : repo.getReleases().getEnabled(), repo.getSnapshots() == null ? null : repo.getSnapshots().getEnabled(), null, null, null);
            }
            catch (Exception exception) {
                this.getOnError().accept(new MavenParsingException("Unable to parse URL %s for Maven settings repository id %s", exception, repo.getUrl(), repo.getId()));
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

