/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.ProgressManagerListener;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.util.PingProgress;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.SystemNotifications;
import com.intellij.util.containers.ContainerUtil;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.util.Set;
import javax.swing.JFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ProgressManagerImpl
extends CoreProgressManager
implements Disposable {
    private static final Key<Boolean> SAFE_PROGRESS_INDICATOR = Key.create("SAFE_PROGRESS_INDICATOR");
    private final Set<CoreProgressManager.CheckCanceledHook> myHooks = ContainerUtil.newConcurrentSet();
    private volatile boolean myRunSleepHook;

    public ProgressManagerImpl() {
        ExtensionPointImpl.setCheckCanceledAction(ProgressManager::checkCanceled);
    }

    @Override
    public boolean hasUnsafeProgressIndicator() {
        return super.hasUnsafeProgressIndicator() || ContainerUtil.exists(ProgressManagerImpl.getCurrentIndicators(), ProgressManagerImpl::isUnsafeIndicator);
    }

    private static boolean isUnsafeIndicator(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            ProgressManagerImpl.$$$reportNull$$$0(0);
        }
        return indicator instanceof ProgressIndicatorBase && ((ProgressIndicatorBase)indicator).getUserData(SAFE_PROGRESS_INDICATOR) == null;
    }

    public void markProgressSafe(@NotNull UserDataHolder progress) {
        if (progress == null) {
            ProgressManagerImpl.$$$reportNull$$$0(1);
        }
        progress.putUserData(SAFE_PROGRESS_INDICATOR, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeProcessUnderProgress(@NotNull Runnable process, ProgressIndicator progress) throws ProcessCanceledException {
        CoreProgressManager.CheckCanceledHook hook;
        if (process == null) {
            ProgressManagerImpl.$$$reportNull$$$0(2);
        }
        CoreProgressManager.CheckCanceledHook checkCanceledHook = hook = progress instanceof PingProgress && ApplicationManager.getApplication().isDispatchThread() ? p -> {
            ((PingProgress)progress).interact();
            return true;
        } : null;
        if (hook != null) {
            this.addCheckCanceledHook(hook);
        }
        try {
            super.executeProcessUnderProgress(process, progress);
        }
        finally {
            if (hook != null) {
                this.removeCheckCanceledHook(hook);
            }
        }
    }

    @TestOnly
    public static void __testWhileAlwaysCheckingCanceled(@NotNull Runnable runnable) {
        if (runnable == null) {
            ProgressManagerImpl.$$$reportNull$$$0(3);
        }
        Thread fake = new Thread("fake");
        try {
            threadsUnderCanceledIndicator.add(fake);
            runnable.run();
        }
        finally {
            threadsUnderCanceledIndicator.remove(fake);
        }
    }

    @Override
    public boolean runProcessWithProgressSynchronously(@NotNull Task task) {
        if (task == null) {
            ProgressManagerImpl.$$$reportNull$$$0(4);
        }
        long start = System.currentTimeMillis();
        boolean result = super.runProcessWithProgressSynchronously(task);
        if (result) {
            JFrame frame;
            long end = System.currentTimeMillis();
            Task.NotificationInfo notificationInfo = task.notifyFinished();
            long time = end - start;
            if (notificationInfo != null && time > 5000L && (frame = WindowManager.getInstance().getFrame(task.getProject())) != null && !frame.hasFocus()) {
                ProgressManagerImpl.systemNotify(notificationInfo);
            }
        }
        return result;
    }

    private static void systemNotify(@NotNull Task.NotificationInfo info) {
        if (info == null) {
            ProgressManagerImpl.$$$reportNull$$$0(5);
        }
        SystemNotifications.getInstance().notify(info.getNotificationName(), info.getNotificationTitle(), info.getNotificationText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void startTask(@NotNull Task task, @NotNull ProgressIndicator indicator, @Nullable Runnable continuation) {
        if (task == null) {
            ProgressManagerImpl.$$$reportNull$$$0(6);
        }
        if (indicator == null) {
            ProgressManagerImpl.$$$reportNull$$$0(7);
        }
        ProgressManagerListener listener = ProgressManagerImpl.getProjectManagerListener();
        try {
            listener.beforeTaskStart(task, indicator);
        }
        finally {
            try {
                super.startTask(task, indicator, continuation);
            }
            finally {
                listener.afterTaskStart(task, indicator);
            }
        }
    }

    @Override
    @NotNull
    protected ProgressIndicator createDefaultAsynchronousProgressIndicator(@NotNull Task.Backgroundable task) {
        if (task == null) {
            ProgressManagerImpl.$$$reportNull$$$0(8);
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return ProgressManagerImpl.shouldKeepTasksAsynchronousInHeadlessMode() ? new ProgressIndicatorBase() : new EmptyProgressIndicator();
        }
        Project project = task.getProject();
        return project != null && project.isDisposed() ? new EmptyProgressIndicator() : new BackgroundableProcessIndicator(task);
    }

    @Override
    void notifyTaskFinished(@NotNull Task.Backgroundable task, long elapsed) {
        Window window;
        Task.NotificationInfo notificationInfo;
        if (task == null) {
            ProgressManagerImpl.$$$reportNull$$$0(9);
        }
        if ((notificationInfo = task.notifyFinished()) != null && elapsed > 5000L && ((window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow()) == null || notificationInfo.isShowWhenFocused())) {
            ProgressManagerImpl.systemNotify(notificationInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void finishTask(@NotNull Task task, boolean canceled, @Nullable Throwable error) {
        if (task == null) {
            ProgressManagerImpl.$$$reportNull$$$0(10);
        }
        ProgressManagerListener listener = ProgressManagerImpl.getProjectManagerListener();
        try {
            listener.beforeTaskFinished(task);
        }
        finally {
            try {
                super.finishTask(task, canceled, error);
            }
            finally {
                listener.afterTaskFinished(task);
            }
        }
    }

    @Override
    public boolean runInReadActionWithWriteActionPriority(@NotNull Runnable action, @Nullable ProgressIndicator indicator) {
        if (action == null) {
            ProgressManagerImpl.$$$reportNull$$$0(11);
        }
        return ProgressIndicatorUtils.runInReadActionWithWriteActionPriority((Runnable)action, (ProgressIndicator)indicator);
    }

    void addCheckCanceledHook(@NotNull CoreProgressManager.CheckCanceledHook hook) {
        if (hook == null) {
            ProgressManagerImpl.$$$reportNull$$$0(12);
        }
        if (this.myHooks.add(hook)) {
            this.updateShouldCheckCanceled();
        }
    }

    void removeCheckCanceledHook(@NotNull CoreProgressManager.CheckCanceledHook hook) {
        if (hook == null) {
            ProgressManagerImpl.$$$reportNull$$$0(13);
        }
        if (this.myHooks.remove(hook)) {
            this.updateShouldCheckCanceled();
        }
    }

    @Override
    public boolean runCheckCanceledHooks(@Nullable ProgressIndicator indicator) {
        if (!this.hasCheckCanceledHooks()) {
            return false;
        }
        CoreProgressManager.CheckCanceledHook[] activeHooks = this.myHooks.isEmpty() ? CoreProgressManager.CheckCanceledHook.EMPTY_ARRAY : this.myHooks.toArray(CoreProgressManager.CheckCanceledHook.EMPTY_ARRAY);
        boolean result = this.myRunSleepHook && this.sleepIfNeededToGivePriorityToAnotherThread();
        for (CoreProgressManager.CheckCanceledHook hook : activeHooks) {
            if (!hook.runHook(indicator)) continue;
            result = true;
        }
        return result;
    }

    @Override
    protected boolean hasCheckCanceledHooks() {
        return this.myRunSleepHook || !this.myHooks.isEmpty();
    }

    @Override
    protected void prioritizingStarted() {
        this.myRunSleepHook = true;
        this.updateShouldCheckCanceled();
    }

    @Override
    protected void prioritizingFinished() {
        this.myRunSleepHook = false;
        this.updateShouldCheckCanceled();
    }

    @NotNull
    private static ProgressManagerListener getProjectManagerListener() {
        ProgressManagerListener progressManagerListener = (ProgressManagerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(ProgressManagerListener.TOPIC);
        if (progressManagerListener == null) {
            ProgressManagerImpl.$$$reportNull$$$0(14);
        }
        return progressManagerListener;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hook";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/progress/impl/ProgressManagerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/progress/impl/ProgressManagerImpl";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectManagerListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isUnsafeIndicator";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "markProgressSafe";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "executeProcessUnderProgress";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "__testWhileAlwaysCheckingCanceled";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithProgressSynchronously";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "systemNotify";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "startTask";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultAsynchronousProgressIndicator";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "notifyTaskFinished";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "finishTask";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "runInReadActionWithWriteActionPriority";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addCheckCanceledHook";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removeCheckCanceledHook";
                break;
            }
            case 14: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14 -> new IllegalStateException(string);
        };
    }
}

