/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.python.tree;

import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.marker.Markers;

public final class PyComment
implements Comment {
    private final String text;
    private final String suffix;
    private final boolean alignedToIndent;
    private final Markers markers;

    public boolean isMultiline() {
        return false;
    }

    public <P> void printComment(Cursor cursor, PrintOutputCapture<P> p) {
        p.append("#").append(this.text);
    }

    public PyComment(String text, String suffix, boolean alignedToIndent, Markers markers) {
        this.text = text;
        this.suffix = suffix;
        this.alignedToIndent = alignedToIndent;
        this.markers = markers;
    }

    public String getText() {
        return this.text;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public boolean isAlignedToIndent() {
        return this.alignedToIndent;
    }

    public Markers getMarkers() {
        return this.markers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PyComment)) {
            return false;
        }
        PyComment other = (PyComment)o;
        if (this.isAlignedToIndent() != other.isAlignedToIndent()) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$suffix = this.getSuffix();
        String other$suffix = other.getSuffix();
        if (this$suffix == null ? other$suffix != null : !this$suffix.equals(other$suffix)) {
            return false;
        }
        Markers this$markers = this.getMarkers();
        Markers other$markers = other.getMarkers();
        return !(this$markers == null ? other$markers != null : !this$markers.equals(other$markers));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAlignedToIndent() ? 79 : 97);
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        String $suffix = this.getSuffix();
        result = result * 59 + ($suffix == null ? 43 : $suffix.hashCode());
        Markers $markers = this.getMarkers();
        result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
        return result;
    }

    public String toString() {
        return "PyComment(text=" + this.getText() + ", suffix=" + this.getSuffix() + ", alignedToIndent=" + this.isAlignedToIndent() + ", markers=" + this.getMarkers() + ")";
    }

    public PyComment withSuffix(String suffix) {
        return this.suffix == suffix ? this : new PyComment(this.text, suffix, this.alignedToIndent, this.markers);
    }

    public PyComment withAlignedToIndent(boolean alignedToIndent) {
        return this.alignedToIndent == alignedToIndent ? this : new PyComment(this.text, this.suffix, alignedToIndent, this.markers);
    }

    public PyComment withMarkers(Markers markers) {
        return this.markers == markers ? this : new PyComment(this.text, this.suffix, this.alignedToIndent, markers);
    }
}

