/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class DeleteKey
extends Recipe {
    @Option(displayName="Key path", description="A [JsonPath](https://docs.openrewrite.org/reference/jsonpath-and-jsonpathmatcher-reference) expression to locate a YAML entry.", example="$.source.kind")
    private final String keyPath;
    @Option(displayName="File pattern", description="A glob expression representing a file path to search for (relative to the project root). Blank/null matches all.", required=false, example=".github/workflows/*.yml")
    @Nullable
    private final String filePattern;

    public String getDisplayName() {
        return "Delete key";
    }

    public String getDescription() {
        return "Delete a YAML mapping entry key.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final JsonPathMatcher matcher = new JsonPathMatcher(this.keyPath);
        return Preconditions.check((Recipe)new FindSourceFiles(this.filePattern), (TreeVisitor)new YamlIsoVisitor<ExecutionContext>(){

            @Override
            public Yaml.Sequence.Entry visitSequenceEntry(Yaml.Sequence.Entry entry, ExecutionContext ctx) {
                if (matcher.matches(this.getCursor()) || matcher.matches(new Cursor(this.getCursor(), (Object)entry.getBlock()))) {
                    return null;
                }
                return super.visitSequenceEntry(entry, ctx);
            }

            @Override
            public Yaml.Mapping visitMapping(Yaml.Mapping mapping, ExecutionContext ctx) {
                Yaml m = super.visitMapping(mapping, ctx);
                AtomicReference copyFirstPrefix = new AtomicReference();
                if (!((Yaml.Mapping)(m = ((Yaml.Mapping)m).withEntries(ListUtils.map(((Yaml.Mapping)m).getEntries(), (i, e) -> {
                    if (matcher.matches(new Cursor(this.getCursor(), e))) {
                        if (i == 0 && this.getCursor().getParentOrThrow().getValue() instanceof Yaml.Sequence.Entry) {
                            copyFirstPrefix.set(e.getPrefix());
                        }
                        this.removeUnused(this.getCursor().getParent());
                        return null;
                    }
                    return e;
                })))).getEntries().isEmpty() && copyFirstPrefix.get() != null) {
                    m = ((Yaml.Mapping)m).withEntries(ListUtils.mapFirst(((Yaml.Mapping)m).getEntries(), e -> e.withPrefix((String)copyFirstPrefix.get())));
                }
                return m;
            }
        });
    }

    @Generated
    public DeleteKey(String keyPath, @Nullable String filePattern) {
        this.keyPath = keyPath;
        this.filePattern = filePattern;
    }

    @Generated
    public String getKeyPath() {
        return this.keyPath;
    }

    @Nullable
    @Generated
    public String getFilePattern() {
        return this.filePattern;
    }

    @NonNull
    @Generated
    public String toString() {
        return "DeleteKey(keyPath=" + this.getKeyPath() + ", filePattern=" + this.getFilePattern() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteKey)) {
            return false;
        }
        DeleteKey other = (DeleteKey)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$keyPath = this.getKeyPath();
        String other$keyPath = other.getKeyPath();
        if (this$keyPath == null ? other$keyPath != null : !this$keyPath.equals(other$keyPath)) {
            return false;
        }
        String this$filePattern = this.getFilePattern();
        String other$filePattern = other.getFilePattern();
        return !(this$filePattern == null ? other$filePattern != null : !this$filePattern.equals(other$filePattern));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DeleteKey;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $keyPath = this.getKeyPath();
        result = result * 59 + ($keyPath == null ? 43 : $keyPath.hashCode());
        String $filePattern = this.getFilePattern();
        result = result * 59 + ($filePattern == null ? 43 : $filePattern.hashCode());
        return result;
    }
}

