/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.treewalk.filter;

import java.io.IOException;
import org.openrewrite.jgit.errors.IncorrectObjectTypeException;
import org.openrewrite.jgit.errors.MissingObjectException;
import org.openrewrite.jgit.treewalk.TreeWalk;
import org.openrewrite.jgit.treewalk.WorkingTreeIterator;
import org.openrewrite.jgit.treewalk.filter.TreeFilter;

public class NotIgnoredFilter
extends TreeFilter {
    private final int index;

    public NotIgnoredFilter(int workdirTreeIndex) {
        this.index = workdirTreeIndex;
    }

    @Override
    public boolean include(TreeWalk tw) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        WorkingTreeIterator i = tw.getTree(this.index, WorkingTreeIterator.class);
        return i == null || !i.isEntryIgnored();
    }

    @Override
    public boolean shouldBeRecursive() {
        return false;
    }

    @Override
    public TreeFilter clone() {
        return this;
    }

    @Override
    public String toString() {
        return "NotIgnored(" + this.index + ")";
    }
}

