/*
 * Copyright (c) 2005, John Mettraux, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: WsParamMapper.java 2859 2006-06-23 12:25:24Z lukas_eder $
 */

//
// WsParamMapper.java
//
// john.mettraux@openwfe.org
//
// generated with 
// jtmpl 1.1.01 2004/05/19 (john.mettraux@openwfe.org)
//

package openwfe.org.ws.invoker;


import org.apache.axis.client.Call;

import openwfe.org.engine.workitem.InFlowWorkItem;


/**
 * An interface for mapping a workitem to a set of webservice invocation
 * parameters.
 *
 * <p><font size=2>CVS Info :
 * <br>$Author: lukas_eder $
 * <br>$Id: WsParamMapper.java 2859 2006-06-23 12:25:24Z lukas_eder $ </font>
 *
 * @author john.mettraux@openwfe.org
 */
public interface WsParamMapper
{

    /**
     * The WsParamMapper implementation looks at the participant name found
     * in the workitem and then set call parameters accordingly.
     */
    public Object[] prepareParams (Call call, InFlowWorkItem wi)
        throws WsException;

    /**
     * Given a participant name (as found in the given workitem) returns
     * into which field the return value of the webservice invocation should
     * be stored.
     */
    public String determineToField (InFlowWorkItem wi)
        throws WsException;

}
