/*
 * Copyright (c) 2005-2006, Christelle Heritier, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: MyThread.java 3221 2006-09-04 09:10:14Z jmettraux $
 */
package openwfe.org.ws.worklist.test;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.LinkedList;

/**
 * @author Heritier Christelle
 * 
 * read the information entered by the user and transmit them to the SoapClient
 */
public class MyThread extends Thread {

	SoapClient cl;

	public MyThread(SoapClient client) {
		cl = client;
	}

	public void run() {

		BufferedReader keyboard = new BufferedReader(new InputStreamReader(System.in));
		String line;
		Object[] params;
		try {
			while (true) {
				line = keyboard.readLine();
				LinkedList temp = new LinkedList();
				String word = "";
				for (int i = 0; i < line.length(); i++) {
					char c = line.charAt(i);
					if (!(Character.isWhitespace(c))) {
						word += c;
					} else {
						temp.add(word);
						word = "";
					}
				}
				temp.add(word);
				params = temp.toArray();
				cl.call(params);
			}
		} catch (Exception e) {
			System.out.println(e.getStackTrace());
		}
	}
}
