/*
 * Copyright (c) 2005-2006, Christelle Heritier, OpenWFE.org
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * . Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.  
 * 
 * . Redistributions in binary form must reproduce the above copyright notice, 
 *   this list of conditions and the following disclaimer in the documentation 
 *   and/or other materials provided with the distribution.
 * 
 * . Neither the name of the "OpenWFE" nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: SoapClient.java 3221 2006-09-04 09:10:14Z jmettraux $
 */
package openwfe.org.ws.worklist.test;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import openwfe.org.engine.expressions.FlowExpressionId;
import openwfe.org.engine.workitem.Attribute;
import openwfe.org.engine.workitem.HistoryItem;
import openwfe.org.engine.workitem.InFlowWorkItem;
import openwfe.org.engine.workitem.LaunchItem;
import openwfe.org.engine.workitem.StringAttribute;
import openwfe.org.engine.workitem.StringMapAttribute;
import openwfe.org.worklist.Launchable;

import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.configuration.XMLStringProvider;
import org.apache.axis.encoding.XMLType;
import org.apache.axis.utils.Options;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.ServiceException;

/**
 * @author Heritier Christelle
 * 
 * this class is an exemple of Client to invoke the 'RmiSoapWorkSession' service
 */
public class SoapClient {

	static Service service;
	private InFlowWorkItem flow = null;
	//HashMap with ID of the InFlowWorkItem 
	private HashMap map = new HashMap();
	static String endpointURL;

	//variables used to serialize/deserialize objects
	QName qnArrayList = new QName("urn:BeanService", "ArrayList");
	QName qnFlow = new QName("urn:BeanService", "FlowExpressionId");
	QName qnInFlow = new QName("urn:BeanService", "InFlowWorkItem");
	QName qnLaunch = new QName("urn:BeanService", "LaunchItem");
	QName qnHeader = new QName("urn:BeanService", "Header");
	QName qnStringMapAttribute = new QName("urn:BeanService","StringMapAttribute");
	QName qnStringAttribute = new QName("urn:BeanService", "StringAttribute");
	QName qnLaunchable = new QName("urn:BeanService", "Launchable");
	QName qnHistoryItem = new QName("urn:BeanService", "HistoryItem");


	public static void main(String[] args) throws ServiceException, IOException {
		try {
			Options options = new Options(args);
			endpointURL = options.getURL();
			//config-client.xml = XML document that contains the information for the client
			//this document is important to maintain the session
			URL adress = 
                            new URL("http://localhost:8090/ws_worklist/config-client.xml");
			InputStream stream = adress.openStream();
			String file = "";
			int end;
			while ((end = stream.read()) != -1) {
				file += ((char) end);
			}
			stream.close();
			XMLStringProvider xmlProvider = new XMLStringProvider(file);

			//new service 
			service = new Service(xmlProvider);
			//maintain the new session
			service.setMaintainSession(true);
			SoapClient client = new SoapClient();
			System.out.print("$ ");
			MyThread t = new MyThread(client);
			t.start();
		} catch (MalformedURLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

	
	/*
	 * identify the method to invoke and then invoke it
	 */
	public void call(Object[] args) {
		try {
			String method = (String) args[0];
			Call call = (Call) service.createCall();
			// define the serializer/deserializer
			call.registerTypeMapping(
							ArrayList.class,
							qnArrayList,
							new org.apache.axis.encoding.ser.ArraySerializerFactory(),
							new org.apache.axis.encoding.ser.ArrayDeserializerFactory());
			call.registerTypeMapping(FlowExpressionId.class, qnFlow,
					new org.apache.axis.encoding.ser.BeanSerializerFactory(
							FlowExpressionId.class, qnFlow),
					new org.apache.axis.encoding.ser.BeanDeserializerFactory(
							FlowExpressionId.class, qnFlow));
			call.registerTypeMapping(InFlowWorkItem.class, qnInFlow,
					new org.apache.axis.encoding.ser.BeanSerializerFactory(
							InFlowWorkItem.class, qnInFlow),
					new org.apache.axis.encoding.ser.BeanDeserializerFactory(
							InFlowWorkItem.class, qnInFlow));
			call.registerTypeMapping(LaunchItem.class, qnLaunch,
					new org.apache.axis.encoding.ser.BeanSerializerFactory(
							LaunchItem.class, qnLaunch),
					new org.apache.axis.encoding.ser.BeanDeserializerFactory(
							LaunchItem.class, qnLaunch));
			call.registerTypeMapping(openwfe.org.worklist.Header.class,qnHeader,
					new org.apache.axis.encoding.ser.BeanSerializerFactory(
							openwfe.org.worklist.Header.class, qnHeader),
					new org.apache.axis.encoding.ser.BeanDeserializerFactory(
							openwfe.org.worklist.Header.class, qnHeader));
			call.registerTypeMapping(StringMapAttribute.class,qnStringMapAttribute,
					new org.apache.axis.encoding.ser.BeanSerializerFactory(
							StringMapAttribute.class, qnStringMapAttribute),
					new org.apache.axis.encoding.ser.BeanDeserializerFactory(
							StringMapAttribute.class, qnStringMapAttribute));
			call.registerTypeMapping(StringAttribute.class, qnStringAttribute,
					new org.apache.axis.encoding.ser.BeanSerializerFactory(
							StringAttribute.class, qnStringAttribute),
					new org.apache.axis.encoding.ser.BeanDeserializerFactory(
							StringAttribute.class, qnStringAttribute));
			call.registerTypeMapping(Launchable.class, qnLaunchable,
					new org.apache.axis.encoding.ser.BeanSerializerFactory(
							Launchable.class, qnLaunchable),
					new org.apache.axis.encoding.ser.BeanDeserializerFactory(
							Launchable.class, qnLaunchable));
			call.registerTypeMapping(HistoryItem.class, qnHistoryItem,
					new org.apache.axis.encoding.ser.BeanSerializerFactory(
							HistoryItem.class, qnHistoryItem),
					new org.apache.axis.encoding.ser.BeanDeserializerFactory(
							HistoryItem.class, qnHistoryItem));

			call.setTargetEndpointAddress(new java.net.URL(endpointURL));
			call.setOperationName(method);

			//selection of the method
			//invoke this method with the right parameters
			if (method.equals("quit")) {
				System.exit(0);
			}
			else if(method.equals("modify")){
				String a = (String) args[1];
				InFlowWorkItem flow = new InFlowWorkItem();
				flow = (InFlowWorkItem)map.get(a);
				System.out.println("attributes: "+flow.getAttribute("h2"));
				Attribute att = new StringAttribute("only a test");
				flow.setAttribute("h2",att);
				System.out.println("new attributes: "+flow.getAttribute("h2"));
				map.put(a,flow);
			}
			else if (method.equals("countWorkItems")) {
				String a = (String) args[1];
				call.addParameter("arg1", XMLType.XSD_STRING, ParameterMode.IN);
				call.setReturnType(XMLType.XSD_INT);
				Integer ret = (Integer) call.invoke("RmiSoapWorkSession",
						"countWorkItems", new Object[] { a });
				System.out.println("nb of WorkItems : " + ret);
			} else if (method.equals("authentify")) {
				String a = (String) args[1];
				String b = (String) args[2];
				call.addParameter("arg1", XMLType.XSD_STRING, ParameterMode.IN);
				call.addParameter("arg2", XMLType.XSD_STRING, ParameterMode.IN);
				call.setReturnType(XMLType.XSD_BOOLEAN);
				Boolean ret = (Boolean) call.invoke("RmiSoapWorkSession",
						"authentify", new Object[] { a, b });
				System.out.println("You are authentify : " + ret);
				//method used to verify there is only one Session
				/*
			} else if (method.equals("Hello")) {
				call.setReturnType(XMLType.XSD_STRING);
				String ret = (String) call.invoke("RmiSoapWorkSession",
						"Hello", null);
				System.out.println("Result : " + ret);
				*/
			} else if (method.equals("getStoreNames")) {
				call.setReturnType(qnArrayList);
				ArrayList ret = (ArrayList) call.invoke("RmiSoapWorkSession",
						"getStoreNames", null);
				System.out.println("Result: " + ret.size());
				for (int i = 0; i < ret.size(); i++) {
					System.out.println(ret.get(i).toString());
				}
			} else if (method.equals("findFlowInstance")) {
				String a = (String) args[1];
				String b = (String) args[2];
				call.addParameter("arg1", XMLType.XSD_STRING, ParameterMode.IN);
				call.addParameter("arg2", XMLType.XSD_STRING, ParameterMode.IN);
				call.setReturnType(qnArrayList);
				ArrayList ret = (ArrayList) call.invoke("RmiSoapWorkSession",
						"findFlowInstance", new Object[] { a, b });
				System.out.println("Nb of FlowInstance: " + ret.size());
				for (int i = 0; i < ret.size(); i++) {
					System.out.println(ret.get(i).toString() + "\n");
				}
			} else if (method.equals("getHeaders")) {
				String a = (String) args[1];
				Integer b = new Integer((String) args[2]);
				call.addParameter("arg1", XMLType.XSD_STRING, ParameterMode.IN);
				call.addParameter("arg2", XMLType.XSD_INT, ParameterMode.IN);
				call.setReturnType(qnArrayList);
				ArrayList ret = (ArrayList) call.invoke("RmiSoapWorkSession",
						"getHeaders", new Object[] { a, b });
				System.out.println("The List contain: " + ret.size());
				System.out.print(headerToString(ret));
			} else if (method.equals("get")) {
				String a = (String) args[1];
				call.addParameter("arg1", XMLType.XSD_STRING, ParameterMode.IN);
				if (args.length == 3) {
					String b = (String) args[2];
					call.addParameter("arg2", XMLType.XSD_STRING,
							ParameterMode.IN);
					call.setReturnType(qnInFlow);
					InFlowWorkItem ret = (InFlowWorkItem) call.invoke(
							"RmiSoapWorkSession", "get", new Object[] { a, b });
					map.put(ret.getId().getWorkflowInstanceId(), ret);
					System.out.println(flowToString(ret));
				} else {
					FlowExpressionId b = new FlowExpressionId();
					b.setInitialEngineId((String)args[2]);
					b.setEngineId((String) args[3]);
					b.setWorkflowDefinitionUrl((String)args[4]);
					b.setWorkflowDefinitionName((String) args[5]);
					b.setWorkflowDefinitionRevision((String) args[6]);
					b.setWorkflowInstanceId((String) args[7]);
					b.setExpressionName((String)args[8]);
					b.setExpressionId((String) args[9]);
					call.addParameter("arg2", qnFlow, ParameterMode.IN);
					call.setReturnType(qnInFlow);
					InFlowWorkItem ret = (InFlowWorkItem) call.invoke(
							"RmiSoapWorkSession", "get", new Object[] { a, b });
					map.put(ret.getId().getWorkflowInstanceId(), ret);
					System.out.println(flowToString(ret));
				}
			} else if (method.equals("getAndLock")) {
				String a = (String) args[1];
				call.addParameter("arg1", XMLType.XSD_STRING, ParameterMode.IN);
				if (args.length == 3) {
					String b = (String) args[2];
					call.addParameter("arg2", XMLType.XSD_STRING,
							ParameterMode.IN);
					call.setReturnType(qnInFlow);
					InFlowWorkItem ret = (InFlowWorkItem) call.invoke(
							"RmiSoapWorkSession", "getAndLock", new Object[] {
									a, b });
					map.put( ret.getId().getWorkflowInstanceId() ,ret);
					System.out.println(flowToString(ret));
				} else {
					FlowExpressionId b = new FlowExpressionId();
					b.setInitialEngineId((String)args[2]);
					b.setEngineId((String) args[3]);
					b.setWorkflowDefinitionUrl((String)args[4]);
					b.setWorkflowDefinitionName((String) args[5]);
					b.setWorkflowDefinitionRevision((String) args[6]);
					b.setWorkflowInstanceId((String) args[7]);
					b.setExpressionName((String)args[8]);
					b.setExpressionId((String) args[9]);
					call.addParameter("arg2", qnFlow, ParameterMode.IN);
					call.setReturnType(qnInFlow);
					InFlowWorkItem ret = (InFlowWorkItem) call.invoke(
							"RmiSoapWorkSession", "getAndLock", new Object[] {a, b });
					map.put(ret.getId().getWorkflowInstanceId(),ret);
					System.out.println(flowToString(ret));
				}
			} else if (method.equals("release")) {
				String a = (String) args[1];
				InFlowWorkItem b = new InFlowWorkItem();
				String c = (String) args[2];
				b = (InFlowWorkItem)map.get(c);
				call.addParameter("arg1", XMLType.XSD_STRING, ParameterMode.IN);
				call.addParameter("arg2", qnInFlow, ParameterMode.IN);
				call.invoke("RmiSoapWorkSession", "release", new Object[] { a, b});
				System.out.println("OK...release");
			} else if (method.equals("save")) {
				String a = (String) args[1];
				InFlowWorkItem b = new InFlowWorkItem();
				String c = (String) args[2];
				b = (InFlowWorkItem)map.get(c);
				System.out.println("valeur: " + b.toString());
				call.addParameter("arg1", XMLType.XSD_STRING, ParameterMode.IN);
				call.addParameter("arg2", qnInFlow, ParameterMode.IN);
				call.invoke("RmiSoapWorkSession", "save", new Object[] { a, b });
				System.out.println("OK...save");
			} else if (method.equals("forward")) {
				String a = (String) args[1];
				InFlowWorkItem b = new InFlowWorkItem();
				String c = (String) args[2];
				b = (InFlowWorkItem)map.get(c);
				call.addParameter("arg1", XMLType.XSD_STRING, ParameterMode.IN);
				call.addParameter("arg2", qnInFlow, ParameterMode.IN);
				call.invoke("RmiSoapWorkSession", "forward", new Object[] { a,b });
				System.out.println("OK...forward");
			} else if (method.equals("getLaunchables")) {
				try {
					call.setReturnType(qnArrayList);
					ArrayList ret = (ArrayList) call.invoke(
							"RmiSoapWorkSession", "getLaunchables", null);
					System.out.println("Nb of LaunchItem: " + ret.size());
					for (int i = 0; i < ret.size(); i++) {
							System.out.println( ret.get(i).toString());
					}
				} catch (Exception e) {
					e.printStackTrace();
				}
			} else if (method.equals("launch")) {
				String a = (String) args[1];
				LaunchItem b = new LaunchItem();
				b.setWorkflowDefinitionUrl((String) args[2]);
				call.addParameter("arg1", XMLType.XSD_STRING, ParameterMode.IN);
				call.addParameter("arg2", qnLaunch, ParameterMode.IN);
				call.setReturnType(XMLType.XSD_STRING);
				String ret = (String) call.invoke("RmiSoapWorkSession",
						"launch", new Object[] { a, b });
				System.out.println("the flow: " + ret);
			} else if (method.equals("delegate")) {
				String a = (String) args[1];
				InFlowWorkItem b = new InFlowWorkItem();
				String d = (String) args[2];
				String c = (String) args[3];
				b = (InFlowWorkItem)map.get(d);
				call.addParameter("arg1", XMLType.XSD_STRING, ParameterMode.IN);
				call.addParameter("arg2", qnInFlow, ParameterMode.IN);
				call.addParameter("arg3", XMLType.XSD_STRING, ParameterMode.IN);
				call.invoke("RmiSoapWorkSession", "delegate", new Object[] { a,
						b, c });
				System.out.println("OK...delegate");
			} else if (method.equals("getParticipantsForDelegation")) {
				call.setReturnType(qnArrayList);
				ArrayList ret = (ArrayList) call.invoke("RmiSoapWorkSession",
						"getParticipantsForDelegation", null);
				System.out.println("Size: " + ret.size());
				for (int i = 0; i < ret.size(); i++) {
					System.out.print("participant: "+ret.get(i).toString());
				}
			} else if (method.equals("delegateToParticipant")) {
				String a = (String) args[1];
				InFlowWorkItem b = new InFlowWorkItem();
				String d = (String) args[2];
				b = (InFlowWorkItem)map.get(d);
				String c = (String) args[3];
				call.addParameter("arg1", XMLType.XSD_STRING, ParameterMode.IN);
				call.addParameter("arg2", qnInFlow, ParameterMode.IN);
				call.addParameter("arg3", XMLType.XSD_STRING, ParameterMode.IN);
				call.invoke("RmiSoapWorkSession", "delegateToParticipant",
						new Object[] { a, b, c });
				System.out.println("OK...delegateToParticipant");
			} else if (method.equals("checkPermission")) {
				String a = (String) args[1];
				String b = (String) args[2];
				call.addParameter("arg1", XMLType.XSD_STRING, ParameterMode.IN);
				call.addParameter("arg2", XMLType.XSD_STRING, ParameterMode.IN);
				call.setReturnType(XMLType.XSD_BOOLEAN);
				Boolean ret = (Boolean) call.invoke("RmiSoapWorkSession",
						"checkPermission", new Object[] { a, b });
				System.out.println("Permission to "+b+" :" + ret);
			} else {
				System.out
						.println("this method: " + method + "doesn't exist ");
			}
			System.out.print("$ ");

		} catch (Exception e) {
                    e.printStackTrace();
                    //System.err.println(e.toString());
		}
	}
	/*
	 * show informations contain in the InFlowWorkItem
	 */
	public String flowToString(InFlowWorkItem item){
		String flow ="";
		List history = item.getHistory();
		Map attr = item.getAttributes().getMap();
		Iterator it = attr.keySet().iterator();
		flow ="InFlowWorkItem : "+item.getId().getWorkflowDefinitionName()+"\n ";
		flow += item.getId().getWorkflowDefinitionRevision()+"\n";
		flow += item.getDispatchTime()+" "+item.getParticipantName()+"\n";
		flow += ("History :\n");
		for (int i = 0; i<history.size();i++){
		flow +=((HistoryItem) history.get(i)).getDate()+" ";
		flow +=((HistoryItem) history.get(i)).getAuthor()+" ";
		flow +=((HistoryItem) history.get(i)).getText()+"\n";
		}
		flow += ("attributes: \n");
		while (it.hasNext()){
			String next = it.next().toString();
			flow += next;
			flow += (" value :");
			flow += item.getAttribute(next)+"\n";
			}
		return flow;
	}
	/*
	 * show some informations about the Headers
	 */
	public String headerToString (ArrayList array){
		String Header = "";
		for (int i=0; i<array.size(); i++){
		String item = array.get(i).toString();
		int begin = item.indexOf("<instance");
		int end = item.indexOf("</instance>");
		end = end+11;
		Header += item.substring(begin, end);
		Header += "\n";
		}
		return Header;
	}

}

