/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.profile;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import java.net.URI;
import java.text.ParseException;
import java.util.Date;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.jwt.AbstractJwtProfile;

public class OidcProfile
extends AbstractJwtProfile {
    private static final long serialVersionUID = -52855988661742374L;

    public String getFirstName() {
        return (String)this.getAttribute("given_name");
    }

    public String getMiddleName() {
        return (String)this.getAttribute("middle_name");
    }

    public String getDisplayName() {
        return (String)this.getAttribute("name");
    }

    public String getNickname() {
        return (String)this.getAttribute("nickname");
    }

    public String getUsername() {
        return (String)this.getAttribute("preferred_username");
    }

    public URI getPictureUrl() {
        return (URI)this.getAttribute("picture");
    }

    public URI getProfileUrl() {
        return (URI)this.getAttribute("profile");
    }

    public String getLocation() {
        return (String)this.getAttribute("zoneinfo");
    }

    public Boolean getEmailVerified() {
        return (Boolean)this.getAttribute("email_verified");
    }

    public String getPhoneNumber() {
        return (String)this.getAttribute("phone_number");
    }

    public Boolean getPhoneNumberVerified() {
        return (Boolean)this.getAttribute("phone_number_verified");
    }

    public Date getUpdatedAt() {
        return (Date)this.getAttribute("updated_at");
    }

    public Date getAuthTime() {
        return (Date)this.getAttribute("auth_time");
    }

    public String getNonce() {
        return (String)this.getAttribute("nonce");
    }

    public String getAcr() {
        return (String)this.getAttribute("acr");
    }

    public Object getAmr() {
        return this.getAttribute("amr");
    }

    public String getAzp() {
        return (String)this.getAttribute("azp");
    }

    public void setAccessToken(AccessToken accessToken) {
        this.addAttribute("access_token", accessToken);
    }

    public AccessToken getAccessToken() {
        return (AccessToken)this.getAttribute("access_token");
    }

    public String getIdTokenString() {
        return (String)this.getAttribute("id_token");
    }

    public void setIdTokenString(String idToken) {
        this.addAttribute("id_token", idToken);
    }

    public JWT getIdToken() {
        try {
            return JWTParser.parse((String)this.getIdTokenString());
        }
        catch (ParseException e) {
            throw new TechnicalException((Throwable)e);
        }
    }

    public RefreshToken getRefreshToken() {
        return (RefreshToken)this.getAttribute("refresh_token");
    }

    public void setRefreshToken(RefreshToken refreshToken) {
        this.addAttribute("refresh_token", refreshToken);
    }

    public void clearSensitiveData() {
        this.removeAttribute("access_token");
        this.removeAttribute("id_token");
        this.removeAttribute("refresh_token");
    }
}

