/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.profile.azuread;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.oidc.profile.OidcProfile;

public class AzureAdProfile
extends OidcProfile {
    private static final long serialVersionUID = -8659029290353954198L;
    private int idTokenExpireAdvance;

    public AzureAdProfile() {
        this.idTokenExpireAdvance = 10;
    }

    public AzureAdProfile(int idTokenExpireAdvance) {
        this.idTokenExpireAdvance = idTokenExpireAdvance;
    }

    public String getIdp() {
        return (String)this.getAttribute("idp");
    }

    public String getOid() {
        return (String)this.getAttribute("oid");
    }

    public String getTid() {
        return (String)this.getAttribute("tid");
    }

    public String getVer() {
        return (String)this.getAttribute("ver");
    }

    public String getUniqueName() {
        return (String)this.getAttribute("unique_name");
    }

    public String getIpaddr() {
        return (String)this.getAttribute("ipaddr");
    }

    public String getUpn() {
        return (String)this.getAttribute("upn");
    }

    @Override
    public String getUsername() {
        return (String)this.getAttribute("upn");
    }

    public boolean isExpired() {
        try {
            JWT jwt = this.getIdToken();
            JWTClaimsSet claims = jwt.getJWTClaimsSet();
            Date expiresOn = claims.getExpirationTime();
            Calendar now = Calendar.getInstance();
            now.add(13, this.idTokenExpireAdvance);
            if (expiresOn.before(now.getTime())) {
                return true;
            }
        }
        catch (ParseException e) {
            throw new TechnicalException((Throwable)e);
        }
        return false;
    }
}

