/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oidc.profile.creator;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.UserInfoErrorResponse;
import com.nimbusds.openid.connect.sdk.UserInfoRequest;
import com.nimbusds.openid.connect.sdk.UserInfoResponse;
import com.nimbusds.openid.connect.sdk.UserInfoSuccessResponse;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import com.nimbusds.openid.connect.sdk.validators.IDTokenValidator;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.profile.AttributeLocation;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.creator.ProfileCreator;
import org.pac4j.core.profile.definition.ProfileDefinition;
import org.pac4j.core.profile.definition.ProfileDefinitionAware;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oidc.config.OidcConfiguration;
import org.pac4j.oidc.credentials.OidcCredentials;
import org.pac4j.oidc.profile.OidcProfile;
import org.pac4j.oidc.profile.OidcProfileDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcProfileCreator<U extends OidcProfile>
extends ProfileDefinitionAware<U>
implements ProfileCreator<OidcCredentials, U> {
    private static final Logger logger = LoggerFactory.getLogger(OidcProfileCreator.class);
    protected OidcConfiguration configuration;
    protected IDTokenValidator idTokenValidator;

    public OidcProfileCreator(OidcConfiguration configuration) {
        this.configuration = configuration;
    }

    protected void internalInit() {
        JWSAlgorithm jwsAlgorithm;
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)this.configuration));
        List metadataAlgorithms = this.configuration.findProviderMetadata().getIDTokenJWSAlgs();
        CommonHelper.assertTrue((boolean)CommonHelper.isNotEmpty((Collection)metadataAlgorithms), (String)"There must at least one JWS algorithm supported on the OpenID Connect provider side");
        JWSAlgorithm preferredAlgorithm = this.configuration.getPreferredJwsAlgorithm();
        if (metadataAlgorithms.contains(preferredAlgorithm)) {
            jwsAlgorithm = preferredAlgorithm;
        } else {
            jwsAlgorithm = (JWSAlgorithm)metadataAlgorithms.get(0);
            logger.warn("Preferred JWS algorithm: {} not available. Defaulting to: {}", (Object)preferredAlgorithm, (Object)jwsAlgorithm);
        }
        if ("none".equals(jwsAlgorithm.getName())) {
            jwsAlgorithm = null;
        }
        ClientID _clientID = new ClientID(this.configuration.getClientId());
        Secret _secret = new Secret(this.configuration.getSecret());
        this.idTokenValidator = jwsAlgorithm == null ? new IDTokenValidator(this.configuration.findProviderMetadata().getIssuer(), _clientID) : (CommonHelper.isNotBlank((String)this.configuration.getSecret()) && (JWSAlgorithm.HS256.equals((Object)jwsAlgorithm) || JWSAlgorithm.HS384.equals((Object)jwsAlgorithm) || JWSAlgorithm.HS512.equals((Object)jwsAlgorithm)) ? this.createHMACTokenValidator(jwsAlgorithm, _clientID, _secret) : this.createRSATokenValidator(jwsAlgorithm, _clientID));
        this.idTokenValidator.setMaxClockSkew(this.configuration.getMaxClockSkew());
        this.defaultProfileDefinition((ProfileDefinition)new OidcProfileDefinition());
    }

    protected IDTokenValidator createRSATokenValidator(JWSAlgorithm jwsAlgorithm, ClientID clientID) {
        try {
            return new IDTokenValidator(this.configuration.findProviderMetadata().getIssuer(), clientID, jwsAlgorithm, this.configuration.findProviderMetadata().getJWKSetURI().toURL(), this.configuration.findResourceRetriever());
        }
        catch (MalformedURLException e) {
            throw new TechnicalException((Throwable)e);
        }
    }

    protected IDTokenValidator createHMACTokenValidator(JWSAlgorithm jwsAlgorithm, ClientID clientID, Secret secret) {
        return new IDTokenValidator(this.configuration.findProviderMetadata().getIssuer(), clientID, jwsAlgorithm, secret);
    }

    public U create(OidcCredentials credentials, WebContext context) {
        this.init();
        AccessToken accessToken = credentials.getAccessToken();
        OidcProfile profile = (OidcProfile)this.getProfileDefinition().newProfile(new Object[0]);
        profile.setAccessToken(accessToken);
        JWT idToken = credentials.getIdToken();
        profile.setIdTokenString(idToken.getParsedString());
        RefreshToken refreshToken = credentials.getRefreshToken();
        if (refreshToken != null && !refreshToken.getValue().isEmpty()) {
            profile.setRefreshToken(refreshToken);
            logger.debug("Refresh Token successful retrieved");
        }
        try {
            Nonce nonce = this.configuration.isUseNonce() ? new Nonce((String)context.getSessionStore().get(context, "oidcNonceAttribute")) : null;
            IDTokenClaimsSet claimsSet = this.idTokenValidator.validate(idToken, nonce);
            CommonHelper.assertNotNull((String)"claimsSet", (Object)claimsSet);
            profile.setId(ProfileHelper.sanitizeIdentifier((UserProfile)profile, (Object)claimsSet.getSubject()));
            if (this.configuration.findProviderMetadata().getUserInfoEndpointURI() != null && accessToken != null) {
                UserInfoRequest userInfoRequest = new UserInfoRequest(this.configuration.findProviderMetadata().getUserInfoEndpointURI(), (BearerAccessToken)accessToken);
                HTTPRequest userInfoHttpRequest = userInfoRequest.toHTTPRequest();
                userInfoHttpRequest.setConnectTimeout(this.configuration.getConnectTimeout());
                userInfoHttpRequest.setReadTimeout(this.configuration.getReadTimeout());
                HTTPResponse httpResponse = userInfoHttpRequest.send();
                logger.debug("Token response: status={}, content={}", (Object)httpResponse.getStatusCode(), (Object)httpResponse.getContent());
                UserInfoResponse userInfoResponse = UserInfoResponse.parse((HTTPResponse)httpResponse);
                if (userInfoResponse instanceof UserInfoErrorResponse) {
                    logger.error("Bad User Info response, error={}", (Object)((UserInfoErrorResponse)userInfoResponse).getErrorObject());
                } else {
                    UserInfoSuccessResponse userInfoSuccessResponse = (UserInfoSuccessResponse)userInfoResponse;
                    JWTClaimsSet userInfoClaimsSet = userInfoSuccessResponse.getUserInfo() != null ? userInfoSuccessResponse.getUserInfo().toJWTClaimsSet() : userInfoSuccessResponse.getUserInfoJWT().getJWTClaimsSet();
                    this.getProfileDefinition().convertAndAdd((CommonProfile)profile, userInfoClaimsSet.getClaims(), null);
                }
            }
            for (Map.Entry entry : idToken.getJWTClaimsSet().getClaims().entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if ("sub".equals(key) || profile.getAttribute(key) != null) continue;
                this.getProfileDefinition().convertAndAdd((CommonProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, key, value);
            }
            return (U)((Object)profile);
        }
        catch (JOSEException | BadJOSEException | ParseException | IOException | java.text.ParseException e) {
            throw new TechnicalException(e);
        }
    }
}

