/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.springframework.security.authentication;

import java.util.List;
import lombok.Generated;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.springframework.security.authentication.Pac4jAuthentication;
import org.pac4j.springframework.security.util.SpringSecurityHelper;
import org.springframework.security.authentication.RememberMeAuthenticationToken;

public class Pac4jRememberMeAuthenticationToken
extends RememberMeAuthenticationToken
implements Pac4jAuthentication {
    private final List<UserProfile> profiles;

    public Pac4jRememberMeAuthenticationToken(List<UserProfile> profiles) {
        super("rme", ProfileHelper.flatIntoOneProfile(profiles).get(), SpringSecurityHelper.buildAuthorities(profiles));
        this.profiles = profiles;
        this.setAuthenticated(true);
    }

    public String getName() {
        return ((CommonProfile)this.getPrincipal()).getId();
    }

    @Override
    public List<UserProfile> getProfiles() {
        return this.profiles;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pac4jRememberMeAuthenticationToken)) {
            return false;
        }
        Pac4jRememberMeAuthenticationToken other = (Pac4jRememberMeAuthenticationToken)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<UserProfile> this$profiles = this.profiles;
        List<UserProfile> other$profiles = other.profiles;
        return !(this$profiles == null ? other$profiles != null : !((Object)this$profiles).equals(other$profiles));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Pac4jRememberMeAuthenticationToken;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<UserProfile> $profiles = this.profiles;
        result = result * 59 + ($profiles == null ? 43 : ((Object)$profiles).hashCode());
        return result;
    }
}

