/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.springframework.security.web;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import lombok.Generated;
import org.pac4j.core.adapter.FrameworkAdapter;
import org.pac4j.core.client.Client;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.FrameworkParameters;
import org.pac4j.core.engine.DefaultSecurityLogic;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.jee.context.JEEFrameworkParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;

public class Pac4jEntryPoint
extends DefaultSecurityLogic
implements AuthenticationEntryPoint {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(Pac4jEntryPoint.class);
    private Config config;
    private String clientName;

    public Pac4jEntryPoint() {
    }

    public Pac4jEntryPoint(Config config, String clientName) {
        this.config = config;
        this.clientName = clientName;
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        HttpAction action;
        HttpActionAdapter adapter;
        CallContext ctx;
        if (this.config != null && CommonHelper.isNotBlank((String)this.clientName)) {
            FrameworkAdapter.INSTANCE.applyDefaultSettingsIfUndefined(this.config);
            JEEFrameworkParameters parameters = new JEEFrameworkParameters(request, response);
            ctx = this.buildContext(this.config, (FrameworkParameters)parameters);
            adapter = this.config.getHttpActionAdapter();
            ArrayList<Client> currentClients = new ArrayList<Client>();
            Client client = (Client)this.config.getClients().findClient(this.clientName).orElseThrow(() -> new TechnicalException("Cannot find clientName: " + this.clientName));
            currentClients.add(client);
            try {
                if (this.startAuthentication(ctx, currentClients)) {
                    LOGGER.debug("Redirecting to identity provider for login");
                    this.saveRequestedUrl(ctx, currentClients, this.config.getClients().getAjaxRequestResolver());
                    action = this.redirectToIdentityProvider(ctx, currentClients);
                } else {
                    action = this.unauthorized(ctx, currentClients);
                }
            }
            catch (HttpAction e) {
                LOGGER.debug("extra HTTP action required in Pac4jEntryPoint: {}", (Object)e.getCode());
                action = e;
            }
        } else {
            throw new TechnicalException("The Pac4jEntryPoint has been defined without config, nor clientName: it must be defined in a <security:http> section with the pac4j SecurityFilter or CallbackFilter");
        }
        adapter.adapt(action, ctx.webContext());
    }

    @Generated
    public Config getConfig() {
        return this.config;
    }

    @Generated
    public String getClientName() {
        return this.clientName;
    }

    @Generated
    public void setConfig(Config config) {
        this.config = config;
    }

    @Generated
    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    @Generated
    public String toString() {
        return "Pac4jEntryPoint(config=" + this.config + ", clientName=" + this.clientName + ")";
    }
}

