/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.test.ldap;

import java.io.File;
import java.io.InputStream;
import org.junit.Assert;
import org.picketbox.ldap.EmbeddedApacheDS;

public class LDAPTestUtil {
    protected String adminPW = "secret";
    protected String dn = "dc=jboss,dc=org";
    protected String adminDN = "uid=admin,ou=system";
    protected String port = "10389";
    protected String serverHost = "localhost";
    protected EmbeddedApacheDS ds = null;

    public void setup() throws Exception {
        String tempDir = System.getProperty("java.io.tmpdir");
        File workDir = new File(tempDir + "/server-work");
        workDir.mkdirs();
        this.ds = new EmbeddedApacheDS(workDir);
        this.ds.disableShutdownhook();
        this.ds.createBaseDN("apache", "dc=apache,dc=org");
        this.createBaseDN();
        long current = System.currentTimeMillis();
        System.out.println("Starting Apache DS server");
        this.ds.startServer();
        System.out.println("Time taken = " + (System.currentTimeMillis() - current) + "milisec");
    }

    public void tearDown() throws Exception {
        if (this.ds != null) {
            this.ds.stopServer();
        }
        String tempDir = System.getProperty("java.io.tmpdir");
        System.out.println("java.io.tmpdir=" + tempDir);
        System.out.println("Going to delete the server-work directory");
        File workDir = new File(tempDir + "/server-work");
        if (workDir != null) {
            this.recursiveDeleteDir(workDir);
        }
    }

    public void createBaseDN(String partitionName, String dn) throws Exception {
        this.ds.createBaseDN(partitionName, dn);
    }

    protected String getAdminPW() {
        return "secret";
    }

    protected void createBaseDN() throws Exception {
        this.ds.createBaseDN("jboss", "dc=jboss,dc=org");
    }

    public void importLDIF(String fileName) throws Exception {
        long current = System.currentTimeMillis();
        System.out.println("Going to import LDIF:" + fileName);
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(fileName);
        Assert.assertNotNull((String)"LDIF file is not null?", (Object)is);
        this.ds.importLdif(is);
        System.out.println("Time taken = " + (System.currentTimeMillis() - current) + "milisec");
    }

    protected boolean recursiveDeleteDir(File dirPath) {
        if (dirPath.exists()) {
            File[] files = dirPath.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    this.recursiveDeleteDir(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        if (dirPath.exists()) {
            return dirPath.delete();
        }
        return true;
    }
}

