/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.reporters;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import scala.Console$;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.tools.nsc.Settings;
import scala.tools.nsc.io.AbstractFile;
import scala.tools.nsc.reporters.AbstractReporter;
import scala.tools.nsc.reporters.Reporter;
import scala.tools.nsc.util.FakePos;
import scala.tools.nsc.util.NoPosition$;
import scala.tools.nsc.util.Position;

public class ConsoleReporter
extends AbstractReporter
implements ScalaObject {
    private final int ERROR_LIMIT;
    private boolean shortname;
    private final PrintWriter writer;
    private final BufferedReader reader;
    private final Settings settings;

    public ConsoleReporter(Settings settings, BufferedReader reader, PrintWriter writer) {
        this.settings = settings;
        this.reader = reader;
        this.writer = writer;
        this.shortname = false;
    }

    public void flush() {
        this.writer.flush();
    }

    public void displayPrompt() {
        try {
            boolean bl = true;
            while (bl) {
                this.writer.print("r)esume, a)bort: ");
                this.writer.flush();
                String line = this.reader.readLine();
                if (line == null) continue;
                if ("abort".startsWith(line = line.toLowerCase())) {
                    throw new Error("user abort");
                }
                if (!"resume".startsWith(line)) continue;
                bl = false;
            }
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new Error("input read error");
        }
    }

    public void display(Position pos, String msg, Reporter.Severity severity) {
        severity.count_$eq(severity.count() + 1);
        Reporter.Severity severity2 = severity;
        Reporter.Severity severity3 = this.ERROR();
        if ((severity2 != null ? !((Object)((Object)severity2)).equals((Object)severity3) : severity3 != null) || severity.count() <= 100) {
            this.print(pos, msg, severity);
        }
    }

    public void printSummary() {
        if (this.WARNING().count() > 0) {
            this.printMessage(new StringBuilder().append((Object)this.getCountString(this.WARNING())).append((Object)" found").toString());
        }
        if (this.ERROR().count() > 0) {
            this.printMessage(new StringBuilder().append((Object)this.getCountString(this.ERROR())).append((Object)" found").toString());
        }
    }

    public void printColumnMarker(Position pos) {
        if (pos.isDefined()) {
            this.printMessage(new StringBuilder().append((Object)Predef$.MODULE$.augmentString(" ").$times(pos.column() - 1)).append((Object)"^").toString());
        }
    }

    public void printSourceLine(Position pos) {
        this.printMessage(Predef$.MODULE$.augmentString(pos.lineContent()).stripLineEnd());
        this.printColumnMarker(pos);
    }

    public void print(Position pos, String msg, Reporter.Severity severity) {
        this.printMessage(pos, new StringBuilder().append((Object)this.clabel(severity)).append((Object)msg).toString());
    }

    public void printMessage(Position posIn, String msg) {
        NoPosition$ temp2;
        block7: {
            block4: {
                Position pos;
                block5: {
                    block6: {
                        block2: {
                            block3: {
                                String temp4;
                                pos = posIn == null ? NoPosition$.MODULE$ : (posIn.isDefined() ? posIn.inUltimateSource(posIn.source()) : posIn);
                                temp2 = pos;
                                if (!(temp2 instanceof FakePos)) break block2;
                                FakePos temp3 = (FakePos)((Object)temp2);
                                String fmsg = temp4 = temp3.msg();
                                if (!true) break block3;
                                fmsg = temp4;
                                this.printMessage(new StringBuilder().append((Object)fmsg).append((Object)" ").append((Object)msg).toString());
                                break block4;
                            }
                            throw new MatchError(((Object)temp2).toString());
                        }
                        NoPosition$ noPosition$ = NoPosition$.MODULE$;
                        NoPosition$ noPosition$2 = temp2;
                        if (noPosition$ != null ? !noPosition$.equals(noPosition$2) : noPosition$2 != null) break block5;
                        if (!true) break block6;
                        this.printMessage(msg);
                        break block4;
                    }
                    throw new MatchError(((Object)temp2).toString());
                }
                if (!true) break block7;
                StringBuilder buf = new StringBuilder(msg);
                AbstractFile file = pos.source().file();
                this.printMessage(new StringBuilder().append((Object)(this.shortname() ? file.name() : file.path())).append((Object)":").append((Object)BoxesRunTime.boxToInteger((int)pos.line())).append((Object)": ").append((Object)msg).toString());
                this.printSourceLine(pos);
            }
            return;
        }
        throw new MatchError(((Object)temp2).toString());
    }

    public void printMessage(String msg) {
        this.writer.print(new StringBuilder().append((Object)msg).append((Object)"\n").toString());
        this.writer.flush();
    }

    private String getCountString(Reporter.Severity severity) {
        return this.countElementsAsString(severity.count(), this.label(severity));
    }

    public ConsoleReporter(Settings settings) {
        this(settings, Console$.MODULE$.in(), new PrintWriter(Console$.MODULE$.err(), true));
    }

    private String clabel(Reporter.Severity severity) {
        String label0 = this.label(severity);
        return label0 == null ? "" : new StringBuilder().append((Object)label0).append((Object)": ").toString();
    }

    private String label(Reporter.Severity severity) {
        Reporter.Severity temp1;
        block7: {
            block8: {
                String string;
                block4: {
                    block5: {
                        block6: {
                            block2: {
                                block3: {
                                    Reporter.Severity severity2 = temp1 = severity;
                                    Reporter.Severity severity3 = this.ERROR();
                                    if (severity2 != null ? !((Object)((Object)severity2)).equals((Object)severity3) : severity3 != null) break block2;
                                    if (!true) break block3;
                                    string = "error";
                                    break block4;
                                }
                                throw new MatchError(temp1.toString());
                            }
                            Reporter.Severity severity4 = temp1;
                            Reporter.Severity severity5 = this.WARNING();
                            if (severity4 != null ? !((Object)((Object)severity4)).equals((Object)severity5) : severity5 != null) break block5;
                            if (!true) break block6;
                            string = "warning";
                            break block4;
                        }
                        throw new MatchError(temp1.toString());
                    }
                    Reporter.Severity severity6 = temp1;
                    Reporter.Severity severity7 = this.INFO();
                    if (severity6 != null ? !((Object)((Object)severity6)).equals((Object)severity7) : severity7 != null) break block7;
                    if (!true) break block8;
                    string = null;
                }
                return string;
            }
            throw new MatchError(temp1.toString());
        }
        throw new MatchError(temp1.toString());
    }

    public final int ERROR_LIMIT() {
        return 100;
    }

    public void shortname_$eq(boolean bl) {
        this.shortname = bl;
    }

    public boolean shortname() {
        return this.shortname;
    }

    public Settings settings() {
        return this.settings;
    }
}

