/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import jline.History;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.LinearSeqLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.FutureTaskRunner;
import scala.concurrent.ops$;
import scala.math.Ordering;
import scala.math.Ordering$Int$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.tools.nsc.GenericRunnerSettings;
import scala.tools.nsc.Interpreter;
import scala.tools.nsc.InterpreterCommand;
import scala.tools.nsc.InterpreterControl;
import scala.tools.nsc.InterpreterLoop$;
import scala.tools.nsc.InterpreterLoop$CommandImplicits$;
import scala.tools.nsc.InterpreterResults;
import scala.tools.nsc.InterpreterResults$Error$;
import scala.tools.nsc.InterpreterResults$Incomplete$;
import scala.tools.nsc.InterpreterResults$Success$;
import scala.tools.nsc.InterpreterSettings;
import scala.tools.nsc.Properties$;
import scala.tools.nsc.Settings;
import scala.tools.nsc.interpreter.InteractiveReader;
import scala.tools.nsc.interpreter.InteractiveReader$;
import scala.tools.nsc.interpreter.JLineReader;
import scala.tools.nsc.interpreter.SimpleReader;
import scala.tools.nsc.io.Process;
import scala.tools.nsc.io.Process$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterpreterLoop
implements ScalaObject {
    public /* synthetic */ InterpreterLoop$CommandImplicits$ CommandImplicits$module;
    private final List<InterpreterControl.Command> powerCommands;
    private boolean powerUserOn;
    private final List<InterpreterControl.Command> standardCommands;
    private final String prompt;
    private List<String> replayCommandsRev;
    private List<String> addedClasspath;
    private Interpreter interpreter;
    private Settings settings;
    private final ClassLoader originalClassLoader;
    private InteractiveReader in;
    public final PrintWriter scala$tools$nsc$InterpreterLoop$$out;
    private final Option<BufferedReader> in0;

    public InterpreterLoop(Option<BufferedReader> in0, PrintWriter out) {
        this.in0 = in0;
        this.scala$tools$nsc$InterpreterLoop$$out = out;
        this.originalClassLoader = Thread.currentThread().getContextClassLoader();
        this.addedClasspath = Nil$.MODULE$;
        this.replayCommandsRev = Nil$.MODULE$;
        this.prompt = Properties$.MODULE$.shellPromptString();
        this.standardCommands = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InterpreterControl.Command[]{new InterpreterControl.NoArgs("help", "print this help message", (Function0<InterpreterControl.Result>)new $anonfun$3(this)), new InterpreterControl.VarArgs("history", "show the history (optional arg: lines to show)", (Function1<List<String>, InterpreterControl.Result>)new $anonfun$4(this)), new InterpreterControl.LineArg("h?", "search the history", (Function1<String, InterpreterControl.Result>)new $anonfun$5(this)), new InterpreterControl.OneArg("jar", "add a jar to the classpath", (Function1<String, InterpreterControl.Result>)new $anonfun$6(this)), new InterpreterControl.OneArg("load", "load and interpret a Scala file", (Function1<String, InterpreterControl.Result>)new $anonfun$7(this)), new InterpreterControl.NoArgs("power", "enable power user mode", (Function0<InterpreterControl.Result>)new $anonfun$8(this)), new InterpreterControl.NoArgs("quit", "exit the interpreter", (Function0<InterpreterControl.Result>)new $anonfun$9(this)), new InterpreterControl.NoArgs("replay", "reset execution and replay all previous commands", (Function0<InterpreterControl.Result>)new $anonfun$10(this)), new InterpreterControl.LineArg("sh", "fork a shell and run a command", (Function1<String, InterpreterControl.Result>)new $anonfun$11(this)), new InterpreterControl.NoArgs("silent", "disable/enable automatic printing of results", (Function0<InterpreterControl.Result>)new $anonfun$12(this))}));
        this.powerUserOn = false;
        this.powerCommands = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InterpreterControl.VarArgs[]{new InterpreterControl.VarArgs("dump", "displays a view of the interpreter's internal state", (Function1<List<String>, InterpreterControl.Result>)new $anonfun$13(this)), new InterpreterControl.VarArgs("tree", "displays ASTs for specified identifiers", (Function1<List<String>, InterpreterControl.Result>)new $anonfun$14(this))}));
    }

    private final String neededHelp$1(InterpreterCommand interpreterCommand) {
        return new StringBuilder().append((Object)(BoxesRunTime.unboxToBoolean((Object)interpreterCommand.settings().help().value()) ? new StringBuilder().append((Object)interpreterCommand.usageMsg()).append((Object)"\n").toString() : "")).append((Object)(BoxesRunTime.unboxToBoolean((Object)interpreterCommand.settings().Xhelp().value()) ? new StringBuilder().append((Object)interpreterCommand.xusageMsg()).append((Object)"\n").toString() : "")).toString();
    }

    public final void error1$1(String msg) {
        this.scala$tools$nsc$InterpreterLoop$$out.println(new StringBuilder().append((Object)"scala: ").append((Object)msg).toString());
    }

    private final String ambiguous$1(List cmds) {
        return new StringBuilder().append((Object)"Ambiguous: did you mean ").append((Object)((TraversableLike)cmds.map((Function1)new $anonfun$ambiguous$1$1(this), List$.MODULE$.canBuildFrom())).mkString(" or ")).append((Object)"?").toString();
    }

    private final InterpreterControl.Result withError$1(String msg) {
        this.scala$tools$nsc$InterpreterLoop$$out.println(msg);
        return new InterpreterControl.Result(true, (Option<String>)None$.MODULE$);
    }

    public final Object add$1(String name2, Iterator it) {
        return it.hasNext() ? this.interpreter().bind(name2, "scala.List[String]", it.toList()) : BoxedUnit.UNIT;
    }

    private final boolean processLine$1(String line) {
        boolean bl;
        if (line == null) {
            bl = false;
        } else {
            InterpreterControl.Result temp47 = this.command(line);
            if (temp47 != null) {
                Option<String> temp49 = temp47.lineToRecord();
                if (!temp47.keepRunning()) {
                    bl = false;
                } else if (temp49 instanceof Some) {
                    Some temp51 = (Some)temp49;
                    String temp52 = (String)temp51.x();
                    this.addReplay(temp52);
                    bl = true;
                } else {
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    public final String readOneLine$1() {
        this.scala$tools$nsc$InterpreterLoop$$out.flush();
        return this.in().readLine(this.prompt());
    }

    public void main(String[] args2) {
        String temp81;
        Object[] objectArray = args2;
        InterpreterCommand command$1 = new InterpreterCommand((List<String>)new ArrayOps.ofRef(objectArray).toList(), (Function1<String, Object>)new $anonfun$19(this));
        String string = temp81 = this.neededHelp$1(command$1);
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            if (command$1.ok()) {
                this.main(command$1.settings());
            }
        } else {
            this.scala$tools$nsc$InterpreterLoop$$out.print(temp81);
            this.scala$tools$nsc$InterpreterLoop$$out.flush();
        }
    }

    public String inject(List<Object> args2) {
        List strs = (List)((TraversableLike)args2.zipWithIndex(List$.MODULE$.canBuildFrom())).map((Function1)new $anonfun$18(this), List$.MODULE$.canBuildFrom());
        return strs.size() == 0 ? "Set no variables." : new StringBuilder().append((Object)"Variables set:\n").append((Object)strs.mkString("\n")).toString();
    }

    public Tuple2<String, String> injectOne(String name2, Object obj) {
        String className = obj.getClass().getName();
        this.interpreter().quietBind(name2, className, obj);
        return new Tuple2((Object)name2, (Object)className);
    }

    public void main(Settings settings) {
        Option<BufferedReader> temp71;
        block13: {
            InteractiveReader interactiveReader;
            block12: {
                boolean emacsShell;
                block11: {
                    this.settings_$eq(settings);
                    this.createInterpreter();
                    temp71 = this.in0;
                    if (!(temp71 instanceof Some)) break block11;
                    Some temp72 = (Some)temp71;
                    BufferedReader temp73 = (BufferedReader)temp72.x();
                    interactiveReader = new SimpleReader(temp73, this.scala$tools$nsc$InterpreterLoop$$out, true);
                    break block12;
                }
                None$ none$ = None$.MODULE$;
                if (none$ != null ? !none$.equals(temp71) : temp71 != null) break block13;
                String string = System.getProperty("env.emacs", "");
                String string2 = "";
                boolean bl = !(string != null ? !string.equals(string2) : string2 != null) ? false : (emacsShell = true);
                if (BoxesRunTime.unboxToBoolean((Object)settings.Xnojline().value()) || emacsShell) {
                    interactiveReader = new SimpleReader();
                } else if (BoxesRunTime.unboxToBoolean((Object)settings.noCompletion().value())) {
                    InteractiveReader$ interactiveReader$ = InteractiveReader$.MODULE$;
                    interactiveReader = interactiveReader$.createDefault(null, null);
                } else {
                    interactiveReader = InteractiveReader$.MODULE$.createDefault(this.interpreter(), this);
                }
            }
            this.in_$eq(interactiveReader);
            this.loadFiles(settings);
            if (this.interpreter().reporter().hasErrors()) {
                this.closeInterpreter();
                return;
            }
            this.printWelcome();
            this.repl();
            return;
        }
        throw new MatchError(temp71.toString());
        finally {
            this.closeInterpreter();
        }
    }

    public void loadFiles(Settings settings) {
        if (settings instanceof GenericRunnerSettings) {
            GenericRunnerSettings temp70 = (GenericRunnerSettings)settings;
            ((LinearSeqLike)temp70.loadfiles().value()).foreach((Function1)new $anonfun$loadFiles$1(this));
        }
    }

    public Option<String> interpretStartingWith(String code) {
        InterpreterResults.Result temp65;
        block9: {
            Object object;
            block6: {
                block8: {
                    block7: {
                        block5: {
                            if (!code.startsWith(".")) break block5;
                            object = this.interpretStartingWith(new StringBuilder().append((Object)this.interpreter().mostRecentVar()).append((Object)code).toString());
                            break block6;
                        }
                        temp65 = this.interpreter().interpret(code);
                        InterpreterResults$Error$ interpreterResults$Error$ = InterpreterResults$Error$.MODULE$;
                        if (interpreterResults$Error$ != null ? !interpreterResults$Error$.equals(temp65) : temp65 != null) break block7;
                        object = None$.MODULE$;
                        break block6;
                    }
                    InterpreterResults$Success$ interpreterResults$Success$ = InterpreterResults$Success$.MODULE$;
                    if (interpreterResults$Success$ != null ? !interpreterResults$Success$.equals(temp65) : temp65 != null) break block8;
                    object = new Some((Object)code);
                    break block6;
                }
                InterpreterResults$Incomplete$ interpreterResults$Incomplete$ = InterpreterResults$Incomplete$.MODULE$;
                if (interpreterResults$Incomplete$ != null ? !interpreterResults$Incomplete$.equals(temp65) : temp65 != null) break block9;
                if (this.in().interactive() && code.endsWith("\n\n")) {
                    this.scala$tools$nsc$InterpreterLoop$$out.println("You typed two blank lines.  Starting a new command.");
                    object = None$.MODULE$;
                } else {
                    String temp63 = this.in().readLine("     | ");
                    object = temp63 == null ? None$.MODULE$ : this.interpretStartingWith(new StringBuilder().append((Object)code).append((Object)"\n").append((Object)temp63).toString());
                }
            }
            return object;
        }
        throw new MatchError(temp65.toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    public InterpreterControl.Result command(String line) {
        List xs;
        InterpreterControl.Result result;
        if (!line.startsWith(":")) return new InterpreterControl.Result(true, this.interpretStartingWith(line));
        Object[] objectArray = line.substring(1).split("\\s+");
        List tokens = new ArrayOps.ofRef(objectArray).toList();
        if (tokens.isEmpty()) {
            return this.withError$1(this.ambiguous$1(this.commands()));
        }
        if (!(tokens instanceof .colon.colon)) throw new MatchError(tokens.toString());
        .colon.colon temp54 = (.colon.colon)tokens;
        String temp55 = (String)temp54.hd$1();
        List temp56 = temp54.tl$1();
        Tuple2 tuple2 = new Tuple2((Object)temp55, (Object)temp56);
        String cmd$1 = (String)tuple2._1();
        List args2 = (List)tuple2._2();
        List temp57 = (List)this.commands().filter((Function1)new $anonfun$command$1(this, cmd$1));
        if (temp57 instanceof .colon.colon) {
            .colon.colon temp58 = (.colon.colon)temp57;
            InterpreterControl.Command temp59 = (InterpreterControl.Command)temp58.hd$1();
            Nil$ nil$ = Nil$.MODULE$;
            List list2 = temp58.tl$1();
            if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                result = (InterpreterControl.Result)temp59.apply(args2);
                return result;
            }
            xs = temp58;
        } else {
            Nil$ nil$ = Nil$.MODULE$;
            if (!(nil$ != null ? !nil$.equals(temp57) : temp57 != null)) {
                result = this.withError$1("Unknown command.  Type :help for help.");
                return result;
            }
            xs = temp57;
        }
        result = this.withError$1(this.ambiguous$1(xs));
        return result;
    }

    public void verbosity() {
        boolean old = this.interpreter().printResults();
        this.interpreter().printResults_$eq(!old);
        this.scala$tools$nsc$InterpreterLoop$$out.println(new StringBuilder().append((Object)"Switched ").append((Object)(old ? "off" : "on")).append((Object)" result printing.").toString());
    }

    public void power() {
        this.powerUserOn_$eq(true);
        this.scala$tools$nsc$InterpreterLoop$$out.println(this.interpreter().powerUser());
        this.interpreter().quietBind("history", "scala.collection.immutable.List[String]", this.historyList().toList());
    }

    public void addJar(String arg) {
        File f2 = new File(arg);
        if (f2.exists()) {
            List<String> list2 = this.addedClasspath();
            this.addedClasspath_$eq((List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{f2.getCanonicalPath()})).$colon$colon$colon(list2));
            String string = new StringBuilder().append((Object)"Added ").append((Object)f2.getCanonicalPath()).append((Object)" to your classpath.").toString();
            Console$.MODULE$.println((Object)string);
            this.replay();
            return;
        }
        this.scala$tools$nsc$InterpreterLoop$$out.println(new StringBuilder().append((Object)"The file '").append((Object)f2).append((Object)"' doesn't seem to exist.").toString());
    }

    public InterpreterControl.Result load(String arg$1) {
        ObjectRef shouldReplay$1 = new ObjectRef((Object)None$.MODULE$);
        this.withFile(arg$1, (Function1<String, Object>)new $anonfun$load$1(this, arg$1, shouldReplay$1));
        return new InterpreterControl.Result(true, (Option<String>)((Option)shouldReplay$1.elem));
    }

    public void withFile(String filename, Function1<String, Object> action) {
        if (new File(filename).exists()) {
            action.apply((Object)filename);
        } else {
            this.scala$tools$nsc$InterpreterLoop$$out.println("That file does not exist");
        }
    }

    public void runShellCmd(String line) {
        this.interpreter().beQuietDuring(new $anonfun$runShellCmd$1(this));
        Process p = Process$.MODULE$.apply(line, (Map<String, String>)Process$.MODULE$.apply$default$2(), Process$.MODULE$.apply$default$3(), Process$.MODULE$.apply$default$4());
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"stdout", (Object)p.stdout()), new Tuple2((Object)"stderr", (Object)p.stderr())})).foreach(new $anonfun$runShellCmd$2(this).tupled());
    }

    public void replay() {
        this.closeInterpreter();
        this.createInterpreter();
        this.replayCommands().foreach((Function1)new $anonfun$replay$1(this));
    }

    /*
     * WARNING - void declaration
     */
    public void interpretAllFrom(String filename) {
        List<String> oldReplay;
        InteractiveReader oldIn;
        FileReader exceptionResult2;
        try {
            exceptionResult2 = new FileReader(filename);
            oldIn = this.in();
            oldReplay = this.replayCommandsRev();
        }
        catch (IOException iOException) {
            this.scala$tools$nsc$InterpreterLoop$$out.println(new StringBuilder().append((Object)"Error opening file: ").append((Object)filename).toString());
            return;
        }
        try {
            BufferedReader inFile = new BufferedReader(exceptionResult2);
            this.in_$eq(new SimpleReader(inFile, this.scala$tools$nsc$InterpreterLoop$$out, false));
            this.scala$tools$nsc$InterpreterLoop$$out.println(new StringBuilder().append((Object)"Loading ").append((Object)filename).append((Object)"...").toString());
            this.scala$tools$nsc$InterpreterLoop$$out.flush();
            this.repl();
            this.in_$eq(oldIn);
            this.replayCommandsRev_$eq(oldReplay);
        }
        catch (Throwable throwable) {
            void var5_2;
            this.in_$eq(oldIn);
            this.replayCommandsRev_$eq(oldReplay);
            var5_2.close();
            throw throwable;
        }
        exceptionResult2.close();
    }

    public void repl() {
        $anonfun$15 x$14$1 = new $anonfun$15(this);
        FutureTaskRunner x$15 = ops$.MODULE$.future$default$2((Function0)new $anonfun$16(this, (Function0)x$14$1));
        Function0 futLine = ops$.MODULE$.future((Function0)new $anonfun$17(this, (Function0)x$14$1), x$15);
        this.bindSettings();
        if (this.processLine$1((String)futLine.apply())) {
            do {
                this.scala$tools$nsc$InterpreterLoop$$out.flush();
            } while (this.processLine$1(this.in().readLine(this.prompt())));
            return;
        }
    }

    public List<InterpreterControl.Command> commands() {
        List<InterpreterControl.Command> list2 = this.standardCommands();
        return (this.powerUserOn() ? this.powerCommands() : Nil$.MODULE$).$colon$colon$colon(list2);
    }

    public List<InterpreterControl.Command> powerCommands() {
        return this.powerCommands;
    }

    public void powerUserOn_$eq(boolean bl) {
        this.powerUserOn = bl;
    }

    public boolean powerUserOn() {
        return this.powerUserOn;
    }

    public List<InterpreterControl.Command> standardCommands() {
        return this.standardCommands;
    }

    public final InterpreterLoop$CommandImplicits$ CommandImplicits() {
        if (this.CommandImplicits$module == null) {
            this.CommandImplicits$module = new InterpreterLoop$CommandImplicits$(this);
        }
        return this.CommandImplicits$module;
    }

    public String prompt() {
        return this.prompt;
    }

    public void searchHistory(String _cmdline) {
        String cmdline$1 = _cmdline.toLowerCase();
        if (this.history().isEmpty()) {
            String string = "No history available.";
            Console$.MODULE$.println((Object)string);
            return;
        }
        int current = ((History)this.history().get()).getCurrentIndex();
        int offset$2 = current - this.historyList().size() + 1;
        ((TraversableLike)this.historyList().zipWithIndex(Seq$.MODULE$.canBuildFrom())).withFilter((Function1)new $anonfun$searchHistory$1(this, cmdline$1)).foreach((Function1)new $anonfun$searchHistory$2(this, offset$2));
    }

    /*
     * WARNING - void declaration
     */
    public void printHistory(List<String> xs) {
        void var5_6;
        int exceptionResult1;
        int defaultLines = 20;
        if (this.history().isEmpty()) {
            String string = "No history available.";
            Console$.MODULE$.println((Object)string);
            return;
        }
        int current = ((History)this.history().get()).getCurrentIndex();
        try {
            String string = (String)xs.head();
            exceptionResult1 = new StringOps(string).toInt();
        }
        catch (Exception exception) {
            exceptionResult1 = defaultLines;
        }
        Seq lines = (Seq)this.historyList().takeRight((int)var5_6);
        int offset$1 = current - lines.size() + 1;
        ((IterableLike)lines.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1)new $anonfun$printHistory$1(this, offset$1));
    }

    public void printWelcome() {
        String welcomeMsg = Predef$.MODULE$.augmentString(Predef$.MODULE$.augmentString("|Welcome to Scala %s (%s, Java %s).\n        |Type in expressions to have them evaluated.\n        |Type :help for more information.").stripMargin()).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Properties$.MODULE$.versionString(), Properties$.MODULE$.javaVmName(), Properties$.MODULE$.javaVersion()}));
        this.scala$tools$nsc$InterpreterLoop$$out.println(welcomeMsg);
        this.scala$tools$nsc$InterpreterLoop$$out.flush();
    }

    public void printHelp() {
        this.scala$tools$nsc$InterpreterLoop$$out.println("All commands can be abbreviated - for example :he instead of :help.\n");
        List cmds = (List)this.commands().map((Function1)new $anonfun$1(this), List$.MODULE$.canBuildFrom());
        int width = BoxesRunTime.unboxToInt((Object)((TraversableLike)cmds.map((Function1)new $anonfun$2(this), List$.MODULE$.canBuildFrom())).max((Ordering)Ordering$Int$.MODULE$));
        String formatStr$1 = new StringBuilder().append((Object)"%-").append((Object)BoxesRunTime.boxToInteger((int)width)).append((Object)"s %s").toString();
        cmds.foreach((Function1)new $anonfun$printHelp$1(this, formatStr$1));
    }

    public void bindSettings() {
        this.interpreter().beQuietDuring(new $anonfun$bindSettings$1(this));
    }

    public void createInterpreter() {
        if (!this.addedClasspath().isEmpty()) {
            Settings.StringSetting stringSetting = this.settings().classpath();
            stringSetting.value_$eq(new StringBuilder().append((Object)((String)stringSetting.value())).append((Object)((TraversableLike)this.addedClasspath().map((Function1)new $anonfun$createInterpreter$1(this), List$.MODULE$.canBuildFrom())).mkString()).toString());
        }
        this.interpreter_$eq(new $anon$1(this));
        this.interpreter().setContextClassLoader();
    }

    public void closeInterpreter() {
        if (this.interpreter() != null) {
            this.interpreter().close();
            this.interpreter_$eq(null);
            Thread.currentThread().setContextClassLoader(this.originalClassLoader());
        }
    }

    public void addReplay(String cmd) {
        this.replayCommandsRev_$eq((List<String>)this.replayCommandsRev().$colon$colon((Object)cmd));
    }

    public List<String> replayCommands() {
        return this.replayCommandsRev().reverse();
    }

    public void replayCommandsRev_$eq(List<String> list2) {
        this.replayCommandsRev = list2;
    }

    public List<String> replayCommandsRev() {
        return this.replayCommandsRev;
    }

    public void addedClasspath_$eq(List<String> list2) {
        this.addedClasspath = list2;
    }

    public List<String> addedClasspath() {
        return this.addedClasspath;
    }

    public InterpreterSettings isettings() {
        return this.interpreter().isettings();
    }

    public void interpreter_$eq(Interpreter interpreter) {
        this.interpreter = interpreter;
    }

    public Interpreter interpreter() {
        return this.interpreter;
    }

    public void settings_$eq(Settings settings) {
        this.settings = settings;
    }

    public Settings settings() {
        return this.settings;
    }

    public ClassLoader originalClassLoader() {
        return this.originalClassLoader;
    }

    public Seq<String> historyList() {
        return (Seq)this.history().map((Function1)new $anonfun$historyList$1(this)).getOrElse((Function0)new $anonfun$historyList$2(this));
    }

    public Option<History> history() {
        None$ none$;
        InteractiveReader temp30 = this.in();
        if (temp30 instanceof JLineReader) {
            JLineReader temp31 = (JLineReader)temp30;
            none$ = new Some((Object)temp31.history());
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public void in_$eq(InteractiveReader interactiveReader) {
        this.in = interactiveReader;
    }

    public InteractiveReader in() {
        return this.in;
    }

    public InterpreterLoop() {
        this((Option<BufferedReader>)None$.MODULE$, new PrintWriter(Console$.MODULE$.out()));
    }

    public InterpreterLoop(BufferedReader in0, PrintWriter out) {
        this((Option<BufferedReader>)new Some((Object)in0), out);
    }
}

