/*
 * Decompiled with CFR 0.152.
 */
package scala.maven;

import java.io.File;
import java.util.List;
import scala.maven.JavaCommand;
import scala.maven.ScalaCompilerSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScalaContinuousCompileMojo
extends ScalaCompilerSupport {
    protected File mainOutputDir;
    protected File mainSourceDir;
    protected File testOutputDir;
    protected File testSourceDir;
    protected boolean useFsc = true;
    protected boolean verbose = false;

    @Override
    protected List<String> getClasspathElements() throws Exception {
        throw new UnsupportedOperationException("USELESS");
    }

    @Override
    protected File getOutputDir() throws Exception {
        throw new UnsupportedOperationException("USELESS");
    }

    @Override
    protected File getSourceDir() throws Exception {
        throw new UnsupportedOperationException("USELESS");
    }

    @Override
    protected JavaCommand getScalaCommand() throws Exception {
        JavaCommand jcmd = super.getScalaCommand();
        if (this.useFsc) {
            jcmd.addOption("verbose", this.verbose);
        }
        return jcmd;
    }

    @Override
    protected final void doExecute() throws Exception {
        this.mainOutputDir = this.normalize(this.mainOutputDir);
        if (!this.mainOutputDir.exists()) {
            this.mainOutputDir.mkdirs();
        }
        this.mainSourceDir = this.normalize(this.mainSourceDir);
        this.testOutputDir = this.normalize(this.testOutputDir);
        if (!this.testOutputDir.exists()) {
            this.testOutputDir.mkdirs();
        }
        this.testSourceDir = this.normalize(this.testSourceDir);
        if (this.useFsc) {
            this.getLog().info((CharSequence)"use fsc for compilation");
            this.scalaClassName = "scala.tools.nsc.CompileClient";
            StopServer stopServer = new StopServer();
            stopServer.run();
            this.startNewCompileServer();
            Runtime.getRuntime().addShutdownHook(stopServer);
        }
        this.getLog().info((CharSequence)"wait for files to compile...");
        while (true) {
            int nbFile = 0;
            if (this.mainSourceDir.exists()) {
                nbFile = this.compile(this.mainSourceDir, this.mainOutputDir, this.project.getCompileClasspathElements(), true);
            }
            if (this.testSourceDir.exists()) {
                nbFile += this.compile(this.testSourceDir, this.testOutputDir, this.project.getTestClasspathElements(), true);
            }
            if (nbFile > 0) {
                this.getLog().info((CharSequence)"wait for files to compile...");
                Thread.sleep(5000L);
                continue;
            }
            Thread.sleep(3000L);
        }
    }

    private void startNewCompileServer() throws Exception {
        JavaCommand jcmd = this.getEmptyScalaCommand("scala.tools.nsc.MainGenericRunner");
        jcmd.addArgs("scala.tools.nsc.CompileServer");
        jcmd.addJvmArgs(this.jvmArgs);
        jcmd.addArgs(this.args);
        jcmd.spawn(this.displayCmd);
    }

    private class StopServer
    extends Thread {
        private StopServer() {
        }

        public void run() {
            try {
                ScalaContinuousCompileMojo.this.getLog().info((CharSequence)"stop server...");
                JavaCommand jcmd = ScalaContinuousCompileMojo.this.getScalaCommand();
                jcmd.addArgs("-shutdown");
                jcmd.run(ScalaContinuousCompileMojo.this.displayCmd, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

