/*
 * Decompiled with CFR 0.152.
 */
package scala.maven;

import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Locale;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.plexus.util.StringUtils;
import scala.maven.JavaCommand;
import scala.maven.ScalaMojoSupport;

public class ScalaDocMojo
extends ScalaMojoSupport
implements MavenReport {
    protected String windowtitle;
    protected String bottom;
    protected String charset;
    protected String doctitle;
    protected String footer;
    protected String header;
    protected boolean linksource;
    protected boolean nocomment;
    protected File stylesheetfile;
    protected String top;
    protected File sourceDir;
    private String outputDirectory;
    private File reportOutputDirectory;
    private String name;
    private String description;
    protected String scaladocClassName;
    private String[] sourceFiles_ = null;

    private String[] findSourceFiles() {
        if (this.sourceFiles_ == null) {
            this.sourceFiles_ = JavaCommand.findFiles(this.sourceDir, "**/*.scala");
        }
        return this.sourceFiles_;
    }

    public boolean canGenerateReport() {
        try {
            this.sourceDir = this.sourceDir.getCanonicalFile();
        }
        catch (IOException exc) {
            this.sourceDir = this.sourceDir.getAbsoluteFile();
        }
        return this.sourceDir.exists() && this.findSourceFiles().length != 0;
    }

    public boolean isExternalReport() {
        return true;
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    public String getDescription(Locale locale) {
        if (StringUtils.isEmpty((String)this.description)) {
            return "ScalaDoc API documentation";
        }
        return this.description;
    }

    public String getName(Locale locale) {
        if (StringUtils.isEmpty((String)this.name)) {
            return "ScalaDocs";
        }
        return this.name;
    }

    public String getOutputName() {
        return this.outputDirectory + "/index";
    }

    public File getReportOutputDirectory() {
        if (this.reportOutputDirectory == null) {
            this.reportOutputDirectory = new File(this.project.getReporting().getOutputDirectory(), this.outputDirectory);
        }
        return this.reportOutputDirectory;
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.reportOutputDirectory = new File(reportOutputDirectory, this.outputDirectory);
    }

    public void doExecute() throws Exception {
        if (StringUtils.isNotEmpty((String)this.scaladocClassName)) {
            this.scalaClassName = this.scaladocClassName;
        }
        this.generate(null, Locale.getDefault());
    }

    public void generate(Sink sink, Locale locale) throws MavenReportException {
        try {
            if (!this.canGenerateReport()) {
                this.getLog().warn((CharSequence)("No source files found in " + this.sourceDir));
                return;
            }
            File reportOutputDir = this.getReportOutputDirectory();
            if (!reportOutputDir.exists()) {
                reportOutputDir.mkdirs();
            }
            JavaCommand jcmd = this.getScalaCommand();
            jcmd.addArgs("-Ydoc");
            jcmd.addOption("-classpath", JavaCommand.toMultiPath(this.project.getCompileClasspathElements()));
            jcmd.addOption("-d", reportOutputDir.getAbsolutePath());
            jcmd.addOption("-sourcepath", this.sourceDir.getAbsolutePath());
            jcmd.addOption("-bottom", this.getBottomText());
            jcmd.addOption("-charset", this.charset);
            jcmd.addOption("-doctitle", this.doctitle);
            jcmd.addOption("-footer", this.footer);
            jcmd.addOption("-header", this.header);
            jcmd.addOption("-linksource", this.linksource);
            jcmd.addOption("-nocomment", this.nocomment);
            jcmd.addOption("-stylesheetfile", this.stylesheetfile);
            jcmd.addOption("-top", this.top);
            jcmd.addOption("-windowtitle", this.windowtitle);
            for (String x : this.findSourceFiles()) {
                jcmd.addArgs(this.sourceDir + File.separator + x);
            }
            jcmd.run(this.displayCmd);
        }
        catch (MavenReportException exc) {
            throw exc;
        }
        catch (RuntimeException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new MavenReportException("wrap: " + exc.getMessage(), exc);
        }
    }

    private String getBottomText() {
        String inceptionYear = this.project.getInceptionYear();
        int actualYear = Calendar.getInstance().get(1);
        String year = String.valueOf(actualYear);
        String theBottom = StringUtils.replace((String)this.bottom, (String)"{currentYear}", (String)year);
        theBottom = inceptionYear != null ? (inceptionYear.equals(year) ? StringUtils.replace((String)theBottom, (String)"{inceptionYear}-", (String)"") : StringUtils.replace((String)theBottom, (String)"{inceptionYear}", (String)inceptionYear)) : StringUtils.replace((String)theBottom, (String)"{inceptionYear}-", (String)"");
        theBottom = this.project.getOrganization() == null ? StringUtils.replace((String)theBottom, (String)" {organizationName}", (String)"") : (this.project.getOrganization() != null && StringUtils.isNotEmpty((String)this.project.getOrganization().getName()) ? (StringUtils.isNotEmpty((String)this.project.getOrganization().getUrl()) ? StringUtils.replace((String)theBottom, (String)"{organizationName}", (String)("<a href=\"" + this.project.getOrganization().getUrl() + "\">" + this.project.getOrganization().getName() + "</a>")) : StringUtils.replace((String)theBottom, (String)"{organizationName}", (String)this.project.getOrganization().getName())) : StringUtils.replace((String)theBottom, (String)" {organizationName}", (String)""));
        return theBottom;
    }
}

