/*
 * Decompiled with CFR 0.152.
 */
package org.specs.runner;

import org.specs.Specification;
import org.specs.runner.Reporter;
import org.specs.runner.Reporter$;
import org.specs.runner.SpecsFilterPatternException;
import org.specs.util.Configuration;
import org.specs.util.Property$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ClassManifest$;
import scala.runtime.BoxedUnit;

public abstract class Reporter$class {
    public static Reporter setConfiguration(Reporter $this, Option className) {
        className.map((Function1)new Reporter$.anonfun.setConfiguration.1($this));
        $this.setOptionsFromConfig();
        return $this;
    }

    public static Reporter setNoStacktrace(Reporter $this) {
        $this.stacktrace().apply((Function0<Object>)new Reporter$.anonfun.setNoStacktrace.1($this));
        return $this;
    }

    public static Reporter setFailedAndErrorsOnly(Reporter $this) {
        $this.failedAndErrorsOnly().apply((Function0<Object>)new Reporter$.anonfun.setFailedAndErrorsOnly.1($this));
        return $this;
    }

    public static Reporter setNoStatistics(Reporter $this) {
        $this.statistics().apply((Function0<Object>)new Reporter$.anonfun.setNoStatistics.1($this));
        return $this;
    }

    public static Reporter setFinalStatisticsOnly(Reporter $this) {
        $this.finalStatisticsOnly().apply((Function0<Object>)new Reporter$.anonfun.setFinalStatisticsOnly.1($this));
        return $this;
    }

    public static Reporter setColorize(Reporter $this) {
        $this.colorize().apply((Function0<Object>)new Reporter$.anonfun.setColorize.1($this));
        return $this;
    }

    public static Reporter setPlanOnly(Reporter $this) {
        $this.planOnly().apply((Function0<Object>)new Reporter$.anonfun.setPlanOnly.1($this));
        return $this;
    }

    public static Reporter resetOptions(Reporter $this) {
        $this.args_$eq((String[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]), ClassManifest$.MODULE$.classType(String.class)));
        return $this.setOptionsFromConfig();
    }

    public static Reporter setOptionsFromConfig(Reporter $this) {
        $this.org$specs$runner$Reporter$$userConfiguration().apply((Function0<Configuration>)new Reporter$.anonfun.setOptionsFromConfig.6($this));
        $this.stacktrace().apply((Function0<Object>)new Reporter$.anonfun.setOptionsFromConfig.1($this));
        $this.failedAndErrorsOnly().apply((Function0<Object>)new Reporter$.anonfun.setOptionsFromConfig.2($this));
        $this.colorize().apply((Function0<Object>)new Reporter$.anonfun.setOptionsFromConfig.3($this));
        $this.statistics().apply((Function0<Object>)new Reporter$.anonfun.setOptionsFromConfig.4($this));
        $this.finalStatisticsOnly().apply((Function0<Object>)new Reporter$.anonfun.setOptionsFromConfig.5($this));
        return $this;
    }

    public static Configuration runConfiguration(Reporter $this) {
        Reporter outer$1 = $this;
        return new Reporter$.anon.1($this, outer$1);
    }

    public static String[] args(Reporter $this) {
        return $this.org$specs$runner$Reporter$$specArgs();
    }

    public static Object args_$eq(Reporter $this, String[] a2) {
        $this.org$specs$runner$Reporter$$specArgs_$eq(a2);
        return Reporter$class.overrideConfigurationWithUserArgs($this);
    }

    public static void main(Reporter $this, String[] arguments) {
        Object object = arguments != null ? $this.args_$eq((String[])Predef$.MODULE$.refArrayOps((Object[])$this.args()).$plus$plus((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])arguments), Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(String.class)))) : BoxedUnit.UNIT;
        if (Reporter$class.argsContain($this, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-h", "--help"}))) {
            $this.displayHelp();
        } else {
            $this.reportSpecs();
            if ($this.filteredSpecs().exists((Function1)new Reporter$.anonfun.main.1($this))) {
                $this.exit(1);
            } else {
                $this.exit(0);
            }
        }
    }

    public static void exit(Reporter $this, int code) {
        System.exit(code);
    }

    public static void displayHelp(Reporter $this) {
        $this.displayUsage();
        $this.displayOptions();
        $this.displayOptionsDescription();
    }

    public static void displayUsage(Reporter $this) {
        $this.println("usage java <classpath> package.mySpecification");
    }

    public static void displayOptions(Reporter $this) {
        $this.println(Predef$.MODULE$.augmentString("\r\n    [-h|--help]\r\n    [-config|--configuration]\r\n    [-ns|--nostacktrace]\r\n    [-nostats|--nostatistics]\r\n    [-finalstats|--finalstatistics]\r\n    [-xonly | -failedonly]\r\n    [[-acc | --accept] tag1,tag2,...] [[-rej | --reject] tag1,tag2,...]\r\n    [-sus | --system]\r\n    [-ex | --example]\r\n    [-plan | --planOnly]\r\n    [-c | --color]").stripMargin());
    }

    public static void displayOptionsDescription(Reporter $this) {
        $this.println(Predef$.MODULE$.augmentString("\r\n-h, --help                      print this message and doesn't execute the specification\r\n-config, --configuration        class name of an object extending the org.specs.util.Configuration trait\r\n-ns, --nostacktrace             remove the stacktraces from the reporting\r\n-nostats, --nostatistics        remove the statistics from the reporting\r\n-finalstats, --finalstatistics  print the final statistics only\r\n-xonly, --failedonly            report only failures and errors\r\n-acc, --accept tags             accept only the specified tags (comma-separated names)\r\n-rej, --reject tags             reject the specified tags (comma-separated names)\r\n-sus, --system                  only the systems under specifications matching this regular expression will be executed\r\n-ex, --example                  only the examples matching this regular expression will be executed\r\n-plan, --planOnly               only display the sus and first level descriptions without executing the examples\r\n-c, --color                     report with color").stripMargin());
    }

    public static String susFilterPattern(Reporter $this) {
        return (String)$this.argValue($this.args(), (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-sus", "--system"}))).getOrElse((Function0)new Reporter$.anonfun.susFilterPattern.1($this));
    }

    public static String exampleFilterPattern(Reporter $this) {
        return (String)$this.argValue($this.args(), (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-ex", "--example"}))).getOrElse((Function0)new Reporter$.anonfun.exampleFilterPattern.1($this));
    }

    /*
     * WARNING - void declaration
     */
    public static Reporter reportSpecs(Reporter $this) {
        void var1_1;
        Reporter exceptionResult1 = null;
        try {
            exceptionResult1 = $this.report((Seq<Specification>)$this.filteredSpecs());
        }
        catch (SpecsFilterPatternException specsFilterPatternException) {
            $this.println(specsFilterPatternException.getMessage());
            exceptionResult1 = $this;
        }
        return var1_1;
    }

    public static Reporter report(Reporter $this, Seq specs$1) {
        Reporter$class.overrideConfigurationWithUserArgs($this);
        $this.setTags((Seq<Specification>)specs$1);
        $this.debug((Function0<String>)new Reporter$.anonfun.report.1($this, specs$1));
        return $this;
    }

    private static Object overrideConfigurationWithUserArgs(Reporter $this) {
        Object object = Reporter$class.argsContain($this, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-config", "--configuration"})) ? $this.setConfiguration($this.argValue($this.args(), (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-config", "--configuration"})))) : BoxedUnit.UNIT;
        Object object2 = Reporter$class.argsContain($this, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-ns", "--nostacktrace"})) ? $this.setNoStacktrace() : BoxedUnit.UNIT;
        Object object3 = Reporter$class.argsContain($this, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-nostats", "--nostatistics"})) ? $this.setNoStatistics() : BoxedUnit.UNIT;
        Object object4 = Reporter$class.argsContain($this, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-finalstats", "-finalstatistics"})) ? $this.setFinalStatisticsOnly() : BoxedUnit.UNIT;
        Object object5 = Reporter$class.argsContain($this, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-xonly", "--failedonly"})) ? $this.setFailedAndErrorsOnly() : BoxedUnit.UNIT;
        Object object6 = Reporter$class.argsContain($this, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-plan"})) ? $this.setPlanOnly() : BoxedUnit.UNIT;
        return Reporter$class.argsContain($this, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-c", "--color"})) ? $this.setColorize() : BoxedUnit.UNIT;
    }

    private static boolean argsContain(Reporter $this, Seq options$1) {
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])$this.args()).map((Function1)new Reporter$.anonfun.argsContain.1($this), Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(String.class)))).exists((Function1)new Reporter$.anonfun.argsContain.2($this, options$1));
    }

    public static void setTags(Reporter $this, Seq specifications) {
        Reporter$class.org$specs$runner$Reporter$class$$setAcceptedTags$1($this, specifications, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-acc", "--accept"})), (Function2)new Reporter$.anonfun.setTags.1($this));
        Reporter$class.org$specs$runner$Reporter$class$$setAcceptedTags$1($this, specifications, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-rej", "--reject"})), (Function2)new Reporter$.anonfun.setTags.2($this));
    }

    public static Option argValue(Reporter $this, String[] arguments$1, List argumentNames$1) {
        None$ none$;
        int n2 = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])arguments$1).map((Function1)new Reporter$.anonfun.argValue.1($this), Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(String.class)))).indexWhere((Function1)new Reporter$.anonfun.argValue.2($this, argumentNames$1));
        if (n2 == -1) {
            none$ = None$.MODULE$;
        } else {
            int i2 = n2;
            if (Reporter$class.gd2$1($this, i2, arguments$1)) {
                none$ = new Some((Object)arguments$1[n2 + 1]);
            } else {
                if (!Predef$.MODULE$.refArrayOps((Object[])arguments$1).isEmpty()) {
                    $this.warning((Function0<String>)new Reporter$.anonfun.argValue.3($this, arguments$1, argumentNames$1));
                }
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    public static List $colon$colon(Reporter $this, Reporter r2) {
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Reporter[]{r2, $this}));
    }

    private static final void printWarning$1(Reporter $this) {
        $this.warning((Function0<String>)new Reporter$.anonfun.printWarning.1.1($this));
    }

    public static final Specification acceptSpecTags$1(Reporter $this, Specification s2, int i2) {
        return (Specification)s2.acceptTag((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])$this.org$specs$runner$Reporter$$specArgs()[i2 + 1].split(",")));
    }

    public static final Specification rejectSpecTags$1(Reporter $this, Specification s2, int i2) {
        return (Specification)s2.rejectTag((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])$this.org$specs$runner$Reporter$$specArgs()[i2 + 1].split(",")));
    }

    private static final boolean gd1$1(Reporter $this, int n2) {
        return n2 < $this.org$specs$runner$Reporter$$specArgs().length - 1;
    }

    public static final void org$specs$runner$Reporter$class$$setAcceptedTags$1(Reporter $this, Seq specifications, List argumentNames$2, Function2 f$1) {
        int n2 = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])$this.org$specs$runner$Reporter$$specArgs()).map((Function1)new Reporter$.anonfun.setAcceptedTags.1.1($this), Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(String.class)))).indexWhere((Function1)new Reporter$.anonfun.setAcceptedTags.1.2($this, argumentNames$2));
        if (n2 != -1) {
            int i$1 = n2;
            if (Reporter$class.gd1$1($this, i$1)) {
                i$1 = n2;
                $this.filteredSpecs().foreach((Function1)new Reporter$.anonfun.setAcceptedTags.1.3($this, f$1, i$1));
            } else if (!Predef$.MODULE$.refArrayOps((Object[])$this.org$specs$runner$Reporter$$specArgs()).isEmpty()) {
                Reporter$class.printWarning$1($this);
            }
        }
    }

    private static final boolean gd2$1(Reporter $this, int n2, String[] stringArray) {
        return n2 < stringArray.length - 1;
    }

    public static void $init$(Reporter $this) {
        $this.org$specs$runner$Reporter$_setter_$org$specs$runner$Reporter$$userConfiguration_$eq(Property$.MODULE$.apply(new Reporter$.anonfun.7($this)));
        $this.org$specs$runner$Reporter$_setter_$stacktrace_$eq(Property$.MODULE$.apply(new Reporter$.anonfun.1($this)));
        $this.org$specs$runner$Reporter$_setter_$failedAndErrorsOnly_$eq(Property$.MODULE$.apply(new Reporter$.anonfun.2($this)));
        $this.org$specs$runner$Reporter$_setter_$statistics_$eq(Property$.MODULE$.apply(new Reporter$.anonfun.3($this)));
        $this.org$specs$runner$Reporter$_setter_$finalStatisticsOnly_$eq(Property$.MODULE$.apply(new Reporter$.anonfun.4($this)));
        $this.org$specs$runner$Reporter$_setter_$colorize_$eq(Property$.MODULE$.apply(new Reporter$.anonfun.5($this)));
        $this.org$specs$runner$Reporter$_setter_$planOnly_$eq(Property$.MODULE$.apply(new Reporter$.anonfun.6($this)));
        $this.org$specs$runner$Reporter$$specArgs_$eq((String[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]), ClassManifest$.MODULE$.classType(String.class)));
    }
}

