/*
 * Decompiled with CFR 0.152.
 */
package org.specs.matcher;

import org.specs.matcher.Matcher;
import org.specs.matcher.MatcherUtils$;
import org.specs.matcher.PathBaseMatchers;
import scala.Function0;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public abstract class PathBaseMatchers$class {
    public static Matcher beAnExistingPath(PathBaseMatchers $this) {
        return new Matcher<String>($this){
            private final PathBaseMatchers $outer;

            public Tuple3<Object, String, String> apply(Function0<String> v2) {
                String path = (String)v2.apply();
                return new Tuple3((Object)BoxesRunTime.boxToBoolean((path != null && this.$outer.exists(path) ? 1 : 0) != 0), (Object)new StringBuilder().append((Object)this.d(path)).append((Object)" exists").toString(), (Object)new StringBuilder().append((Object)this.d(path)).append((Object)" doesn't exist").toString());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
    }

    public static Matcher existPath(PathBaseMatchers $this) {
        return $this.beAnExistingPath();
    }

    public static Matcher beAReadablePath(PathBaseMatchers $this) {
        return new Matcher<String>($this){
            private final PathBaseMatchers $outer;

            public Tuple3<Object, String, String> apply(Function0<String> v2) {
                String path = (String)v2.apply();
                return new Tuple3((Object)BoxesRunTime.boxToBoolean((path != null && this.$outer.canRead(path) ? 1 : 0) != 0), (Object)new StringBuilder().append((Object)this.d(path)).append((Object)" is readable").toString(), (Object)new StringBuilder().append((Object)this.d(path)).append((Object)" can't be read").toString());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
    }

    public static Matcher beAWritablePath(PathBaseMatchers $this) {
        return new Matcher<String>($this){
            private final PathBaseMatchers $outer;

            public Tuple3<Object, String, String> apply(Function0<String> v2) {
                String path = (String)v2.apply();
                return new Tuple3((Object)BoxesRunTime.boxToBoolean((path != null && this.$outer.canWrite(path) ? 1 : 0) != 0), (Object)new StringBuilder().append((Object)this.d(path)).append((Object)" is writable").toString(), (Object)new StringBuilder().append((Object)this.d(path)).append((Object)" can't be written").toString());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
    }

    public static Matcher beAnAbsolutePath(PathBaseMatchers $this) {
        return new Matcher<String>($this){
            private final PathBaseMatchers $outer;

            public Tuple3<Object, String, String> apply(Function0<String> v2) {
                String path = (String)v2.apply();
                return new Tuple3((Object)BoxesRunTime.boxToBoolean((path != null && this.$outer.isAbsolute(path) ? 1 : 0) != 0), (Object)new StringBuilder().append((Object)this.d(path)).append((Object)" is absolute").toString(), (Object)new StringBuilder().append((Object)this.d(path)).append((Object)" is not absolute").toString());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
    }

    public static Matcher beAHiddenPath(PathBaseMatchers $this) {
        return new Matcher<String>($this){
            private final PathBaseMatchers $outer;

            public Tuple3<Object, String, String> apply(Function0<String> v2) {
                String path = (String)v2.apply();
                return new Tuple3((Object)BoxesRunTime.boxToBoolean((path != null && this.$outer.isHidden(path) ? 1 : 0) != 0), (Object)new StringBuilder().append((Object)this.d(path)).append((Object)" is hidden").toString(), (Object)new StringBuilder().append((Object)this.d(path)).append((Object)" is not hidden").toString());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
    }

    public static Matcher beAFilePath(PathBaseMatchers $this) {
        return new Matcher<String>($this){
            private final PathBaseMatchers $outer;

            public Tuple3<Object, String, String> apply(Function0<String> v2) {
                String path = (String)v2.apply();
                return new Tuple3((Object)BoxesRunTime.boxToBoolean((path != null && this.$outer.isFile(path) ? 1 : 0) != 0), (Object)new StringBuilder().append((Object)this.d(path)).append((Object)" is a file").toString(), (Object)new StringBuilder().append((Object)this.d(path)).append((Object)" is not a file").toString());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
    }

    public static Matcher beADirectoryPath(PathBaseMatchers $this) {
        return new Matcher<String>($this){
            private final PathBaseMatchers $outer;

            public Tuple3<Object, String, String> apply(Function0<String> v2) {
                String path = (String)v2.apply();
                return new Tuple3((Object)BoxesRunTime.boxToBoolean((path != null && this.$outer.isDirectory(path) ? 1 : 0) != 0), (Object)new StringBuilder().append((Object)this.d(path)).append((Object)" is a directory").toString(), (Object)new StringBuilder().append((Object)this.d(path)).append((Object)" is not a directory").toString());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
    }

    public static Matcher havePathName(PathBaseMatchers $this, String name$1) {
        return new Matcher<String>($this, name$1){
            private final PathBaseMatchers $outer;
            private final String name$1;

            public Tuple3<Object, String, String> apply(Function0<String> v2) {
                String path = (String)v2.apply();
                return new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)this.$outer.isEqualIgnoringSep(this.$outer.getName(path), this.name$1)), (Object)new StringBuilder().append((Object)this.d(path)).append((Object)" is named ").append((Object)MatcherUtils$.MODULE$.q(this.name$1)).toString(), (Object)new StringBuilder().append((Object)this.d(path)).append((Object)" is not named ").append((Object)MatcherUtils$.MODULE$.q(this.name$1)).toString());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.name$1 = string;
            }
        };
    }

    public static Matcher haveAsAbsolutePath(PathBaseMatchers $this, String absolutePath$1) {
        return new Matcher<String>($this, absolutePath$1){
            private final PathBaseMatchers $outer;
            private final String absolutePath$1;

            public Tuple3<Object, String, String> apply(Function0<String> v2) {
                String path = (String)v2.apply();
                return new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)this.$outer.isEqualIgnoringSep(path, this.absolutePath$1)), (Object)new StringBuilder().append((Object)this.d(path)).append((Object)" has absolute path ").append((Object)MatcherUtils$.MODULE$.q(this.absolutePath$1)).toString(), (Object)new StringBuilder().append((Object)this.d(path)).append((Object)" doesn't have absolute path ").append((Object)MatcherUtils$.MODULE$.q(this.absolutePath$1)).append((Object)" but ").append((Object)MatcherUtils$.MODULE$.q(this.$outer.getAbsolutePath(path))).toString());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.absolutePath$1 = string;
            }
        };
    }

    public static Matcher haveAsCanonicalPath(PathBaseMatchers $this, String canonicalPath$1) {
        return new Matcher<String>($this, canonicalPath$1){
            private final PathBaseMatchers $outer;
            private final String canonicalPath$1;

            public Tuple3<Object, String, String> apply(Function0<String> v2) {
                String path = (String)v2.apply();
                return new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)this.$outer.isEqualIgnoringSep(this.$outer.getCanonicalPath(path), this.canonicalPath$1)), (Object)new StringBuilder().append((Object)this.d(path)).append((Object)" has canonical path ").append((Object)MatcherUtils$.MODULE$.q(this.canonicalPath$1)).toString(), (Object)new StringBuilder().append((Object)this.d(path)).append((Object)" doesn't have canonical path ").append((Object)MatcherUtils$.MODULE$.q(this.canonicalPath$1)).append((Object)" but ").append((Object)MatcherUtils$.MODULE$.q(this.$outer.getCanonicalPath(path))).toString());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.canonicalPath$1 = string;
            }
        };
    }

    public static Matcher haveParentPath(PathBaseMatchers $this, String parent$1) {
        return new Matcher<String>($this, parent$1){
            private final PathBaseMatchers $outer;
            private final String parent$1;

            public Tuple3<Object, String, String> apply(Function0<String> v2) {
                String path = (String)v2.apply();
                return new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)this.$outer.isEqualIgnoringSep(this.$outer.getParent(path), this.parent$1)), (Object)new StringBuilder().append((Object)this.d(path)).append((Object)" has parent path ").append((Object)MatcherUtils$.MODULE$.q(this.parent$1)).toString(), (Object)new StringBuilder().append((Object)this.d(path)).append((Object)" doesn't have parent path ").append((Object)MatcherUtils$.MODULE$.q(this.parent$1)).append((Object)" but ").append((Object)MatcherUtils$.MODULE$.q(this.$outer.getParent(path))).toString());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.parent$1 = string;
            }
        };
    }

    public static Matcher listPaths(PathBaseMatchers $this, Seq list$1) {
        return new Matcher<String>($this, list$1){
            private final PathBaseMatchers $outer;
            private final Seq list$1;

            /*
             * Enabled aggressive block sorting
             */
            public Tuple3<Object, String, String> apply(Function0<String> v2) {
                boolean bl;
                String path = (String)v2.apply();
                if (path != null && this.list$1 != null) {
                    List list = this.$outer.listFiles(path).toList();
                    List list2 = this.list$1.toList();
                    if (!(list != null ? !list.equals(list2) : list2 != null)) {
                        bl = true;
                        return new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)bl), (Object)new StringBuilder().append((Object)this.d(path)).append((Object)" has files ").append((Object)MatcherUtils$.MODULE$.q(this.list$1.mkString(", "))).toString(), (Object)new StringBuilder().append((Object)this.d(path)).append((Object)" doesn't have files ").append((Object)MatcherUtils$.MODULE$.q(this.list$1.toList().mkString(", "))).append((Object)" but ").append((Object)MatcherUtils$.MODULE$.q(this.$outer.listFiles(path).toList().mkString(", "))).toString());
                    }
                }
                bl = false;
                return new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)bl), (Object)new StringBuilder().append((Object)this.d(path)).append((Object)" has files ").append((Object)MatcherUtils$.MODULE$.q(this.list$1.mkString(", "))).toString(), (Object)new StringBuilder().append((Object)this.d(path)).append((Object)" doesn't have files ").append((Object)MatcherUtils$.MODULE$.q(this.list$1.toList().mkString(", "))).append((Object)" but ").append((Object)MatcherUtils$.MODULE$.q(this.$outer.listFiles(path).toList().mkString(", "))).toString());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.list$1 = seq;
            }
        };
    }

    public static Matcher beEqualIgnoringSep(PathBaseMatchers $this, String other) {
        return $this.beEqualToIgnoringSep(other);
    }

    public static Matcher beEqualToIgnoringSep(PathBaseMatchers $this, String other$1) {
        return new Matcher<String>($this, other$1){
            private final PathBaseMatchers $outer;
            private final String other$1;

            public Tuple3<Object, String, String> apply(Function0<String> v2) {
                String path = (String)v2.apply();
                return new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)this.$outer.isEqualIgnoringSep(path, this.other$1)), (Object)new StringBuilder().append((Object)this.d(path)).append((Object)" is equal ignoring separators to ").append((Object)MatcherUtils$.MODULE$.q(this.other$1)).toString(), (Object)new StringBuilder().append((Object)this.d(path)).append((Object)" is not equal ignoring separators to ").append((Object)MatcherUtils$.MODULE$.q(this.other$1)).toString());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.other$1 = string;
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isEqualIgnoringSep(PathBaseMatchers $this, String path, String other) {
        if (path == null) return false;
        if (other == null) return false;
        String string = $this.getCanonicalPath(path).replaceAll("\\\\", "/");
        String string2 = $this.getCanonicalPath(other).replaceAll("\\\\", "/");
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    public static void $init$(PathBaseMatchers $this) {
    }
}

