/*
 * Decompiled with CFR 0.152.
 */
package org.specs.runner;

import org.specs.Specification;
import org.specs.execute.FailureException;
import org.specs.execute.HasResults;
import org.specs.execute.SkippedException;
import org.specs.runner.AnsiColors$;
import org.specs.runner.OutputReporter;
import org.specs.runner.OutputReporter$;
import org.specs.specification.Example;
import org.specs.specification.Examples;
import org.specs.specification.Sus;
import org.specs.util.ExtendedThrowable$;
import org.specs.util.Plural$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Serializable;
import scala.Tuple5;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public abstract class OutputReporter$class {
    public static String failureColored(OutputReporter $this, String text) {
        return BoxesRunTime.unboxToBoolean((Object)$this.colorize().apply()) ? new StringBuilder().append((Object)AnsiColors$.MODULE$.red()).append((Object)text).append((Object)AnsiColors$.MODULE$.reset()).toString() : text;
    }

    public static String successColored(OutputReporter $this, String text) {
        return BoxesRunTime.unboxToBoolean((Object)$this.colorize().apply()) ? new StringBuilder().append((Object)AnsiColors$.MODULE$.green()).append((Object)text).append((Object)AnsiColors$.MODULE$.reset()).toString() : text;
    }

    public static String skipColored(OutputReporter $this, String text) {
        return BoxesRunTime.unboxToBoolean((Object)$this.colorize().apply()) ? new StringBuilder().append((Object)AnsiColors$.MODULE$.yellow()).append((Object)text).append((Object)AnsiColors$.MODULE$.reset()).toString() : text;
    }

    public static String infoColored(OutputReporter $this, String text) {
        return BoxesRunTime.unboxToBoolean((Object)$this.colorize().apply()) ? new StringBuilder().append((Object)AnsiColors$.MODULE$.blue()).append((Object)text).append((Object)AnsiColors$.MODULE$.reset()).toString() : text;
    }

    public static OutputReporter report(OutputReporter $this, Seq specs) {
        $this.org$specs$runner$OutputReporter$$super$report((Seq<Specification>)specs);
        return $this.report((Seq<Specification>)specs, "");
    }

    public static OutputReporter report(OutputReporter $this, Seq specs, String padding$1) {
        specs.foreach((Function1)new Serializable($this, padding$1){
            public static final long serialVersionUID;
            private final OutputReporter $outer;
            private final String padding$1;

            static {
                long l2 = serialVersionUID = 0L;
            }

            public final OutputReporter apply(Specification specification) {
                return this.$outer.reportSpec(specification, this.padding$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.padding$1 = string;
            }
        });
        return $this;
    }

    public static OutputReporter reportSpec(OutputReporter $this, Specification spec, String padding) {
        $this.timer().start();
        $this.println(new StringBuilder().append((Object)padding).append((Object)"Specification \"").append((Object)spec.name()).append((Object)"\"").toString());
        $this.report((Seq<Specification>)spec.subSpecifications(), new StringBuilder().append((Object)padding).append((Object)"  ").toString());
        $this.reportSystems((Iterable<Sus>)spec.systems(), new StringBuilder().append((Object)padding).append((Object)"  ").toString());
        spec.executeAfterSpec();
        $this.timer().stop();
        boolean isFirstSpecification = padding.isEmpty();
        if (BoxesRunTime.unboxToBoolean((Object)$this.statistics().apply()) && (!BoxesRunTime.unboxToBoolean((Object)$this.finalStatisticsOnly().apply()) || BoxesRunTime.unboxToBoolean((Object)$this.finalStatisticsOnly().apply()) && isFirstSpecification)) {
            $this.println(new StringBuilder().append((Object)padding).append((Object)"Total for specification \"").append((Object)spec.name()).append((Object)"\":").toString());
            $this.printStats($this.stats(spec), padding);
        }
        return $this;
    }

    public static OutputReporter.AddableTuple toAddableTuple(OutputReporter $this, Tuple5 t1) {
        return new OutputReporter.AddableTuple($this, (Tuple5<Object, Object, Object, Object, Object>)t1);
    }

    public static Tuple5 stats(OutputReporter $this, Specification spec) {
        return $this.toAddableTuple((Tuple5<Object, Object, Object, Object, Object>)((Tuple5)spec.systems().foldLeft((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0)), (Function2)new Serializable($this){
            public static final long serialVersionUID;
            private final OutputReporter $outer;

            static {
                long l2 = serialVersionUID = 0L;
            }

            public final Tuple5<Object, Object, Object, Object, Object> apply(Tuple5<Object, Object, Object, Object, Object> tuple5, Sus sus) {
                return this.$outer.toAddableTuple(tuple5).$plus(this.$outer.stats(sus));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }))).$plus((Tuple5<Object, Object, Object, Object, Object>)((Tuple5)spec.subSpecifications().foldLeft((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0)), (Function2)new Serializable($this){
            public static final long serialVersionUID;
            private final OutputReporter $outer;

            static {
                long l2 = serialVersionUID = 0L;
            }

            public final Tuple5<Object, Object, Object, Object, Object> apply(Tuple5<Object, Object, Object, Object, Object> tuple5, Specification specification) {
                return this.$outer.toAddableTuple(tuple5).$plus(this.$outer.stats(specification));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        })));
    }

    public static Tuple5 stats(OutputReporter $this, Sus sus) {
        return (Tuple5)sus.examples().foldLeft((Object)OutputReporter$class.ownStats($this, sus), (Function2)new Serializable($this){
            public static final long serialVersionUID;
            private final OutputReporter $outer;

            static {
                long l2 = serialVersionUID = 0L;
            }

            public final Tuple5<Object, Object, Object, Object, Object> apply(Tuple5<Object, Object, Object, Object, Object> tuple5, Example example) {
                return this.$outer.toAddableTuple(tuple5).$plus(this.$outer.stats(example));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static Tuple5 stats(OutputReporter $this, Example example) {
        return BoxesRunTime.unboxToBoolean((Object)$this.planOnly().apply()) ? new Tuple5((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0)) : (Tuple5)example.examples().foldLeft((Object)OutputReporter$class.ownStats($this, example), (Function2)new Serializable($this){
            public static final long serialVersionUID;
            private final OutputReporter $outer;

            static {
                long l2 = serialVersionUID = 0L;
            }

            public final Tuple5<Object, Object, Object, Object, Object> apply(Tuple5<Object, Object, Object, Object, Object> tuple5, Example example) {
                return this.$outer.toAddableTuple(tuple5).$plus(this.$outer.stats(example));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    private static Tuple5 ownStats(OutputReporter $this, Examples example) {
        return new Tuple5((Object)(example.examples().isEmpty() ? BoxesRunTime.boxToInteger((int)1) : BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)example.ownExpectationsNb()), (Object)BoxesRunTime.boxToInteger((int)example.ownFailures().size()), (Object)BoxesRunTime.boxToInteger((int)example.ownErrors().size()), (Object)BoxesRunTime.boxToInteger((int)example.ownSkipped().size()));
    }

    public static void reportSystems(OutputReporter $this, Iterable systems$1, String padding$2) {
        systems$1.foreach((Function1)new Serializable($this, systems$1, padding$2){
            public static final long serialVersionUID;
            private final OutputReporter $outer;
            private final Iterable systems$1;
            private final String padding$2;

            static {
                long l2 = serialVersionUID = 0L;
            }

            public final void apply(Sus s2) {
                if (OutputReporter$class.org$specs$runner$OutputReporter$$canReport(this.$outer, s2) && (!s2.examples().isEmpty() || s2.hasOwnFailureOrErrors())) {
                    if (s2.isAnonymous()) {
                        this.$outer.reportExamples((Iterable<Example>)s2.examples(), this.padding$2);
                    } else {
                        OutputReporter$class.displaySus$1(this.$outer, s2, this.systems$1, this.padding$2);
                    }
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.systems$1 = iterable;
                this.padding$2 = string;
            }
        });
    }

    public static void reportSus(OutputReporter $this, Sus sus, String padding) {
        $this.printSus(sus, padding);
        if (BoxesRunTime.unboxToBoolean((Object)$this.statistics().apply()) && !BoxesRunTime.unboxToBoolean((Object)$this.finalStatisticsOnly().apply()) && !sus.examples().isEmpty()) {
            $this.printStats(sus, padding);
        }
    }

    public static void printSus(OutputReporter $this, Sus sus, String padding) {
        String susDescription;
        String string = susDescription = sus.isAnonymous() ? "" : sus.header();
        if (sus.literateDesc().isEmpty()) {
            $this.println(new StringBuilder().append((Object)padding).append((Object)susDescription).toString());
        } else {
            $this.println(new StringBuilder().append((Object)padding).append((Object)sus.literateDescText()).toString());
        }
        $this.timer().start();
        if (!BoxesRunTime.unboxToBoolean((Object)$this.planOnly().apply()) && sus.hasOwnFailureOrErrors()) {
            $this.reportExample(sus, padding);
        }
        $this.reportExamples((Iterable<Example>)sus.examples(), padding);
        $this.timer().stop();
        $this.println("");
    }

    public static void printStats(OutputReporter $this, Sus sus, String padding) {
        $this.println(new StringBuilder().append((Object)padding).append((Object)"Total for SUS \"").append((Object)sus.description()).append((Object)"\":").toString());
        $this.printStats($this.stats(sus), padding);
    }

    public static void printStats(OutputReporter $this, Tuple5 stat, String padding) {
        Tuple5 tuple5 = stat;
        if (tuple5 != null) {
            Tuple5 tuple52 = new Tuple5(tuple5._1(), tuple5._2(), tuple5._3(), tuple5._4(), tuple5._5());
            int examplesNb = BoxesRunTime.unboxToInt((Object)tuple52._1());
            int expectationsNb2 = BoxesRunTime.unboxToInt((Object)tuple52._2());
            int failuresNb = BoxesRunTime.unboxToInt((Object)tuple52._3());
            int errorsNb = BoxesRunTime.unboxToInt((Object)tuple52._4());
            int skippedNb = BoxesRunTime.unboxToInt((Object)tuple52._5());
            $this.println(new StringBuilder().append((Object)padding).append((Object)"Finished in ").append((Object)$this.timer().time()).toString());
            $this.println(new StringBuilder().append((Object)padding).append((Object)BoxesRunTime.boxToInteger((int)examplesNb)).append((Object)Plural$.MODULE$.stringToPlural(" example").plural(examplesNb)).append((Object)(skippedNb > 0 ? new StringBuilder().append((Object)" (").append((Object)BoxesRunTime.boxToInteger((int)skippedNb)).append((Object)" skipped)").toString() : "")).append((Object)", ").append((Object)BoxesRunTime.boxToInteger((int)expectationsNb2)).append((Object)Plural$.MODULE$.stringToPlural(" expectation").plural(expectationsNb2)).append((Object)", ").append((Object)OutputReporter$class.failureColoredIf$1($this, new StringBuilder().append(failuresNb).append((Object)Plural$.MODULE$.stringToPlural(" failure").plural(failuresNb)).toString(), failuresNb > 0)).append((Object)", ").append((Object)OutputReporter$class.failureColoredIf$1($this, new StringBuilder().append(errorsNb).append((Object)Plural$.MODULE$.stringToPlural(" error").plural(errorsNb)).toString(), errorsNb > 0)).toString());
            $this.println("");
            return;
        }
        throw new MatchError((Object)tuple5);
    }

    public static void reportExamples(OutputReporter $this, Iterable examples2, String padding$4) {
        examples2.foreach((Function1)new Serializable($this, padding$4){
            public static final long serialVersionUID;
            private final OutputReporter $outer;
            private final String padding$4;

            static {
                long l2 = serialVersionUID = 0L;
            }

            public final void apply(Example example) {
                this.$outer.reportExample(example, this.padding$4);
                if (!BoxesRunTime.unboxToBoolean((Object)this.$outer.planOnly().apply())) {
                    this.$outer.reportExamples((Iterable<Example>)example.examples(), new StringBuilder().append((Object)this.padding$4).append((Object)"  ").toString());
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.padding$4 = string;
            }
        });
    }

    public static void reportExample(OutputReporter $this, Examples example, String padding$3) {
        if (BoxesRunTime.unboxToBoolean((Object)$this.planOnly().apply()) || OutputReporter$class.org$specs$runner$OutputReporter$$canReport($this, example)) {
            $this.println(new StringBuilder().append((Object)padding$3).append((Object)OutputReporter$class.status$1($this, example)).append((Object)" ").append((Object)example.description()).toString());
        }
        if (!BoxesRunTime.unboxToBoolean((Object)$this.planOnly().apply()) && example.examples().isEmpty()) {
            List list = example.skipped().toList();
            List list2 = example.failures().toList();
            example.errors().toList().$colon$colon$colon(list2).$colon$colon$colon(list).foreach((Function1)new Serializable($this, padding$3){
                public static final long serialVersionUID;
                private final OutputReporter $outer;
                private final String padding$3;

                static {
                    long l2 = serialVersionUID = 0L;
                }

                public final void apply(Throwable f2) {
                    if (f2.getMessage() == null) {
                        this.$outer.println(new StringBuilder().append((Object)this.padding$3).append((Object)OutputReporter$class.errorType$1(this.$outer, f2)).append((Object)OutputReporter$class.parens$1(this.$outer, f2)).toString());
                    } else {
                        this.$outer.println(new StringBuilder().append((Object)this.padding$3).append((Object)"  ").append((Object)OutputReporter$class.errorType$1(this.$outer, f2)).append((Object)f2.getMessage().replaceAll("\n", new StringBuilder().append((Object)"\n").append((Object)this.padding$3).append((Object)"  ").toString())).append((Object)OutputReporter$class.parens$1(this.$outer, f2)).toString());
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.padding$3 = string;
                }
            });
            if (BoxesRunTime.unboxToBoolean((Object)$this.stacktrace().apply()) && example.errors().size() > 0) {
                example.errors().foreach((Function1)new Serializable($this, padding$3){
                    public static final long serialVersionUID;
                    private final OutputReporter $outer;
                    public final String padding$3;

                    static {
                        long l2 = serialVersionUID = 0L;
                    }

                    public final void apply(Throwable e2) {
                        this.$outer.printStackTrace(e2);
                        ExtendedThrowable$.MODULE$.toExtendedThrowable(e2).chainedExceptions().foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID;
                            private final OutputReporter$.anonfun.reportExample.2 $outer;

                            static {
                                long l2 = serialVersionUID = 0L;
                            }

                            public final void apply(Throwable chained) {
                                this.$outer.org$specs$runner$OutputReporter$$anonfun$$$outer().println(new StringBuilder().append((Object)this.$outer.padding$3).append((Object)" ").append((Object)chained.getMessage()).toString());
                                this.$outer.org$specs$runner$OutputReporter$$anonfun$$$outer().printStackTrace(chained);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public OutputReporter org$specs$runner$OutputReporter$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.padding$3 = string;
                    }
                });
            }
        }
    }

    public static final boolean org$specs$runner$OutputReporter$$canReport(OutputReporter $this, HasResults hasResults) {
        return !BoxesRunTime.unboxToBoolean((Object)$this.failedAndErrorsOnly().apply()) || BoxesRunTime.unboxToBoolean((Object)$this.failedAndErrorsOnly().apply()) && hasResults.hasFailureOrErrors();
    }

    public static final void displaySus$1(OutputReporter $this, Sus s2, Iterable iterable, String string) {
        if (iterable.toList().size() > 1) {
            $this.reportSus(s2, string);
        } else {
            $this.printSus(s2, string);
        }
    }

    private static final String failureColoredIf$1(OutputReporter $this, String text, boolean cond) {
        return cond ? $this.failureColored(text) : text;
    }

    private static final String status$1(OutputReporter $this, Examples example) {
        return BoxesRunTime.unboxToBoolean((Object)$this.planOnly().apply()) ? $this.infoColored("-") : (example.hasFailureOrErrors() ? $this.failureColored("x") : (example.skipped().size() > 0 ? $this.skipColored("o") : $this.successColored("+")));
    }

    public static final String parens$1(OutputReporter $this, Throwable f2) {
        return new StringBuilder().append((Object)" (").append((Object)ExtendedThrowable$.MODULE$.toExtendedThrowable(f2).location()).append((Object)")").toString();
    }

    public static final String errorType$1(OutputReporter $this, Throwable t2) {
        Throwable throwable = t2;
        return throwable instanceof SkippedException ? "" : (throwable instanceof FailureException ? "" : new StringBuilder().append((Object)throwable.getClass().getName()).append((Object)": ").toString());
    }

    public static void $init$(OutputReporter $this) {
    }
}

