/*
 * Decompiled with CFR 0.152.
 */
package org.scoverage.plugin;

import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.doxia.module.xhtml.decoration.render.RenderingContext;
import org.apache.maven.doxia.siterenderer.sink.SiteRendererSink;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.plexus.util.StringUtils;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Set;
import scoverage.Coverage;
import scoverage.IOUtils;
import scoverage.Serializer;
import scoverage.report.CoberturaXmlWriter;
import scoverage.report.ScoverageHtmlWriter;
import scoverage.report.ScoverageXmlWriter;

@Mojo(name="report", threadSafe=false)
@Execute(lifecycle="scoverage", phase=LifecyclePhase.TEST)
public class SCoverageReportMojo
extends AbstractMojo
implements MavenReport {
    @Parameter(property="scoverage.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="scoverage.failOnError", defaultValue="true", readonly=true)
    private boolean failOnError;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="scoverage.dataDirectory", defaultValue="${project.build.directory}/scoverage-data", required=true, readonly=true)
    private File dataDirectory;
    @Parameter(property="scoverage.outputDirectory", defaultValue="${project.reporting.outputDirectory}/scoverage", required=true, readonly=true)
    private File outputDirectory;
    @Parameter(property="scoverage.xmlOutputDirectory", defaultValue="${project.build.directory}", required=true, readonly=true)
    private File xmlOutputDirectory;
    @Parameter(property="destDir", defaultValue="scoverage", required=true, readonly=true)
    private String destDir;
    @Parameter(property="name", readonly=true)
    private String name;
    @Parameter(property="description", readonly=true)
    private String description;

    public String getName(Locale locale) {
        if (StringUtils.isEmpty((String)this.name)) {
            return this.getBundle(locale).getString("report.scoverage.name");
        }
        return this.name;
    }

    public String getDescription(Locale locale) {
        if (StringUtils.isEmpty((String)this.description)) {
            return this.getBundle(locale).getString("report.scoverage.description");
        }
        return this.description;
    }

    public void generate(Sink sink, Locale locale) throws MavenReportException {
        try {
            long ts = System.currentTimeMillis();
            File sourceDir = new File(this.project.getBuild().getSourceDirectory());
            this.mkdirs(this.outputDirectory);
            this.mkdirs(this.xmlOutputDirectory);
            File coverageFile = Serializer.coverageFile((File)this.dataDirectory);
            Coverage coverage = Serializer.deserialize((File)coverageFile);
            Object[] measurementFiles = IOUtils.findMeasurementFiles((File)this.dataDirectory);
            Set measurements = IOUtils.invoked((Seq)Predef$.MODULE$.wrapRefArray(measurementFiles));
            coverage.apply((Iterable)measurements);
            this.getLog().info((CharSequence)"[scoverage] Generating cobertura XML report...");
            new CoberturaXmlWriter(this.project.getBasedir(), this.xmlOutputDirectory).write(coverage);
            this.getLog().info((CharSequence)"[scoverage] Generating scoverage XML report...");
            new ScoverageXmlWriter(sourceDir, this.xmlOutputDirectory, false).write(coverage);
            this.getLog().info((CharSequence)"[scoverage] Generating scoverage HTML report...");
            new ScoverageHtmlWriter(sourceDir, this.outputDirectory).write(coverage);
            long te = System.currentTimeMillis();
            this.getLog().debug((CharSequence)String.format("Mojo execution time: %d ms", te - ts));
        }
        catch (RuntimeException e) {
            if (this.failOnError) {
                throw e;
            }
            this.getLog().error((CharSequence)("Error while creating scoverage report: " + e.getMessage()), (Throwable)e);
        }
    }

    public String getOutputName() {
        return this.destDir + "/index";
    }

    public boolean isExternalReport() {
        return true;
    }

    public boolean canGenerateReport() {
        if (this.skip) {
            return false;
        }
        if ("pom".equals(this.project.getPackaging())) {
            return false;
        }
        File coverageFile = Serializer.coverageFile((File)this.dataDirectory);
        return coverageFile.exists() && coverageFile.isFile();
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    public File getReportOutputDirectory() {
        return this.outputDirectory;
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.updateReportOutputDirectory(reportOutputDirectory);
    }

    private void updateReportOutputDirectory(File reportOutputDirectory) {
        this.outputDirectory = reportOutputDirectory != null && this.destDir != null && !reportOutputDirectory.getAbsolutePath().endsWith(this.destDir) ? new File(reportOutputDirectory, this.destDir) : reportOutputDirectory;
    }

    public void execute() throws MojoExecutionException {
        if (!this.canGenerateReport()) {
            this.getLog().info((CharSequence)"Skipping SCoverage report generation");
            return;
        }
        try {
            RenderingContext context = new RenderingContext(this.outputDirectory, this.getOutputName() + ".html");
            SiteRendererSink sink = new SiteRendererSink(context);
            Locale locale = Locale.getDefault();
            this.generate((Sink)sink, locale);
        }
        catch (MavenReportException e) {
            this.failOnError("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation", (Exception)((Object)e));
        }
        catch (RuntimeException e) {
            this.failOnError("An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation", e);
        }
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("scoverage-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    private void failOnError(String prefix, Exception e) throws MojoExecutionException {
        if (this.failOnError) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new MojoExecutionException(prefix + ": " + e.getMessage(), e);
        }
        this.getLog().error((CharSequence)(prefix + ": " + e.getMessage()), (Throwable)e);
    }

    private void mkdirs(File directory) throws MavenReportException {
        if (!directory.exists() && !directory.mkdirs()) {
            throw new MavenReportException(String.format("Cannot create \"%s\" directory ", directory.getAbsolutePath()));
        }
    }
}

