/*
 * Decompiled with CFR 0.152.
 */
package org.scoverage.plugin;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.scoverage.plugin.SCoverageForkedLifecycleConfigurator;

@Mojo(name="pre-compile", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class SCoveragePreCompileMojo
extends AbstractMojo {
    @Parameter(property="scoverage.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="scala.version")
    private String scalaVersion;
    @Parameter(property="scoverage.dataDirectory", defaultValue="${project.build.directory}/scoverage-data", required=true, readonly=true)
    private File dataDirectory;
    @Parameter(property="scoverage.excludedPackages", defaultValue="")
    private String excludedPackages;
    @Parameter(property="scoverage.excludedFiles", defaultValue="")
    private String excludedFiles;
    @Parameter(property="scoverage.highlighting", defaultValue="false")
    private boolean highlighting;
    @Parameter(property="scoverage.scalacPluginVersion", defaultValue="")
    private String scalacPluginVersion;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    private List<MavenProject> reactorProjects;
    @Component
    private ArtifactFactory factory;
    @Component
    private ArtifactResolver resolver;
    @Parameter(property="localRepository", readonly=true, required=true)
    private ArtifactRepository localRepo;
    @Parameter(property="project.remoteArtifactRepositories", readonly=true, required=true)
    private List<ArtifactRepository> remoteRepos;
    @Parameter(property="plugin.artifacts", readonly=true, required=true)
    private List<Artifact> pluginArtifacts;
    private static final String SCALA_LIBRARY_GROUP_ID = "org.scala-lang";
    private static final String SCALA_LIBRARY_ARTIFACT_ID = "scala-library";
    private static final String DATA_DIR_OPTION = "-P:scoverage:dataDir:";
    private static final String EXCLUDED_PACKAGES_OPTION = "-P:scoverage:excludedPackages:";
    private static final String EXCLUDED_FILES_OPTION = "-P:scoverage:excludedFiles:";
    private static final String PLUGIN_OPTION = "-Xplugin:";
    private static final char DOUBLE_QUOTE = '\"';
    private static final char SPACE = ' ';
    private static final char PIPE = '|';

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws MojoExecutionException {
        if ("pom".equals(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"Skipping SCoverage execution for project with packaging type 'pom'");
            return;
        }
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping Scoverage execution");
            Properties projectProperties = this.project.getProperties();
            this.setProperty(projectProperties, "maven.test.skip", "true");
            this.setProperty(projectProperties, "skipTests", "true");
            return;
        }
        long ts = System.currentTimeMillis();
        String scalaMainVersion = null;
        String resolvedScalaVersion = this.resolveScalaVersion();
        if (resolvedScalaVersion == null) {
            this.getLog().warn((CharSequence)"Skipping SCoverage execution - Scala version not set");
            return;
        }
        if (resolvedScalaVersion.startsWith("2.10.")) {
            scalaMainVersion = "2.10";
        } else {
            if (!resolvedScalaVersion.startsWith("2.11.")) {
                this.getLog().warn((CharSequence)String.format("Skipping SCoverage execution - unsupported Scala version \"%s\"", resolvedScalaVersion));
                return;
            }
            scalaMainVersion = "2.11";
        }
        SCoverageForkedLifecycleConfigurator.afterForkedLifecycleEnter(this.project, this.reactorProjects);
        try {
            Artifact pluginArtifact = this.getScalaScoveragePluginArtifact(scalaMainVersion);
            Artifact runtimeArtifact = this.getScalaScoverageRuntimeArtifact(scalaMainVersion);
            if (pluginArtifact == null) {
                return;
            }
            this.addScoverageDependenciesToTestClasspath(runtimeArtifact);
            String arg = DATA_DIR_OPTION + this.dataDirectory.getAbsolutePath();
            String _scalacOptions = this.quoteArgument(arg);
            String addScalacArgs = arg;
            if (!StringUtils.isEmpty((String)this.excludedPackages)) {
                arg = EXCLUDED_PACKAGES_OPTION + this.excludedPackages.replace("(empty)", "<empty>");
                _scalacOptions = _scalacOptions + ' ' + this.quoteArgument(arg);
                addScalacArgs = addScalacArgs + '|' + arg;
            }
            if (!StringUtils.isEmpty((String)this.excludedFiles)) {
                arg = EXCLUDED_FILES_OPTION + this.excludedFiles;
                _scalacOptions = _scalacOptions + ' ' + this.quoteArgument(arg);
                addScalacArgs = addScalacArgs + '|' + arg;
            }
            if (this.highlighting) {
                _scalacOptions = _scalacOptions + ' ' + "-Yrangepos";
                addScalacArgs = addScalacArgs + '|' + "-Yrangepos";
            }
            String _scalacPlugins = String.format("%s:%s:%s", pluginArtifact.getGroupId(), pluginArtifact.getArtifactId(), pluginArtifact.getVersion());
            arg = PLUGIN_OPTION + pluginArtifact.getFile().getAbsolutePath();
            addScalacArgs = addScalacArgs + '|' + arg;
            Properties projectProperties = this.project.getProperties();
            this.setProperty(projectProperties, "sbt._scalacOptions", _scalacOptions);
            this.setProperty(projectProperties, "sbt._scalacPlugins", _scalacPlugins);
            this.setProperty(projectProperties, "addScalacArgs", addScalacArgs);
            this.setProperty(projectProperties, "analysisCacheFile", "${project.build.directory}/scoverage-analysis/compile");
            this.setProperty(projectProperties, "maven.test.failure.ignore", "true");
            this.project.getBuild().setFinalName("scoverage-" + this.project.getBuild().getFinalName());
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("SCoverage preparation failed", (Exception)((Object)e));
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("SCoverage preparation failed", (Exception)((Object)e));
        }
        long te = System.currentTimeMillis();
        this.getLog().debug((CharSequence)String.format("Mojo execution time: %d ms", te - ts));
    }

    private String quoteArgument(String arg) {
        return arg.indexOf(32) >= 0 ? '\"' + arg + '\"' : arg;
    }

    private String resolveScalaVersion() {
        String result = this.scalaVersion;
        if (result == null) {
            List dependencies = this.project.getDependencies();
            for (Dependency dependency : dependencies) {
                if (!SCALA_LIBRARY_GROUP_ID.equals(dependency.getGroupId()) || !SCALA_LIBRARY_ARTIFACT_ID.equals(dependency.getArtifactId())) continue;
                result = dependency.getVersion();
                break;
            }
        }
        return result;
    }

    private void setProperty(Properties projectProperties, String propertyName, String newValue) {
        if (projectProperties.containsKey(propertyName)) {
            String oldValue = projectProperties.getProperty(propertyName);
            projectProperties.put("scoverage.backup." + propertyName, oldValue);
        } else {
            projectProperties.remove("scoverage.backup." + propertyName);
        }
        if (newValue != null) {
            projectProperties.put(propertyName, newValue);
        } else {
            projectProperties.remove(propertyName);
        }
    }

    private Artifact getScalaScoveragePluginArtifact(String scalaMainVersion) throws ArtifactNotFoundException, ArtifactResolutionException {
        Artifact result = null;
        String resolvedScalacPluginVersion = this.scalacPluginVersion;
        if (resolvedScalacPluginVersion == null || "".equals(resolvedScalacPluginVersion)) {
            for (Artifact artifact : this.pluginArtifacts) {
                if (!"org.scoverage".equals(artifact.getGroupId()) || !"scalac-scoverage-plugin_2.10".equals(artifact.getArtifactId())) continue;
                if ("2.10".equals(scalaMainVersion)) {
                    return artifact;
                }
                resolvedScalacPluginVersion = artifact.getVersion();
                break;
            }
        }
        result = this.getResolvedArtifact("org.scoverage", "scalac-scoverage-plugin_" + scalaMainVersion, resolvedScalacPluginVersion);
        return result;
    }

    private Artifact getScalaScoverageRuntimeArtifact(String scalaMainVersion) throws ArtifactNotFoundException, ArtifactResolutionException {
        Artifact result = null;
        String resolvedScalacRuntimeVersion = this.scalacPluginVersion;
        if (resolvedScalacRuntimeVersion == null || "".equals(resolvedScalacRuntimeVersion)) {
            for (Artifact artifact : this.pluginArtifacts) {
                if (!"org.scoverage".equals(artifact.getGroupId()) || !"scalac-scoverage-plugin_2.10".equals(artifact.getArtifactId())) continue;
                resolvedScalacRuntimeVersion = artifact.getVersion();
                break;
            }
        }
        result = this.getResolvedArtifact("org.scoverage", "scalac-scoverage-runtime_" + scalaMainVersion, resolvedScalacRuntimeVersion);
        return result;
    }

    private void addScoverageDependenciesToTestClasspath(Artifact scalaScoveragePluginArtifact) throws MojoExecutionException {
        Artifact providedArtifact = this.artifactScopeToProvided(scalaScoveragePluginArtifact);
        LinkedHashSet<Artifact> set = new LinkedHashSet<Artifact>(this.project.getDependencyArtifacts());
        set.add(providedArtifact);
        this.project.setDependencyArtifacts(set);
    }

    private Artifact artifactScopeToProvided(Artifact artifact) {
        return this.factory.createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "provided", artifact.getType());
    }

    private Artifact getResolvedArtifact(String groupId, String artifactId, String version) throws ArtifactNotFoundException, ArtifactResolutionException {
        Artifact artifact = this.factory.createArtifact(groupId, artifactId, version, "runtime", "jar");
        this.resolver.resolve(artifact, this.remoteRepos, this.localRepo);
        return artifact;
    }
}

