/*
 * Decompiled with CFR 0.152.
 */
package org.scoverage.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.doxia.module.xhtml.decoration.render.RenderingContext;
import org.apache.maven.doxia.siterenderer.sink.SiteRendererSink;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.plexus.util.StringUtils;
import org.scoverage.plugin.SCoverageForkedLifecycleConfigurator;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.JavaConversions;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.mutable.Buffer;
import scala.xml.Elem;
import scala.xml.Node;
import scala.xml.NodeSeq;
import scala.xml.XML$;
import scoverage.Coverage;
import scoverage.IOUtils;
import scoverage.Serializer;
import scoverage.report.CoberturaXmlWriter;
import scoverage.report.CoverageAggregator;
import scoverage.report.ScoverageHtmlWriter;
import scoverage.report.ScoverageXmlWriter;

@Mojo(name="report", threadSafe=false)
@Execute(lifecycle="scoverage", phase=LifecyclePhase.TEST)
public class SCoverageReportMojo
extends AbstractMojo
implements MavenReport {
    @Parameter(property="scoverage.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="scoverage.aggregate", defaultValue="false")
    private boolean aggregate;
    @Parameter(property="scoverage.failOnError", defaultValue="true", readonly=true)
    private boolean failOnError;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    private List<MavenProject> reactorProjects;
    @Parameter(property="scoverage.dataDirectory", defaultValue="${project.build.directory}/scoverage-data", required=true, readonly=true)
    private File dataDirectory;
    @Parameter(property="scoverage.outputDirectory", defaultValue="${project.reporting.outputDirectory}/scoverage", required=true, readonly=true)
    private File outputDirectory;
    @Parameter(property="scoverage.xmlOutputDirectory", defaultValue="${project.build.directory}", required=true, readonly=true)
    private File xmlOutputDirectory;
    @Parameter(property="destDir", defaultValue="scoverage", required=true, readonly=true)
    private String destDir;
    @Parameter(property="name", readonly=true)
    private String name;
    @Parameter(property="description", readonly=true)
    private String description;

    public String getName(Locale locale) {
        if (StringUtils.isEmpty((String)this.name)) {
            return this.getBundle(locale).getString("report.scoverage.name");
        }
        return this.name;
    }

    public String getDescription(Locale locale) {
        if (StringUtils.isEmpty((String)this.description)) {
            return this.getBundle(locale).getString("report.scoverage.description");
        }
        return this.description;
    }

    public void generate(Sink sink, Locale locale) throws MavenReportException {
        boolean canGenerateNonAggregatedReport = this.canGenerateNonAggregatedReport();
        boolean canGenerateAggregatedReport = this.canGenerateAggregatedReport();
        boolean canAttachAggregatedReportToSite = this.canAttachAggregatedReportToSite();
        if (canAttachAggregatedReportToSite && !canGenerateNonAggregatedReport && !canGenerateAggregatedReport) {
            return;
        }
        try {
            long ts = System.currentTimeMillis();
            if (canGenerateNonAggregatedReport) {
                this.generateReports();
            }
            if (canGenerateAggregatedReport) {
                this.generateAggregatedReports();
            }
            long te = System.currentTimeMillis();
            this.getLog().debug((CharSequence)String.format("Mojo execution time: %d ms", te - ts));
        }
        catch (MavenReportException e) {
            if (this.failOnError) {
                throw e;
            }
            this.getLog().error((CharSequence)("Error while creating scoverage report: " + e.getMessage()), (Throwable)e);
        }
        catch (RuntimeException e) {
            if (this.failOnError) {
                throw new MavenReportException("Report generation exception", (Exception)e);
            }
            this.getLog().error((CharSequence)("Error while creating scoverage report: " + e.getMessage()), (Throwable)e);
        }
    }

    public String getOutputName() {
        return this.destDir + "/index";
    }

    public boolean isExternalReport() {
        return true;
    }

    public boolean canGenerateReport() {
        boolean result;
        if (!this.skip && !"pom".equals(this.project.getPackaging())) {
            SCoverageForkedLifecycleConfigurator.afterForkedLifecycleExit(this.project, this.reactorProjects);
        }
        boolean canGenerateNonAggregatedReport = this.canGenerateNonAggregatedReport();
        boolean canAttachAggregatedReportToSite = this.canAttachAggregatedReportToSite();
        boolean bl = result = canGenerateNonAggregatedReport || canAttachAggregatedReportToSite;
        if (!result && this.canGenerateAggregatedReport()) {
            try {
                this.generateAggregatedReports();
            }
            catch (MavenReportException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private boolean canGenerateNonAggregatedReport() {
        if (this.skip) {
            return false;
        }
        if ("pom".equals(this.project.getPackaging())) {
            return false;
        }
        File coverageFile = Serializer.coverageFile((File)this.dataDirectory);
        return coverageFile.exists() && coverageFile.isFile();
    }

    private boolean canGenerateAggregatedReport() {
        return this.aggregate && this.reactorProjects.size() > 1 && this.project == this.reactorProjects.get(this.reactorProjects.size() - 1);
    }

    private boolean canAttachAggregatedReportToSite() {
        return this.aggregate && this.reactorProjects.size() > 1 && this.project.isExecutionRoot();
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    public File getReportOutputDirectory() {
        return this.outputDirectory;
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.updateReportOutputDirectory(reportOutputDirectory);
    }

    private void updateReportOutputDirectory(File reportOutputDirectory) {
        this.outputDirectory = reportOutputDirectory != null && this.destDir != null && !reportOutputDirectory.getAbsolutePath().endsWith(this.destDir) ? new File(reportOutputDirectory, this.destDir) : reportOutputDirectory;
    }

    public void execute() throws MojoExecutionException {
        if (!this.canGenerateReport()) {
            this.getLog().info((CharSequence)"Skipping SCoverage report generation");
            return;
        }
        try {
            RenderingContext context = new RenderingContext(this.outputDirectory, this.getOutputName() + ".html");
            SiteRendererSink sink = new SiteRendererSink(context);
            Locale locale = Locale.getDefault();
            this.generate((Sink)sink, locale);
        }
        catch (MavenReportException e) {
            String prefix = "An error has occurred in " + this.getName(Locale.ENGLISH) + " report generation";
            throw new MojoExecutionException(prefix + ": " + e.getMessage(), (Exception)((Object)e));
        }
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("scoverage-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    private void generateReports() throws MavenReportException {
        List sourceDirs = this.project.getExecutionProject().getCompileSourceRoots();
        ArrayList<File> sourceRoots = new ArrayList<File>(sourceDirs.size());
        for (String dir : sourceDirs) {
            sourceRoots.add(new File(dir));
        }
        this.mkdirs(this.outputDirectory);
        this.mkdirs(this.xmlOutputDirectory);
        File coverageFile = Serializer.coverageFile((File)this.dataDirectory);
        Coverage coverage = Serializer.deserialize((File)coverageFile);
        Object[] measurementFiles = IOUtils.findMeasurementFiles((File)this.dataDirectory);
        Set measurements = IOUtils.invoked((Seq)Predef$.MODULE$.wrapRefArray(measurementFiles));
        coverage.apply((Iterable)measurements);
        Buffer sourceRootsAsScalaSeq = JavaConversions.asScalaBuffer(sourceRoots);
        this.getLog().info((CharSequence)"[scoverage] Generating cobertura XML report...");
        new CoberturaXmlWriter((Seq)sourceRootsAsScalaSeq, this.xmlOutputDirectory).write(coverage);
        this.getLog().info((CharSequence)"[scoverage] Generating scoverage XML report...");
        new ScoverageXmlWriter((Seq)sourceRootsAsScalaSeq, this.xmlOutputDirectory, false).write(coverage);
        this.getLog().info((CharSequence)"[scoverage] Generating scoverage HTML report...");
        new ScoverageHtmlWriter((Seq)sourceRootsAsScalaSeq, this.outputDirectory).write(coverage);
    }

    private void generateAggregatedReports() throws MavenReportException {
        ArrayList<File> scoverageXmlFiles = new ArrayList<File>();
        ArrayList<File> sourceRoots = new ArrayList<File>();
        MavenProject topLevelModule = null;
        for (MavenProject module : this.reactorProjects) {
            File moduleXmlOutputDirectory;
            File scoverageXmlFile;
            if (module.isExecutionRoot()) {
                topLevelModule = module;
                continue;
            }
            if (module.getPackaging().equals("pom") || !(scoverageXmlFile = new File(moduleXmlOutputDirectory = this.rebase(this.xmlOutputDirectory, module), "scoverage.xml")).isFile()) continue;
            scoverageXmlFiles.add(scoverageXmlFile);
            File coberturaXmlFile = new File(moduleXmlOutputDirectory, "cobertura.xml");
            if (!coberturaXmlFile.isFile()) continue;
            Elem xml = (Elem)XML$.MODULE$.loadFile(coberturaXmlFile);
            Node sources = (Node)xml.$bslash("sources").head();
            NodeSeq sourceSeq = sources.$bslash("source");
            for (Node source : sourceSeq) {
                String path = source.text().trim();
                if ("--source".equals(path)) continue;
                sourceRoots.add(new File(path));
            }
        }
        File topLevelModuleOutputDirectory = this.rebase(this.outputDirectory, topLevelModule);
        File topLevelModuleXmlOutputDirectory = this.rebase(this.xmlOutputDirectory, topLevelModule);
        this.mkdirs(topLevelModuleOutputDirectory);
        this.mkdirs(topLevelModuleXmlOutputDirectory);
        Buffer sourceRootsAsScalaSeq = JavaConversions.asScalaBuffer(sourceRoots);
        Coverage coverage = CoverageAggregator.aggregatedCoverage((Seq)JavaConversions.asScalaBuffer(scoverageXmlFiles).toSeq());
        this.getLog().info((CharSequence)"[scoverage] Generating aggregated cobertura XML report...");
        new CoberturaXmlWriter((Seq)sourceRootsAsScalaSeq, topLevelModuleXmlOutputDirectory).write(coverage);
        this.getLog().info((CharSequence)"[scoverage] Generating aggregated scoverage XML report...");
        new ScoverageXmlWriter((Seq)sourceRootsAsScalaSeq, topLevelModuleXmlOutputDirectory, false).write(coverage);
        this.getLog().info((CharSequence)"[scoverage] Generating aggregated scoverage HTML report...");
        new ScoverageHtmlWriter((Seq)sourceRootsAsScalaSeq, topLevelModuleOutputDirectory).write(coverage);
    }

    private void mkdirs(File directory) throws MavenReportException {
        if (!directory.exists() && !directory.mkdirs()) {
            throw new MavenReportException(String.format("Cannot create \"%s\" directory ", directory.getAbsolutePath()));
        }
        if (directory.exists() && !directory.isDirectory()) {
            throw new MavenReportException(String.format("Directory \"%s\" exists but is not a directory ", directory.getAbsolutePath()));
        }
    }

    private File rebase(File file, MavenProject otherModule) {
        return new File(file.getAbsolutePath().replace(this.project.getBasedir().getAbsolutePath(), otherModule.getBasedir().getAbsolutePath()));
    }
}

