/*
 * Decompiled with CFR 0.152.
 */
package org.scoverage.plugin;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.scoverage.plugin.SCoverageForkedLifecycleConfigurator;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Set;
import scoverage.Coverage;
import scoverage.IOUtils;
import scoverage.Serializer;

@Mojo(name="check", threadSafe=false)
@Execute(lifecycle="scoverage", phase=LifecyclePhase.TEST)
public class SCoverageCheckMojo
extends AbstractMojo {
    @Parameter(property="scoverage.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="scoverage.dataDirectory", defaultValue="${project.build.directory}/scoverage-data", required=true, readonly=true)
    private File dataDirectory;
    @Parameter(property="scoverage.minimumCoverage", defaultValue="0")
    private Double minimumCoverage;
    @Parameter(property="scoverage.failOnMinimumCoverage", defaultValue="false")
    private boolean failOnMinimumCoverage;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    private List<MavenProject> reactorProjects;

    public void execute() throws MojoFailureException {
        if ("pom".equals(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"Skipping SCoverage execution for project with packaging type 'pom'");
            return;
        }
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping Scoverage execution");
            return;
        }
        long ts = System.currentTimeMillis();
        SCoverageForkedLifecycleConfigurator.afterForkedLifecycleExit(this.project, this.reactorProjects);
        if (!this.dataDirectory.exists() || !this.dataDirectory.isDirectory()) {
            this.getLog().info((CharSequence)"Cannot perform check, instrumentation not performed - skipping");
            return;
        }
        File coverageFile = Serializer.coverageFile((File)this.dataDirectory);
        if (!coverageFile.exists()) {
            this.getLog().info((CharSequence)"Scoverage data file does not exist. Skipping report generation");
            return;
        }
        if (!coverageFile.isFile()) {
            this.getLog().info((CharSequence)"Scoverage data file is a directory, not a file. Skipping report generation");
            return;
        }
        Coverage coverage = Serializer.deserialize((File)coverageFile);
        Object[] measurementFiles = IOUtils.findMeasurementFiles((File)this.dataDirectory);
        Set measurements = IOUtils.invoked((Seq)Predef$.MODULE$.wrapRefArray(measurementFiles));
        coverage.apply((Iterable)measurements);
        int branchCount = coverage.branchCount();
        int statementCount = coverage.statementCount();
        int invokedBranchesCount = coverage.invokedBranchesCount();
        int invokedStatementCount = coverage.invokedStatementCount();
        this.getLog().debug((CharSequence)String.format("invokedBranchesCount:%d / branchCount:%d, invokedStatementCount:%d / statementCount:%d", invokedBranchesCount, branchCount, invokedStatementCount, statementCount));
        if (this.minimumCoverage > 0.0) {
            if (this.is100(this.minimumCoverage) && this.is100(coverage.statementCoveragePercent())) {
                this.getLog().info((CharSequence)"[scoverage] 100% Coverage !");
            } else if (this.minimumCoverage > coverage.statementCoveragePercent()) {
                this.getLog().error((CharSequence)String.format("[scoverage] Coverage is below minimum [%s%% < %.2f%%]", coverage.statementCoverageFormatted(), this.minimumCoverage));
                if (this.failOnMinimumCoverage) {
                    throw new MojoFailureException("Coverage minimum was not reached");
                }
            } else {
                this.getLog().info((CharSequence)String.format("[scoverage] Coverage is above minimum [%s%% > %.2f%%]", coverage.statementCoverageFormatted(), this.minimumCoverage));
            }
        }
        this.getLog().info((CharSequence)String.format("[scoverage] All done. Coverage was [%s%%]", coverage.statementCoverageFormatted()));
        long te = System.currentTimeMillis();
        this.getLog().debug((CharSequence)String.format("Mojo execution time: %d ms", te - ts));
    }

    private boolean is100(Double d) {
        return Math.abs(100.0 - d) <= 1.0E-5;
    }
}

