/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.icepdf.component;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.icepdf.core.SecurityCallback;
import org.icepdf.core.exceptions.PDFException;
import org.icepdf.core.exceptions.PDFSecurityException;
import org.icepdf.core.pobjects.Document;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.exception.TaskWrongPasswordException;
import org.sejda.model.input.PdfFileSource;
import org.sejda.model.input.PdfSource;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.input.PdfStreamSource;
import org.sejda.model.input.PdfURLSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPdfSourceOpener
implements PdfSourceOpener<Document> {
    private static final String AN_ERROR_OCCURRED_OPENING_SOURCE = "An error occurred opening the source: %s.";

    public Document open(PdfURLSource source) throws TaskIOException {
        Document document = this.newDocument((PdfSource<?>)source);
        try {
            document.setUrl(source.getSource());
        }
        catch (PDFException e) {
            throw new TaskIOException(String.format(AN_ERROR_OCCURRED_OPENING_SOURCE, source), (Throwable)e);
        }
        catch (PDFSecurityException e) {
            throw new TaskWrongPasswordException(String.format("An error occurred decrypting the source: %s.", source), (Throwable)e);
        }
        catch (IOException e) {
            throw new TaskIOException(String.format(AN_ERROR_OCCURRED_OPENING_SOURCE, source), (Throwable)e);
        }
        return document;
    }

    public Document open(PdfFileSource source) throws TaskIOException {
        Document document = this.newDocument((PdfSource<?>)source);
        try {
            document.setFile(source.getSource().getAbsolutePath());
        }
        catch (PDFException e) {
            throw new TaskIOException(String.format(AN_ERROR_OCCURRED_OPENING_SOURCE, source), (Throwable)e);
        }
        catch (PDFSecurityException e) {
            throw new TaskWrongPasswordException(String.format("An error occurred decrypting the source: %s.", source), (Throwable)e);
        }
        catch (IOException e) {
            throw new TaskIOException(String.format(AN_ERROR_OCCURRED_OPENING_SOURCE, source), (Throwable)e);
        }
        return document;
    }

    public Document open(PdfStreamSource source) throws TaskIOException {
        Document document = this.newDocument((PdfSource<?>)source);
        try {
            document.setInputStream(source.getSource(), source.getName());
        }
        catch (PDFException e) {
            throw new TaskIOException(String.format(AN_ERROR_OCCURRED_OPENING_SOURCE, source), (Throwable)e);
        }
        catch (PDFSecurityException e) {
            throw new TaskWrongPasswordException(String.format("An error occurred decrypting the source: %s.", source), (Throwable)e);
        }
        catch (IOException e) {
            throw new TaskIOException(String.format("An I/O error occurred opening the source: %s.", source), (Throwable)e);
        }
        return document;
    }

    private Document newDocument(PdfSource<?> source) {
        Document document = new Document();
        if (StringUtils.isNotBlank((CharSequence)source.getPassword())) {
            document.setSecurityCallback((SecurityCallback)new PdfSourceSecurityCallback(source));
        }
        return document;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PdfSourceSecurityCallback
    implements SecurityCallback {
        private final PdfSource<?> source;

        private PdfSourceSecurityCallback(PdfSource<?> source) {
            this.source = source;
        }

        public String requestPassword(Document document) {
            return this.source.getPassword();
        }
    }
}

