/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.icepdf.component;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.PDimension;
import org.icepdf.core.pobjects.Page;
import org.sejda.model.parameter.image.AbstractPdfToImageParameters;

public final class PdfToBufferedImageProvider {
    private PdfToBufferedImageProvider() {
    }

    public static BufferedImage toBufferedImage(Document document, int page, AbstractPdfToImageParameters parameters) {
        Page currentPage = document.getPageTree().getPage(page, (Object)document);
        PDimension pageDimensions = currentPage.getSize(0.0f, parameters.getUserZoom());
        BufferedImage currentImage = parameters.getOutputImageColorType().createBufferedImage((int)pageDimensions.getWidth(), (int)pageDimensions.getHeight());
        Graphics2D g = currentImage.createGraphics();
        currentPage.paint((Graphics)g, 2, 2, 0.0f, parameters.getUserZoom());
        g.dispose();
        return currentImage;
    }
}

