/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.openqa.selenium.grid.web.ClassPathResource;
import org.openqa.selenium.grid.web.NoHandler;
import org.openqa.selenium.grid.web.ResourceHandler;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Routable;
import org.openqa.selenium.remote.http.Route;

public class GridUiRoute
implements Routable {
    private static final Logger LOG = Logger.getLogger("selenium");
    private static final String GRID_RESOURCE = "grid-ui";
    private static final String GRID_RESOURCE_WITH_PREFIX = String.format("/%s", "grid-ui");
    private final Route routes;

    public GridUiRoute(String prefix) {
        Require.nonNull((String)prefix, (Object)"Prefix cannot be null");
        URL uiRoot = GridUiRoute.class.getResource(GRID_RESOURCE_WITH_PREFIX);
        if (uiRoot != null) {
            ResourceHandler uiHandler = new ResourceHandler(new ClassPathResource(uiRoot, GRID_RESOURCE));
            HttpResponse uiRedirect = (HttpResponse)new HttpResponse().setStatus(302).addHeader("Location", prefix.concat("/ui/"));
            Supplier<HttpHandler> redirectHandler = () -> req -> uiRedirect;
            Route appendRoute = Route.combine((Routable)GridUiRoute.consoleRoute(prefix, redirectHandler), (Routable[])new Routable[]{GridUiRoute.uiRoute(prefix, () -> uiHandler)});
            if (!prefix.isEmpty()) {
                appendRoute = Route.combine((Routable)appendRoute, (Routable[])new Routable[]{GridUiRoute.redirectRoute(prefix, redirectHandler)});
            }
            this.routes = Route.combine((Routable)Route.get((String)"/").to(redirectHandler), (Routable[])new Routable[]{appendRoute});
        } else {
            LOG.warning("It was not possible to load the Grid UI.");
            Json json = new Json();
            this.routes = Route.matching(req -> false).to(() -> new NoHandler(json));
        }
    }

    public boolean matches(HttpRequest req) {
        return this.routes.matches(req);
    }

    public HttpResponse execute(HttpRequest req) {
        return this.routes.execute(req);
    }

    private static Routable uiRoute(String prefix, Supplier<HttpHandler> handler) {
        return GridUiRoute.buildRoute("/ui", prefix, path -> Route.prefix((String)path).to(Route.matching(req -> true).to(handler)));
    }

    private static Routable consoleRoute(String prefix, Supplier<HttpHandler> handler) {
        return GridUiRoute.buildRoute("/grid/console", prefix, path -> Route.get((String)path).to(handler));
    }

    private static Routable buildRoute(String url, String prefix, Function<String, Route> mapper) {
        List<String> subPaths = prefix.isEmpty() ? Collections.singletonList(url) : Arrays.asList(prefix + url, url);
        return (Routable)subPaths.stream().map(mapper).reduce((x$0, xva$1) -> Route.combine((Routable)x$0, (Routable[])new Routable[]{xva$1})).get();
    }

    private static Routable redirectRoute(String prefix, Supplier<HttpHandler> handler) {
        prefix = prefix.endsWith("/") ? prefix.substring(0, prefix.length() - 1) : prefix;
        return Route.get((String)prefix).to(handler);
    }
}

