/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionqueue;

import java.util.Collections;
import org.openqa.selenium.grid.data.RequestId;
import org.openqa.selenium.grid.data.SessionRequest;
import org.openqa.selenium.grid.sessionqueue.NewSessionQueue;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.AttributeKey;
import org.openqa.selenium.remote.tracing.HttpTracing;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.Tracer;

class AddBackToSessionQueue
implements HttpHandler {
    private final Tracer tracer;
    private final NewSessionQueue newSessionQueue;
    private final RequestId id;

    AddBackToSessionQueue(Tracer tracer, NewSessionQueue newSessionQueue, RequestId id) {
        this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
        this.newSessionQueue = (NewSessionQueue)Require.nonNull((String)"New Session Queue", (Object)newSessionQueue);
        this.id = id;
    }

    public HttpResponse execute(HttpRequest req) {
        try (Span span = HttpTracing.newSpanAsChildOf((Tracer)this.tracer, (HttpRequest)req, (String)"sessionqueue.retry");){
            Tags.HTTP_REQUEST.accept(span, req);
            span.setAttribute(AttributeKey.REQUEST_ID.getKey(), this.id.toString());
            SessionRequest sessionRequest = (SessionRequest)Contents.fromJson((HttpMessage)req, SessionRequest.class);
            boolean value = this.newSessionQueue.retryAddToQueue(sessionRequest);
            span.setAttribute("request.retry", value);
            HttpResponse response = (HttpResponse)new HttpResponse().setContent(Contents.asJson(Collections.singletonMap("value", value)));
            Tags.HTTP_RESPONSE.accept(span, response);
            HttpResponse httpResponse = response;
            return httpResponse;
        }
    }
}

