/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.cli;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.openqa.selenium.internal.Require;

public class WrappedPrintWriter
extends PrintWriter {
    private final int lineLength;
    private final int indentBy;
    private int position = 0;

    public WrappedPrintWriter(OutputStream out, int lineLength, int indentBy) {
        this(new OutputStreamWriter(out, Charset.defaultCharset()), lineLength, indentBy);
    }

    public WrappedPrintWriter(Writer out, int lineLength, int indentBy) {
        super(out);
        this.lineLength = Require.argument((String)"Line length", (Integer)lineLength).greaterThan(9, "Lines must be 10 or more characters");
        this.indentBy = Require.nonNegative((String)"An indent", (Integer)indentBy);
    }

    @Override
    public void write(int c) {
        if (c == 10) {
            super.write(c);
            this.position = 0;
        } else {
            if (this.position > this.lineLength && Character.isWhitespace(c)) {
                super.write(10);
                for (int i = 0; i < this.indentBy; ++i) {
                    super.write(32);
                }
                this.position = this.indentBy;
                return;
            }
            super.write(c);
            ++this.position;
        }
        this.flush();
    }

    @Override
    public void write(char[] buf, int off, int len) {
        for (int i = 0; i < len; ++i) {
            this.write(buf[off + i]);
        }
    }

    @Override
    public void write(String s, int off, int len) {
        for (int i = 0; i < len; ++i) {
            this.write(s.charAt(off + i));
        }
    }
}

