/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.openqa.selenium.grid.TemplateGridCommand;
import org.openqa.selenium.grid.config.CompoundConfig;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.MemoizedConfig;
import org.openqa.selenium.grid.server.BaseServerOptions;
import org.openqa.selenium.grid.server.Server;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.netty.server.NettyServer;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.Message;
import org.openqa.selenium.remote.http.Routable;
import org.openqa.selenium.remote.http.Route;

public abstract class TemplateGridServerCommand
extends TemplateGridCommand {
    private static final String GRAPHQL = "/graphql";

    public Server<?> asServer(Config initialConfig) {
        Require.nonNull((String)"Config", (Object)initialConfig);
        MemoizedConfig config = new MemoizedConfig(new CompoundConfig(initialConfig, this.getDefaultConfig()));
        Handlers handler = this.createHandlers(config);
        return new NettyServer(new BaseServerOptions(config), handler.httpHandler, handler.websocketHandler);
    }

    protected static Routable graphqlRoute(String prefix, Supplier<HttpHandler> handler) {
        Routable optionsRoute = TemplateGridServerCommand.buildRoute(GRAPHQL, prefix, path -> Route.options((String)path).to(handler));
        Routable postRoute = TemplateGridServerCommand.buildRoute(GRAPHQL, prefix, path -> Route.post((String)path).to(handler));
        return Route.combine((Routable)optionsRoute, (Routable[])new Routable[]{postRoute});
    }

    protected static Routable hubRoute(String prefix, Route route) {
        return TemplateGridServerCommand.buildRoute("/wd/hub", prefix, path -> Route.prefix((String)path).to(route));
    }

    private static Routable buildRoute(String url, String prefix, Function<String, Route> mapper) {
        List<String> subPaths = prefix.isEmpty() ? Collections.singletonList(url) : Arrays.asList(prefix + url, url);
        return (Routable)subPaths.stream().map(mapper).reduce((x$0, xva$1) -> Route.combine((Routable)x$0, (Routable[])new Routable[]{xva$1})).get();
    }

    protected static Routable baseRoute(String prefix, Route route) {
        if (prefix.isEmpty()) {
            return route;
        }
        return Route.combine((Routable)route, (Routable[])new Routable[]{Route.prefix((String)prefix).to(route)});
    }

    protected abstract Handlers createHandlers(Config var1);

    public static class Handlers {
        public final HttpHandler httpHandler;
        public final BiFunction<String, Consumer<Message>, Optional<Consumer<Message>>> websocketHandler;

        public Handlers(HttpHandler http, BiFunction<String, Consumer<Message>, Optional<Consumer<Message>>> websocketHandler) {
            this.httpHandler = (HttpHandler)Require.nonNull((String)"HTTP handler", (Object)http);
            this.websocketHandler = websocketHandler == null ? (str, sink) -> Optional.empty() : websocketHandler;
        }
    }
}

