/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UrlTemplate {
    private static final Pattern GROUP_NAME = Pattern.compile("(\\{\\p{Alnum}+\\})");
    private final Pattern pattern;
    private final List<String> groups;

    public UrlTemplate(String template) {
        if (template == null || template.isEmpty()) {
            throw new IllegalArgumentException("Template must not be 0 length");
        }
        StringBuilder regex = new StringBuilder("^");
        Matcher groupNameMatcher = GROUP_NAME.matcher(template);
        ImmutableList.Builder groups = ImmutableList.builder();
        int lastGroup = 0;
        while (groupNameMatcher.find()) {
            int start = groupNameMatcher.start(1);
            int end = groupNameMatcher.end(1);
            regex.append(Pattern.quote(template.substring(lastGroup, start)));
            regex.append("([^/]+)");
            groups.add((Object)template.substring(start + 1, end - 1));
            lastGroup = end;
        }
        if (template.length() > lastGroup) {
            regex.append(Pattern.quote(template.substring(lastGroup)));
        }
        regex.append('$');
        this.pattern = Pattern.compile(regex.toString());
        this.groups = groups.build();
    }

    public Match match(String matchAgainst) {
        if (matchAgainst == null) {
            return null;
        }
        Matcher matcher = this.pattern.matcher(matchAgainst);
        if (!matcher.matches()) {
            return null;
        }
        ImmutableMap.Builder params = ImmutableMap.builder();
        for (int i = 0; i < this.groups.size(); ++i) {
            params.put((Object)this.groups.get(i), (Object)matcher.group(i + 1));
        }
        return new Match(matchAgainst, (Map)params.build());
    }

    public class Match {
        private final String url;
        private final Map<String, String> parameters;

        private Match(String url, Map<String, String> parameters) {
            this.url = url;
            this.parameters = ImmutableMap.copyOf(parameters);
        }

        public String getUrl() {
            return this.url;
        }

        public Map<String, String> getParameters() {
            return this.parameters;
        }
    }
}

