/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openqa.selenium.remote.http.HttpRequest;

@Deprecated(forRemoval=true)
public class FormEncodedData {
    public static Optional<Map<String, List<String>>> getData(HttpRequest request) {
        try {
            String contentType = request.getHeader("Content-Type");
            if (contentType == null || !contentType.split(";")[0].trim().equals("application/x-www-form-urlencoded")) {
                return Optional.empty();
            }
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return Optional.empty();
        }
        LinkedHashMap<String, List> data = new LinkedHashMap<String, List>();
        AtomicBoolean eof = new AtomicBoolean(false);
        Charset encoding = request.getContentEncoding();
        try (InputStream is = (InputStream)request.getContent().get();
             InputStreamReader reader = new InputStreamReader(is, request.getContentEncoding());){
            while (!eof.get()) {
                String value;
                String key = FormEncodedData.read(reader, encoding, '=', eof);
                data.computeIfAbsent(key, k -> new ArrayList()).add((value = FormEncodedData.read(reader, encoding, '&', eof)) == null ? "" : value);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        LinkedHashMap toReturn = new LinkedHashMap();
        for (Map.Entry entry : data.entrySet()) {
            toReturn.put((String)entry.getKey(), List.copyOf((Collection)entry.getValue()));
        }
        return Optional.of(Map.copyOf(toReturn));
    }

    private static String read(Reader reader, Charset charSet, char delimiter, AtomicBoolean eof) throws IOException {
        if (eof.get()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        while (true) {
            int i;
            if ((i = reader.read()) == -1) {
                eof.set(true);
                break;
            }
            char c = (char)i;
            if (c == delimiter) break;
            builder.append(c);
        }
        return URLDecoder.decode(builder.toString(), charSet.toString());
    }
}

