/*
Copyright 2007-2009 Selenium committers

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
 */

package com.thoughtworks.selenium.webdriven.commands;

import com.thoughtworks.selenium.webdriven.ElementFinder;
import com.thoughtworks.selenium.webdriven.SeleneseCommand;

import org.openqa.selenium.WebDriver;

public class AddLocationStrategy extends SeleneseCommand<Void> {
  private final ElementFinder elementFinder;

  public AddLocationStrategy(ElementFinder elementFinder) {
    this.elementFinder = elementFinder;
  }

  @Override
  protected Void handleSeleneseCommand(WebDriver driver, String strategyName,
      final String functionDefinition) {
    String strategy =
        String
            .format(
                "return (function(locator, inWindow, inDocument) { %s }).call(null, arguments[0], window, document)",
                functionDefinition);

    elementFinder.add(strategyName, strategy);

    return null;
  }
}
