/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.nevado.jms.connector.amazonaws;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.AmazonSNSClient;
import com.amazonaws.services.sns.model.CreateTopicRequest;
import com.amazonaws.services.sns.model.CreateTopicResult;
import com.amazonaws.services.sns.model.DeleteTopicRequest;
import com.amazonaws.services.sns.model.ListTopicsResult;
import com.amazonaws.services.sns.model.PublishRequest;
import com.amazonaws.services.sns.model.SubscribeRequest;
import com.amazonaws.services.sns.model.Topic;
import com.amazonaws.services.sns.model.UnsubscribeRequest;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClient;
import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.services.sqs.model.CreateQueueResult;
import com.amazonaws.services.sqs.model.ListQueuesRequest;
import com.amazonaws.services.sqs.model.ListQueuesResult;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashSet;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.ResourceAllocationException;
import javax.net.ssl.SSLException;
import org.skyscreamer.nevado.jms.connector.AbstractSQSConnector;
import org.skyscreamer.nevado.jms.connector.SQSQueue;
import org.skyscreamer.nevado.jms.connector.amazonaws.AmazonAwsSQSQueue;
import org.skyscreamer.nevado.jms.destination.NevadoQueue;
import org.skyscreamer.nevado.jms.destination.NevadoTopic;

public class AmazonAwsSQSConnector
extends AbstractSQSConnector {
    protected final AmazonSQS _amazonSQS;
    protected final AmazonSNS _amazonSNS;

    public AmazonAwsSQSConnector(String awsAccessKey, String awsSecretKey, boolean isSecure, long receiveCheckIntervalMs) {
        super(receiveCheckIntervalMs);
        BasicAWSCredentials awsCredentials = new BasicAWSCredentials(awsAccessKey, awsSecretKey);
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setProtocol(isSecure ? Protocol.HTTPS : Protocol.HTTP);
        this._amazonSQS = new AmazonSQSClient((AWSCredentials)awsCredentials, clientConfiguration);
        this._amazonSNS = new AmazonSNSClient((AWSCredentials)awsCredentials, clientConfiguration);
    }

    @Override
    protected void sendSNSMessage(NevadoTopic topic, String serializedMessage) throws JMSException {
        String arn = this.getTopicARN(topic);
        try {
            this._amazonSNS.publish(new PublishRequest(arn, serializedMessage));
        }
        catch (AmazonClientException e) {
            throw this.handleAWSException("Unable to send message to topic: " + arn, e);
        }
    }

    @Override
    protected AmazonAwsSQSQueue getSQSQueueImpl(NevadoQueue queue) throws JMSException {
        try {
            if (queue.getQueueUrl() == null) {
                CreateQueueResult result = this._amazonSQS.createQueue(new CreateQueueRequest(queue.getQueueName()));
                queue.setQueueUrl(result.getQueueUrl());
            }
        }
        catch (AmazonClientException e) {
            throw this.handleAWSException("Unable to get message queue '" + queue, e);
        }
        return new AmazonAwsSQSQueue(this, queue.getQueueUrl());
    }

    @Override
    public void test() throws JMSException {
        try {
            this._amazonSQS.listQueues();
            this._amazonSNS.listSubscriptions();
        }
        catch (AmazonClientException e) {
            throw this.handleAWSException("Connection test failed", e);
        }
    }

    @Override
    public Collection<NevadoQueue> listQueues(String temporaryQueuePrefix) throws JMSException {
        ListQueuesResult result;
        try {
            result = this._amazonSQS.listQueues(new ListQueuesRequest().withQueueNamePrefix(temporaryQueuePrefix));
        }
        catch (AmazonClientException e) {
            throw this.handleAWSException("Unable to list queues with prefix '" + temporaryQueuePrefix + "'", e);
        }
        HashSet<NevadoQueue> queues = new HashSet<NevadoQueue>(result.getQueueUrls().size());
        for (String queueUrl : result.getQueueUrls()) {
            queues.add(new NevadoQueue(queueUrl));
        }
        return queues;
    }

    @Override
    public NevadoTopic createTopic(String topicName) throws JMSException {
        NevadoTopic topic = new NevadoTopic(topicName);
        this.getTopicARN(topic);
        return topic;
    }

    @Override
    public void deleteTopic(NevadoTopic topic) throws JMSException {
        try {
            this._amazonSNS.deleteTopic(new DeleteTopicRequest().withTopicArn(this.getTopicARN(topic)));
        }
        catch (AmazonClientException e) {
            throw this.handleAWSException("Unable to delete message topic '" + topic, e);
        }
    }

    @Override
    public Collection<NevadoTopic> listTopics() throws JMSException {
        ListTopicsResult result;
        try {
            result = this._amazonSNS.listTopics();
        }
        catch (AmazonClientException e) {
            throw this.handleAWSException("Unable to list topics", e);
        }
        HashSet<NevadoTopic> topics = new HashSet<NevadoTopic>(result.getTopics().size());
        for (Topic topic : result.getTopics()) {
            topics.add(new NevadoTopic(topic.getTopicArn()));
        }
        return topics;
    }

    @Override
    public String subscribe(NevadoTopic topic, NevadoQueue topicEndpoint) throws JMSException {
        String subscriptionArn;
        try {
            SQSQueue queue = this.getSQSQueue(topicEndpoint);
            String sqsArn = queue.getQueueARN();
            String snsArn = this.getTopicARN(topic);
            queue.setPolicy(this.getPolicy(snsArn, sqsArn));
            subscriptionArn = this._amazonSNS.subscribe(new SubscribeRequest().withTopicArn(this.getTopicARN(topic)).withProtocol("sqs").withEndpoint(sqsArn)).getSubscriptionArn();
        }
        catch (AmazonClientException e) {
            throw this.handleAWSException("Unable to subscripe to topic " + topic, e);
        }
        return subscriptionArn;
    }

    @Override
    public void unsubscribe(NevadoTopic topic) throws JMSException {
        if (topic == null) {
            throw new NullPointerException();
        }
        if (topic.getSubscriptionArn() == null) {
            throw new IllegalArgumentException("Topic doesn't have a subscription");
        }
        try {
            this._amazonSNS.unsubscribe(new UnsubscribeRequest().withSubscriptionArn(topic.getSubscriptionArn()));
        }
        catch (AmazonClientException e) {
            throw this.handleAWSException("Unable to subscribe topic " + topic + " with sub ARN " + topic.getSubscriptionArn(), e);
        }
    }

    public AmazonSQS getAmazonSQS() {
        return this._amazonSQS;
    }

    public AmazonSNS getAmazonSNS() {
        return this._amazonSNS;
    }

    protected String getTopicARN(NevadoTopic topic) throws JMSException {
        if (topic.getArn() == null) {
            CreateTopicResult result;
            try {
                result = this._amazonSNS.createTopic(new CreateTopicRequest(topic.getTopicName()));
            }
            catch (AmazonClientException e) {
                throw this.handleAWSException("Unable to create/lookup topic: " + topic, e);
            }
            topic.setArn(result.getTopicArn());
        }
        return topic.getArn();
    }

    protected JMSException handleAWSException(String message, AmazonClientException e) {
        String exMessage = message + ": " + e.getMessage();
        this._log.error((Object)exMessage, (Throwable)e);
        Object jmsException = e.getCause() != null && (UnknownHostException.class.equals(e.getCause().getClass()) || SSLException.class.equals(e.getCause().getClass())) ? new ResourceAllocationException(exMessage) : (this.isSecurityException(e) ? new JMSSecurityException(exMessage) : new JMSException(exMessage));
        return jmsException;
    }

    private boolean isSecurityException(AmazonClientException e) {
        if (e instanceof AmazonServiceException) {
            return "InvalidClientTokenId".equals(((AmazonServiceException)e).getErrorCode());
        }
        return false;
    }
}

