/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.nevado.jms.connector.mock;

import java.util.LinkedList;
import javax.jms.JMSException;
import org.skyscreamer.nevado.jms.connector.SQSMessage;
import org.skyscreamer.nevado.jms.connector.SQSQueue;
import org.skyscreamer.nevado.jms.connector.mock.MockSQSConnector;
import org.skyscreamer.nevado.jms.connector.mock.MockSQSMessage;
import org.skyscreamer.nevado.jms.destination.NevadoQueue;
import org.skyscreamer.nevado.jms.util.RandomData;

public class MockSQSQueue
implements SQSQueue {
    private static final long DEFAULT_MESSAGE_VISIBILITY = 120000L;
    private final LinkedList<MockSQSMessage> _messageList = new LinkedList();
    private final String _queueARN = RandomData.readString();
    private final NevadoQueue _queue;
    private final MockSQSConnector _connector;
    private boolean _isDeleted = false;

    public MockSQSQueue(MockSQSConnector connector, NevadoQueue queue) {
        this._queue = queue;
        this._connector = connector;
    }

    public NevadoQueue getQueue() {
        return this._queue;
    }

    @Override
    public synchronized String sendMessage(String body) throws JMSException {
        this.checkIsDeleted();
        MockSQSMessage message = new MockSQSMessage(body);
        this._messageList.addLast(message);
        return message.getMessageId();
    }

    @Override
    public synchronized void setMessageVisibilityTimeout(String sqsReceiptHandle, int timeout) throws JMSException {
        this.checkIsDeleted();
        for (MockSQSMessage message : this._messageList) {
            if (!sqsReceiptHandle.equals(message.getReceiptHandle())) continue;
            message.setVisibleAfter(System.currentTimeMillis() + (long)timeout);
            return;
        }
        throw new JMSException("No message with receipt handle: " + sqsReceiptHandle);
    }

    @Override
    public String getQueueARN() throws JMSException {
        this.checkIsDeleted();
        return this._queueARN;
    }

    @Override
    public void setPolicy(String policy) throws JMSException {
        this.checkIsDeleted();
    }

    @Override
    public synchronized void deleteQueue() throws JMSException {
        this.checkIsDeleted();
        this._connector.removeQueue(this._queue);
        this._isDeleted = true;
    }

    @Override
    public synchronized void deleteMessage(String sqsReceiptHandle) throws JMSException {
        this.checkIsDeleted();
        MockSQSMessage messageToDelete = null;
        for (MockSQSMessage message : this._messageList) {
            if (!sqsReceiptHandle.equals(message.getReceiptHandle())) continue;
            messageToDelete = message;
            break;
        }
        if (messageToDelete == null) {
            throw new JMSException("No message with receipt handle: " + sqsReceiptHandle);
        }
        this._messageList.remove(messageToDelete);
    }

    @Override
    public synchronized SQSMessage receiveMessage() throws JMSException {
        this.checkIsDeleted();
        MockSQSMessage nextMessage = null;
        for (MockSQSMessage message : this._messageList) {
            if (!message.isVisible()) continue;
            message.setVisibleAfter(System.currentTimeMillis() + 120000L);
            nextMessage = message;
            break;
        }
        return nextMessage;
    }

    private void checkIsDeleted() throws JMSException {
        if (this._isDeleted) {
            throw new JMSException("This queue was deleted");
        }
    }
}

